/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.dataInsight;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.openmetadata.schema.dataInsight.type.PercentageOfServicesWithDescription;
import org.openmetadata.service.dataInsight.DataInsightAggregatorInterface;

public abstract class ServicesDescriptionAggregator<A, B, M, S>
implements DataInsightAggregatorInterface {
    private final A aggregations;

    protected ServicesDescriptionAggregator(A aggregations) {
        this.aggregations = aggregations;
    }

    @Override
    public List<Object> aggregate() throws ParseException {
        M timestampBuckets = this.getTimestampBuckets(this.aggregations);
        ArrayList<Object> data = new ArrayList<Object>();
        for (B timestampBucket : this.getBuckets(timestampBuckets)) {
            String dateTimeString = this.getKeyAsString(timestampBucket);
            Long timestamp = this.convertDatTimeStringToTimestamp(dateTimeString);
            M serviceBuckets = this.getServiceBuckets(timestampBucket);
            for (B serviceBucket : this.getBuckets(serviceBuckets)) {
                String serviceName = this.getKeyAsString(serviceBucket);
                S sumCompletedDescriptions = this.getSumAggregations(serviceBucket, "completedDescriptionFraction");
                S sumEntityCount = this.getSumAggregations(serviceBucket, "entityCount");
                Optional<Double> completedDescription = this.getValue(sumCompletedDescriptions);
                Optional<Double> entityCount = this.getValue(sumEntityCount);
                Double completedDescriptionFraction = completedDescription.flatMap(cdf -> entityCount.map(ec -> cdf / ec)).orElse(null);
                data.add(new PercentageOfServicesWithDescription().withTimestamp(timestamp).withServiceName(serviceName).withEntityCount((Double)entityCount.orElse(null)).withCompletedDescription((Double)completedDescription.orElse(null)).withCompletedDescriptionFraction(completedDescriptionFraction));
            }
        }
        return data;
    }

    protected abstract Optional<Double> getValue(S var1);

    protected abstract S getSumAggregations(B var1, String var2);

    protected abstract M getServiceBuckets(B var1);

    protected abstract String getKeyAsString(B var1);

    protected abstract List<? extends B> getBuckets(M var1);

    protected abstract M getTimestampBuckets(A var1);
}

