/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.dataInsight;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.openmetadata.schema.dataInsight.type.PercentageOfServicesWithOwner;
import org.openmetadata.service.dataInsight.DataInsightAggregatorInterface;

public abstract class ServicesOwnerAggregator<A, B, M, S>
implements DataInsightAggregatorInterface {
    protected final A aggregations;

    protected ServicesOwnerAggregator(A aggregations) {
        this.aggregations = aggregations;
    }

    @Override
    public List<Object> aggregate() throws ParseException {
        M timestampBuckets = this.getTimestampBuckets(this.aggregations);
        ArrayList<Object> data = new ArrayList<Object>();
        for (B timestampBucket : this.getBuckets(timestampBuckets)) {
            String dateTimeString = this.getKeyAsString(timestampBucket);
            Long timestamp = this.convertDatTimeStringToTimestamp(dateTimeString);
            M serviceBuckets = this.getServiceBuckets(timestampBucket);
            for (B serviceBucket : this.getBuckets(serviceBuckets)) {
                String serviceName = this.getKeyAsString(serviceBucket);
                S sumHasOwner = this.getSumAggregations(serviceBucket, "hasOwnerFraction");
                S sumEntityCount = this.getSumAggregations(serviceBucket, "entityCount");
                Optional<Double> entityCount = this.getValue(sumEntityCount);
                Optional<Double> hasOwner = this.getValue(sumHasOwner);
                Double hasOwnerFraction = hasOwner.flatMap(hof -> entityCount.map(ec -> hof / ec)).orElse(null);
                data.add(new PercentageOfServicesWithOwner().withTimestamp(timestamp).withServiceName(serviceName).withEntityCount((Double)entityCount.orElse(null)).withHasOwner((Double)hasOwner.orElse(null)).withHasOwnerFraction(hasOwnerFraction));
            }
        }
        return data;
    }

    protected abstract Optional<Double> getValue(S var1);

    protected abstract S getSumAggregations(B var1, String var2);

    protected abstract M getServiceBuckets(B var1);

    protected abstract String getKeyAsString(B var1);

    protected abstract List<? extends B> getBuckets(M var1);

    protected abstract M getTimestampBuckets(A var1);
}

