/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.dataInsight;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.openmetadata.schema.dataInsight.type.TotalEntitiesByTier;
import org.openmetadata.service.dataInsight.DataInsightAggregatorInterface;

public abstract class TotalEntitiesByTierAggregator<A, B, M, S>
implements DataInsightAggregatorInterface {
    private final A aggregations;

    protected TotalEntitiesByTierAggregator(A aggregations) {
        this.aggregations = aggregations;
    }

    @Override
    public List<Object> aggregate() throws ParseException {
        M timestampBuckets = this.getTimestampBuckets(this.aggregations);
        ArrayList<Object> data = new ArrayList<Object>();
        for (B timestampBucket : this.getBuckets(timestampBuckets)) {
            ArrayList<TotalEntitiesByTier> timestampData = new ArrayList<TotalEntitiesByTier>();
            double totalEntityCount = 0.0;
            String dateTimeString = this.getKeyAsString(timestampBucket);
            Long timestamp = this.convertDatTimeStringToTimestamp(dateTimeString);
            M entityTierBuckets = this.getEntityTierBuckets(timestampBucket);
            for (B entityTierBucket : this.getBuckets(entityTierBuckets)) {
                String entityTier = this.getKeyAsString(entityTierBucket);
                S sumEntityCount = this.getSumAggregations(entityTierBucket, "entityCount");
                Optional<Double> entityCount = this.getValue(sumEntityCount);
                timestampData.add(new TotalEntitiesByTier().withTimestamp(timestamp).withEntityTier(entityTier).withEntityCount((Double)entityCount.orElse(null)));
                totalEntityCount += entityCount.orElse(0.0).doubleValue();
            }
            for (TotalEntitiesByTier el : timestampData) {
                if (totalEntityCount != 0.0) {
                    el.withEntityCountFraction(Double.valueOf(el.getEntityCount() / totalEntityCount));
                } else {
                    el.withEntityCountFraction(Double.valueOf(Double.NaN));
                }
                data.add(el);
            }
        }
        return data;
    }

    protected abstract Optional<Double> getValue(S var1);

    protected abstract S getSumAggregations(B var1, String var2);

    protected abstract M getEntityTierBuckets(B var1);

    protected abstract String getKeyAsString(B var1);

    protected abstract List<? extends B> getBuckets(M var1);

    protected abstract M getTimestampBuckets(A var1);
}

