/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.events.subscription;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.ws.rs.BadRequestException;
import org.openmetadata.common.utils.CommonUtil;
import org.openmetadata.schema.api.events.CreateEventSubscription;
import org.openmetadata.schema.entity.events.Argument;
import org.openmetadata.schema.entity.events.ArgumentsInput;
import org.openmetadata.schema.entity.events.EventFilterRule;
import org.openmetadata.schema.entity.events.EventSubscription;
import org.openmetadata.schema.entity.events.EventSubscriptionOffset;
import org.openmetadata.schema.entity.events.FilteringRules;
import org.openmetadata.schema.entity.events.SubscriptionStatus;
import org.openmetadata.schema.type.ChangeEvent;
import org.openmetadata.service.Entity;
import org.openmetadata.service.events.subscription.ActivityFeedAlertCache;
import org.openmetadata.service.events.subscription.AlertsRuleEvaluator;
import org.openmetadata.service.events.subscription.EventsSubscriptionRegistry;
import org.openmetadata.service.exception.CatalogExceptionMessage;
import org.openmetadata.service.security.policyevaluator.CompiledRule;
import org.openmetadata.service.util.JsonUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.expression.Expression;

public final class AlertUtil {
    private static final Logger LOG = LoggerFactory.getLogger(AlertUtil.class);

    private AlertUtil() {
    }

    public static <T> void validateExpression(String condition, Class<T> clz) {
        if (condition == null) {
            return;
        }
        Expression expression = CompiledRule.parseExpression(condition);
        AlertsRuleEvaluator ruleEvaluator = new AlertsRuleEvaluator(null);
        try {
            expression.getValue((Object)ruleEvaluator, clz);
        }
        catch (Exception exception) {
            String message = exception.getMessage().replaceAll("on type .*$", "").replaceAll("on object .*$", "");
            throw new IllegalArgumentException(CatalogExceptionMessage.failedToEvaluate(message));
        }
    }

    public static boolean evaluateAlertConditions(ChangeEvent changeEvent, List<EventFilterRule> alertFilterRules) {
        if (!alertFilterRules.isEmpty()) {
            String completeCondition = AlertUtil.buildCompleteCondition(alertFilterRules);
            AlertsRuleEvaluator ruleEvaluator = new AlertsRuleEvaluator(changeEvent);
            Expression expression = CompiledRule.parseExpression(completeCondition);
            boolean result = Boolean.TRUE.equals(expression.getValue((Object)ruleEvaluator, Boolean.class));
            LOG.debug("Alert evaluated as Result : {}", (Object)result);
            return result;
        }
        return true;
    }

    public static String buildCompleteCondition(List<EventFilterRule> alertFilterRules) {
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < alertFilterRules.size(); ++i) {
            EventFilterRule rule = alertFilterRules.get(i);
            builder.append("(");
            if (rule.getEffect() == ArgumentsInput.Effect.INCLUDE) {
                builder.append(rule.getCondition());
            } else {
                builder.append("!");
                builder.append(rule.getCondition());
            }
            builder.append(")");
            if (i == alertFilterRules.size() - 1) continue;
            builder.append(" && ");
        }
        return builder.toString();
    }

    public static boolean shouldTriggerAlert(String entityType, FilteringRules config) {
        if (config == null) {
            return false;
        }
        if (config.getResources().size() == 1 && ((String)config.getResources().get(0)).equals("all")) {
            return true;
        }
        if (entityType.equals("THREAD") && (((String)config.getResources().get(0)).equals("announcement") || ((String)config.getResources().get(0)).equals("task") || ((String)config.getResources().get(0)).equals("conversation"))) {
            return true;
        }
        return config.getResources().contains(entityType);
    }

    public static boolean shouldProcessActivityFeedRequest(ChangeEvent event) {
        FilteringRules filteringRules = ActivityFeedAlertCache.getActivityFeedAlert().getFilteringRules();
        return AlertUtil.shouldTriggerAlert(event.getEntityType(), filteringRules) && AlertUtil.evaluateAlertConditions(event, filteringRules.getRules());
    }

    public static SubscriptionStatus buildSubscriptionStatus(SubscriptionStatus.Status status, Long lastSuccessful, Long lastFailure, Integer statusCode, String reason, Long nextAttempt, Long timeStamp) {
        return new SubscriptionStatus().withStatus(status).withLastSuccessfulAt(lastSuccessful).withLastFailedAt(lastFailure).withLastFailedStatusCode(statusCode).withLastFailedReason(reason).withNextAttempt(nextAttempt).withTimestamp(timeStamp);
    }

    public static Map<ChangeEvent, Set<UUID>> getFilteredEvents(EventSubscription eventSubscription, Map<ChangeEvent, Set<UUID>> events) {
        return events.entrySet().stream().filter(entry -> AlertUtil.checkIfChangeEventIsAllowed((ChangeEvent)entry.getKey(), eventSubscription.getFilteringRules())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    private static boolean checkIfChangeEventIsAllowed(ChangeEvent event, FilteringRules filteringRules) {
        boolean triggerChangeEvent = AlertUtil.shouldTriggerAlert(event.getEntityType(), filteringRules);
        if (triggerChangeEvent && (triggerChangeEvent = AlertUtil.evaluateAlertConditions(event, filteringRules.getRules()))) {
            triggerChangeEvent = AlertUtil.evaluateAlertConditions(event, filteringRules.getActions());
        }
        return triggerChangeEvent;
    }

    public static EventSubscriptionOffset getStartingOffset(UUID eventSubscriptionId) {
        long eventSubscriptionOffset;
        String json = Entity.getCollectionDAO().eventSubscriptionDAO().getSubscriberExtension(eventSubscriptionId.toString(), "eventSubscription.Offset");
        if (json != null) {
            EventSubscriptionOffset offsetFromDb = JsonUtils.readValue(json, EventSubscriptionOffset.class);
            eventSubscriptionOffset = offsetFromDb.getOffset();
        } else {
            eventSubscriptionOffset = Entity.getCollectionDAO().changeEventDAO().getLatestOffset();
        }
        return new EventSubscriptionOffset().withOffset(Long.valueOf(eventSubscriptionOffset));
    }

    public static FilteringRules validateAndBuildFilteringConditions(CreateEventSubscription createEventSubscription) {
        ArrayList finalRules = new ArrayList();
        ArrayList actions = new ArrayList();
        List resource = createEventSubscription.getResources();
        if (resource.size() > 1) {
            throw new BadRequestException("Only one resource can be specified. Multiple resources are not supported.");
        }
        if (createEventSubscription.getAlertType().equals((Object)CreateEventSubscription.AlertType.NOTIFICATION)) {
            Map<String, EventFilterRule> supportedFilters = EventsSubscriptionRegistry.getEntityNotificationDescriptor((String)resource.get(0)).getSupportedFilters().stream().collect(Collectors.toMap(EventFilterRule::getName, eventFilterRule -> JsonUtils.deepCopy(eventFilterRule, EventFilterRule.class)));
            if (createEventSubscription.getInput() != null) {
                CommonUtil.listOrEmpty((List)createEventSubscription.getInput().getFilters()).forEach(argumentsInput -> finalRules.add(AlertUtil.getFilterRule(supportedFilters, argumentsInput, AlertUtil.buildInputArgumentsMap(argumentsInput))));
            }
            return new FilteringRules().withResources(resource).withRules(finalRules).withActions(Collections.emptyList());
        }
        if (createEventSubscription.getAlertType().equals((Object)CreateEventSubscription.AlertType.OBSERVABILITY)) {
            Map<String, EventFilterRule> supportedFilters = EventsSubscriptionRegistry.getObservabilityDescriptor((String)resource.get(0)).getSupportedFilters().stream().collect(Collectors.toMap(EventFilterRule::getName, eventFilterRule -> JsonUtils.deepCopy(eventFilterRule, EventFilterRule.class)));
            Map<String, EventFilterRule> supportedActions = EventsSubscriptionRegistry.getObservabilityDescriptor((String)resource.get(0)).getSupportedActions().stream().collect(Collectors.toMap(EventFilterRule::getName, eventFilterRule -> JsonUtils.deepCopy(eventFilterRule, EventFilterRule.class)));
            if (createEventSubscription.getInput() != null) {
                CommonUtil.listOrEmpty((List)createEventSubscription.getInput().getFilters()).forEach(argumentsInput -> finalRules.add(AlertUtil.getFilterRule(supportedFilters, argumentsInput, AlertUtil.buildInputArgumentsMap(argumentsInput))));
                CommonUtil.listOrEmpty((List)createEventSubscription.getInput().getActions()).forEach(argumentsInput -> actions.add(AlertUtil.getFilterRule(supportedActions, argumentsInput, AlertUtil.buildInputArgumentsMap(argumentsInput))));
            }
            return new FilteringRules().withResources(resource).withRules(finalRules).withActions(actions);
        }
        return null;
    }

    private static Map<String, List<String>> buildInputArgumentsMap(ArgumentsInput filter) {
        return filter.getArguments().stream().collect(Collectors.toMap(Argument::getName, Argument::getInput));
    }

    private static EventFilterRule getFilterRule(Map<String, EventFilterRule> supportedFilters, ArgumentsInput filterDetails, Map<String, List<String>> inputArgMap) {
        if (!supportedFilters.containsKey(filterDetails.getName())) {
            throw new BadRequestException("Give Resource doesn't support the filter " + filterDetails.getName());
        }
        EventFilterRule rule = supportedFilters.get(filterDetails.getName()).withEffect(filterDetails.getEffect());
        if (rule.getInputType().equals((Object)EventFilterRule.InputType.NONE)) {
            return rule;
        }
        String formulatedCondition = rule.getCondition();
        for (String argName : rule.getArguments()) {
            List<String> inputList = inputArgMap.get(argName);
            if (CommonUtil.nullOrEmpty(inputList)) {
                throw new BadRequestException("Input for argument " + argName + " is missing");
            }
            formulatedCondition = formulatedCondition.replace(String.format("${%s}", argName), String.format("{%s}", AlertUtil.convertInputListToString(inputList)));
        }
        return rule.withCondition(formulatedCondition);
    }

    public static String convertInputListToString(List<String> valueList) {
        if (CommonUtil.nullOrEmpty(valueList)) {
            return "";
        }
        StringBuilder result = new StringBuilder();
        result.append("'").append(valueList.get(0)).append("'");
        for (int i = 1; i < valueList.size(); ++i) {
            result.append(",'").append(valueList.get(i)).append("'");
        }
        return result.toString();
    }
}

