/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.events.subscription;

import java.util.List;
import java.util.Set;
import java.util.UUID;
import org.openmetadata.common.utils.CommonUtil;
import org.openmetadata.schema.EntityInterface;
import org.openmetadata.schema.Function;
import org.openmetadata.schema.entity.feed.Thread;
import org.openmetadata.schema.entity.services.ingestionPipelines.PipelineStatus;
import org.openmetadata.schema.entity.services.ingestionPipelines.PipelineStatusType;
import org.openmetadata.schema.entity.teams.Team;
import org.openmetadata.schema.entity.teams.User;
import org.openmetadata.schema.tests.TestCase;
import org.openmetadata.schema.tests.type.TestCaseResult;
import org.openmetadata.schema.tests.type.TestCaseStatus;
import org.openmetadata.schema.type.ChangeEvent;
import org.openmetadata.schema.type.EntityReference;
import org.openmetadata.schema.type.FieldChange;
import org.openmetadata.schema.type.Function;
import org.openmetadata.schema.type.Include;
import org.openmetadata.schema.type.Post;
import org.openmetadata.schema.type.ThreadType;
import org.openmetadata.service.Entity;
import org.openmetadata.service.formatter.util.FormatterUtil;
import org.openmetadata.service.resources.feeds.MessageParser;
import org.openmetadata.service.util.JsonUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AlertsRuleEvaluator {
    private static final Logger LOG = LoggerFactory.getLogger(AlertsRuleEvaluator.class);
    private final ChangeEvent changeEvent;

    public AlertsRuleEvaluator(ChangeEvent event) {
        this.changeEvent = event;
    }

    @Function(name="matchAnySource", input="List of comma separated source", description="Returns true if the change event entity being accessed has source as mentioned in condition", examples={"matchAnySource({'bot', 'user'})"}, paramInputType=Function.ParameterType.READ_FROM_PARAM_CONTEXT)
    public boolean matchAnySource(List<String> originEntities) {
        if (this.changeEvent == null || this.changeEvent.getEntityType() == null) {
            return false;
        }
        if (this.changeEvent.getEntityType().equals("THREAD")) {
            return true;
        }
        String changeEventEntity = this.changeEvent.getEntityType();
        for (String entityType : originEntities) {
            if (!changeEventEntity.equals(entityType)) continue;
            return true;
        }
        return false;
    }

    @Function(name="matchAnyOwnerName", input="List of comma separated ownerName", description="Returns true if the change event entity being accessed has following owners from the List.", examples={"matchAnyOwnerName({'Owner1', 'Owner2'})"}, paramInputType=Function.ParameterType.SPECIFIC_INDEX_ELASTIC_SEARCH)
    public boolean matchAnyOwnerName(List<String> ownerNameList) {
        block5: {
            EntityReference ownerReference;
            block6: {
                if (this.changeEvent == null || this.changeEvent.getEntity() == null) {
                    return false;
                }
                if (this.changeEvent.getEntityType().equals("THREAD")) {
                    return true;
                }
                EntityInterface entity = AlertsRuleEvaluator.getEntity(this.changeEvent);
                ownerReference = entity.getOwner();
                if (ownerReference == null) {
                    entity = (EntityInterface)Entity.getEntity(this.changeEvent.getEntityType(), entity.getId(), "owner", Include.NON_DELETED);
                    ownerReference = entity.getOwner();
                }
                if (ownerReference == null) break block5;
                if (!"user".equals(ownerReference.getType())) break block6;
                User user = (User)Entity.getEntity("user", ownerReference.getId(), "", Include.NON_DELETED);
                for (String name : ownerNameList) {
                    if (!user.getName().equals(name)) continue;
                    return true;
                }
                break block5;
            }
            if (!"team".equals(ownerReference.getType())) break block5;
            Team team = (Team)Entity.getEntity("team", ownerReference.getId(), "", Include.NON_DELETED);
            for (String name : ownerNameList) {
                if (!team.getName().equals(name)) continue;
                return true;
            }
        }
        return false;
    }

    @Function(name="matchAnyEntityFqn", input="List of comma separated entityName", description="Returns true if the change event entity being accessed has following entityName from the List.", examples={"matchAnyEntityFqn({'FQN1', 'FQN2'})"}, paramInputType=Function.ParameterType.ALL_INDEX_ELASTIC_SEARCH)
    public boolean matchAnyEntityFqn(List<String> entityNames) {
        if (this.changeEvent == null || this.changeEvent.getEntity() == null) {
            return false;
        }
        if (this.changeEvent.getEntityType().equals("THREAD")) {
            return true;
        }
        EntityInterface entity = AlertsRuleEvaluator.getEntity(this.changeEvent);
        for (String name : entityNames) {
            if (!entity.getFullyQualifiedName().equals(name)) continue;
            return true;
        }
        return false;
    }

    @Function(name="matchAnyEntityId", input="List of comma separated entity Ids", description="Returns true if the change event entity being accessed has following entityId from the List.", examples={"matchAnyEntityId({'uuid1', 'uuid2'})"}, paramInputType=Function.ParameterType.ALL_INDEX_ELASTIC_SEARCH)
    public boolean matchAnyEntityId(List<String> entityIds) {
        if (this.changeEvent == null || this.changeEvent.getEntity() == null) {
            return false;
        }
        if (this.changeEvent.getEntityType().equals("THREAD")) {
            return true;
        }
        EntityInterface entity = AlertsRuleEvaluator.getEntity(this.changeEvent);
        for (String id : entityIds) {
            if (!entity.getId().equals(UUID.fromString(id))) continue;
            return true;
        }
        return false;
    }

    @Function(name="matchAnyEventType", input="List of comma separated eventTypes", description="Returns true if the change event entity being accessed has following entityId from the List.", examples={"matchAnyEventType('entityCreated', 'entityUpdated', 'entityDeleted', 'entitySoftDeleted')"}, paramInputType=Function.ParameterType.READ_FROM_PARAM_CONTEXT)
    public boolean matchAnyEventType(List<String> eventTypesList) {
        if (this.changeEvent == null || this.changeEvent.getEventType() == null) {
            return false;
        }
        String eventType = this.changeEvent.getEventType().toString();
        for (String type : eventTypesList) {
            if (!eventType.equals(type)) continue;
            return true;
        }
        return false;
    }

    @Function(name="matchTestResult", input="List of comma separated eventTypes", description="Returns true if the change event entity being accessed has following entityId from the List.", examples={"matchTestResult({'Success', 'Failed', 'Aborted'})"}, paramInputType=Function.ParameterType.READ_FROM_PARAM_CONTEXT)
    public boolean matchTestResult(List<String> testResults) {
        if (this.changeEvent == null || this.changeEvent.getChangeDescription() == null) {
            return false;
        }
        if (!this.changeEvent.getEntityType().equals("testCase")) {
            return true;
        }
        List fieldChanges = this.changeEvent.getChangeDescription().getFieldsUpdated();
        if (!this.changeEvent.getChangeDescription().getFieldsAdded().isEmpty()) {
            fieldChanges.addAll(this.changeEvent.getChangeDescription().getFieldsAdded());
        }
        for (FieldChange fieldChange : fieldChanges) {
            if (!fieldChange.getName().equals("testCaseResult") || fieldChange.getNewValue() == null) continue;
            TestCaseResult testCaseResult = JsonUtils.readOrConvertValue(fieldChange.getNewValue(), TestCaseResult.class);
            TestCaseStatus status = testCaseResult.getTestCaseStatus();
            for (String givenStatus : testResults) {
                if (!givenStatus.equalsIgnoreCase(status.value())) continue;
                return true;
            }
        }
        return false;
    }

    @Function(name="filterByTableNameTestCaseBelongsTo", input="List of comma separated Test Suite", description="Returns true if the change event entity being accessed has following entityId from the List.", examples={"filterByTableNameTestCaseBelongsTo({'tableName1', 'tableName2'})"}, paramInputType=Function.ParameterType.READ_FROM_PARAM_CONTEXT)
    public boolean filterByTableNameTestCaseBelongsTo(List<String> tableNameList) {
        if (this.changeEvent == null) {
            return false;
        }
        if (!this.changeEvent.getEntityType().equals("testCase")) {
            return true;
        }
        if (this.changeEvent.getEntityType().equals("THREAD")) {
            return true;
        }
        EntityInterface entity = AlertsRuleEvaluator.getEntity(this.changeEvent);
        for (String name : tableNameList) {
            if (!entity.getFullyQualifiedName().contains(name)) continue;
            return true;
        }
        return false;
    }

    @Function(name="getTestCaseStatusIfInTestSuite", input="List of comma separated Test Suite", description="Returns true if the change event entity being accessed has following entityId from the List.", examples={"getTestCaseStatusIfInTestSuite({'testSuite1','testSuite2'}, {'Success', 'Failed', 'Aborted'})"}, paramInputType=Function.ParameterType.READ_FROM_PARAM_CONTEXT)
    public boolean getTestCaseStatusIfInTestSuite(List<String> testSuiteList, List<String> testResults) {
        if (this.changeEvent == null || this.changeEvent.getChangeDescription() == null) {
            return false;
        }
        if (!this.changeEvent.getEntityType().equals("testCase")) {
            return true;
        }
        if (this.changeEvent.getEntityType().equals("THREAD")) {
            return true;
        }
        EntityInterface entity = AlertsRuleEvaluator.getEntity(this.changeEvent);
        TestCase entityWithTestSuite = (TestCase)Entity.getEntity(this.changeEvent.getEntityType(), entity.getId(), "testSuites", Include.NON_DELETED);
        boolean testSuiteFiltering = CommonUtil.listOrEmpty((List)entityWithTestSuite.getTestSuites()).stream().anyMatch(testSuite -> testSuiteList.stream().anyMatch(name -> testSuite.getFullyQualifiedName().equals(name)));
        if (testSuiteFiltering) {
            return this.matchTestResult(testResults);
        }
        return false;
    }

    @Function(name="matchUpdatedBy", input="List of comma separated user names that updated the entity", description="Returns true if the change event entity is updated by the mentioned users", examples={"matchUpdatedBy({'user1', 'user2'})"}, paramInputType=Function.ParameterType.READ_FROM_PARAM_CONTEXT)
    public boolean matchUpdatedBy(List<String> updatedByUserList) {
        if (this.changeEvent == null || this.changeEvent.getUserName() == null) {
            return false;
        }
        String entityUpdatedBy = this.changeEvent.getUserName();
        for (String name : updatedByUserList) {
            if (!name.equals(entityUpdatedBy)) continue;
            return true;
        }
        return false;
    }

    @Function(name="matchIngestionPipelineState", input="List of comma separated pipeline states", description="Returns true if the change event entity being accessed has following entityId from the List.", examples={"matchIngestionPipelineState({'queued', 'success', 'failed', 'running', 'partialSuccess'})"}, paramInputType=Function.ParameterType.READ_FROM_PARAM_CONTEXT)
    public boolean matchIngestionPipelineState(List<String> pipelineState) {
        if (this.changeEvent == null || this.changeEvent.getChangeDescription() == null) {
            return false;
        }
        if (!this.changeEvent.getEntityType().equals("ingestionPipeline")) {
            return true;
        }
        if (this.changeEvent.getEntityType().equals("THREAD")) {
            return true;
        }
        for (FieldChange fieldChange : this.changeEvent.getChangeDescription().getFieldsUpdated()) {
            if (!fieldChange.getName().equals("pipelineStatus") || fieldChange.getNewValue() == null) continue;
            PipelineStatus pipelineStatus = JsonUtils.convertValue(fieldChange.getNewValue(), PipelineStatus.class);
            PipelineStatusType status = pipelineStatus.getPipelineState();
            for (String givenStatus : pipelineState) {
                if (!givenStatus.equals(status.value())) continue;
                return true;
            }
        }
        return false;
    }

    @Function(name="matchAnyFieldChange", input="List of comma separated fields change", description="Returns true if the change event entity is updated by the mentioned users", examples={"matchAnyFieldChange({'fieldName1', 'fieldName'})"}, paramInputType=Function.ParameterType.READ_FROM_PARAM_CONTEXT_PER_ENTITY)
    public boolean matchAnyFieldChange(List<String> fieldChangeUpdate) {
        if (this.changeEvent == null || this.changeEvent.getChangeDescription() == null) {
            return false;
        }
        Set<String> fields = FormatterUtil.getUpdatedField(this.changeEvent);
        for (String name : fieldChangeUpdate) {
            if (!fields.contains(name)) continue;
            return true;
        }
        return false;
    }

    @Function(name="matchAnyDomain", input="List of comma separated Domains", description="Returns true if the change event entity belongs to a domain from the list", examples={"matchAnyDomain({'domain1', 'domain2'})"}, paramInputType=Function.ParameterType.SPECIFIC_INDEX_ELASTIC_SEARCH)
    public boolean matchAnyDomain(List<String> fieldChangeUpdate) {
        if (this.changeEvent == null) {
            return false;
        }
        if (this.changeEvent.getEntityType().equals("THREAD")) {
            return true;
        }
        if (this.changeEvent.getEntityType().equals("THREAD")) {
            return true;
        }
        EntityInterface entity = AlertsRuleEvaluator.getEntity(this.changeEvent);
        EntityInterface entityWithDomainData = (EntityInterface)Entity.getEntity(this.changeEvent.getEntityType(), entity.getId(), "domain", Include.NON_DELETED);
        if (entityWithDomainData.getDomain() != null) {
            for (String name : fieldChangeUpdate) {
                if (!entityWithDomainData.getDomain().getFullyQualifiedName().equals(name)) continue;
                return true;
            }
        }
        return false;
    }

    public static EntityInterface getEntity(ChangeEvent event) {
        Class<? extends EntityInterface> entityClass = Entity.getEntityClassFromType(event.getEntityType());
        if (entityClass != null) {
            EntityInterface entity;
            Object object = event.getEntity();
            if (object instanceof String) {
                String str = (String)object;
                entity = JsonUtils.readValue(str, entityClass);
            } else {
                entity = JsonUtils.convertValue(event.getEntity(), entityClass);
            }
            return entity;
        }
        throw new IllegalArgumentException(String.format("Change Event Data Asset is not an entity %s", JsonUtils.pojoToJson(event.getEntity())));
    }

    @Function(name="matchConversationUser", input="List of comma separated user names to matchConversationUser", description="Returns true if the conversation mentions the user names in the list", examples={"matchConversationUser({'user1', 'user2'})"}, paramInputType=Function.ParameterType.READ_FROM_PARAM_CONTEXT)
    public boolean matchConversationUser(List<String> usersOrTeamName) {
        List<MessageParser.EntityLink> mentions;
        if (this.changeEvent == null || this.changeEvent.getEntityType() == null) {
            return false;
        }
        if (!this.changeEvent.getEntityType().equals("THREAD")) {
            return false;
        }
        if (usersOrTeamName.size() == 1 && usersOrTeamName.get(0).equals("all")) {
            return true;
        }
        Thread thread = AlertsRuleEvaluator.getThread(this.changeEvent);
        if (!thread.getType().equals((Object)ThreadType.Conversation)) {
            return false;
        }
        if (thread.getPostsCount() == 0) {
            mentions = MessageParser.getEntityLinks(thread.getMessage());
        } else {
            Post latestPost = (Post)thread.getPosts().get(thread.getPostsCount() - 1);
            mentions = MessageParser.getEntityLinks(latestPost.getMessage());
        }
        for (MessageParser.EntityLink entityLink : mentions) {
            Team team;
            User user;
            String fqn = entityLink.getEntityFQN();
            if (!("user".equals(entityLink.getEntityType()) ? usersOrTeamName.contains((user = (User)Entity.getCollectionDAO().userDAO().findEntityByName(fqn)).getName()) : "team".equals(entityLink.getEntityType()) && usersOrTeamName.contains((team = (Team)Entity.getCollectionDAO().teamDAO().findEntityByName(fqn)).getName()))) continue;
            return true;
        }
        return false;
    }

    public static Thread getThread(ChangeEvent event) {
        try {
            Thread thread;
            Object object = event.getEntity();
            if (object instanceof String) {
                String str = (String)object;
                thread = JsonUtils.readValue(str, Thread.class);
            } else {
                thread = JsonUtils.convertValue(event.getEntity(), Thread.class);
            }
            return thread;
        }
        catch (Exception ex) {
            throw new IllegalArgumentException(String.format("Change Event Data Asset is not an Thread %s", JsonUtils.pojoToJson(event.getEntity())));
        }
    }
}

