/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.formatter.field;

import org.openmetadata.service.formatter.decorators.MessageDecorator;
import org.openmetadata.service.formatter.field.FieldFormatter;
import org.openmetadata.service.formatter.util.FormatterUtil;
import org.openmetadata.service.resources.feeds.MessageParser;

public class DefaultFieldFormatter
implements FieldFormatter {
    private final String fieldChangeName;
    private final String fieldOldValue;
    private final String fieldNewValue;
    private final MessageParser.EntityLink entityLink;
    private final MessageDecorator<?> messageDecorator;

    public DefaultFieldFormatter(MessageDecorator<?> messageDecorator, String fieldOldValue, String fieldNewValue, String fieldChangeName, MessageParser.EntityLink entityLink) {
        this.messageDecorator = messageDecorator;
        this.fieldChangeName = fieldChangeName;
        this.fieldOldValue = fieldOldValue;
        this.fieldNewValue = fieldNewValue;
        this.entityLink = entityLink;
    }

    @Override
    public String getFieldChangeName() {
        return this.fieldChangeName;
    }

    @Override
    public String getFieldOldValue() {
        return this.fieldOldValue;
    }

    @Override
    public String getFieldNewValue() {
        return this.fieldNewValue;
    }

    @Override
    public String getFormattedMessage(FormatterUtil.CHANGE_TYPE changeType) {
        String message = "";
        switch (changeType) {
            case ADD: {
                message = this.formatAddedField();
                break;
            }
            case UPDATE: {
                message = this.formatUpdatedField();
                break;
            }
            case DELETE: {
                message = this.formatDeletedField();
            }
        }
        return message;
    }

    @Override
    public MessageDecorator<?> getMessageDecorator() {
        return this.messageDecorator;
    }

    @Override
    public MessageParser.EntityLink getEntityLink() {
        return this.entityLink;
    }

    @Override
    public String formatAddedField() {
        Object message = this.messageDecorator.httpAddMarker() + this.fieldNewValue + this.messageDecorator.httpAddMarker();
        message = String.format("Added " + this.messageDecorator.getBold() + ": %s", this.fieldChangeName, message);
        String spanAdd = this.messageDecorator.getAddMarker();
        String spanAddClose = this.messageDecorator.getAddMarkerClose();
        if (message != null) {
            message = this.messageDecorator.replaceMarkers((String)message, this.messageDecorator.httpAddMarker(), spanAdd, spanAddClose);
        }
        return message;
    }

    @Override
    public String formatUpdatedField() {
        String message = this.messageDecorator.getPlaintextDiff(this.fieldOldValue, this.fieldNewValue);
        message = String.format("Updated %s: %s", this.messageDecorator.getBold(), message);
        return String.format(message, this.fieldChangeName);
    }

    @Override
    public String formatDeletedField() {
        Object message = this.messageDecorator.httpRemoveMarker() + this.fieldOldValue + this.messageDecorator.httpRemoveMarker();
        message = String.format("Deleted " + this.messageDecorator.getBold() + ": %s", this.fieldChangeName, message);
        String spanRemove = this.messageDecorator.getRemoveMarker();
        String spanRemoveClose = this.messageDecorator.getRemoveMarkerClose();
        if (message != null) {
            message = this.messageDecorator.replaceMarkers((String)message, this.messageDecorator.httpRemoveMarker(), spanRemove, spanRemoveClose);
        }
        return message;
    }
}

