/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.jdbi3;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import java.util.Optional;
import org.jdbi.v3.core.mapper.RowMapper;
import org.jdbi.v3.core.statement.StatementContext;
import org.jdbi.v3.core.statement.StatementException;
import org.jdbi.v3.sqlobject.SingleValue;
import org.jdbi.v3.sqlobject.config.RegisterRowMapper;
import org.jdbi.v3.sqlobject.customizer.Bind;
import org.jdbi.v3.sqlobject.statement.SqlQuery;
import org.openmetadata.service.jdbi3.locator.ConnectionAwareSqlQuery;
import org.openmetadata.service.jdbi3.locator.ConnectionAwareSqlQueryContainer;
import org.openmetadata.service.jdbi3.locator.ConnectionAwareSqlUpdate;
import org.openmetadata.service.jdbi3.locator.ConnectionAwareSqlUpdateContainer;
import org.openmetadata.service.jdbi3.locator.ConnectionType;

public interface MigrationDAO {
    @ConnectionAwareSqlQueryContainer(value={@ConnectionAwareSqlQuery(value="SELECT MAX(version) FROM DATABASE_CHANGE_LOG", connectionType=ConnectionType.MYSQL), @ConnectionAwareSqlQuery(value="SELECT max(version) FROM \"DATABASE_CHANGE_LOG\"", connectionType=ConnectionType.POSTGRES)})
    @SingleValue
    public Optional<String> getMaxVersion() throws StatementException;

    @ConnectionAwareSqlQueryContainer(value={@ConnectionAwareSqlQuery(value="SELECT MAX(version) FROM SERVER_CHANGE_LOG", connectionType=ConnectionType.MYSQL), @ConnectionAwareSqlQuery(value="SELECT max(version) FROM SERVER_CHANGE_LOG", connectionType=ConnectionType.POSTGRES)})
    @SingleValue
    public Optional<String> getMaxServerMigrationVersion() throws StatementException;

    @ConnectionAwareSqlQueryContainer(value={@ConnectionAwareSqlQuery(value="SELECT checksum FROM SERVER_CHANGE_LOG where version = :version", connectionType=ConnectionType.MYSQL), @ConnectionAwareSqlQuery(value="SELECT checksum FROM SERVER_CHANGE_LOG where version = :version", connectionType=ConnectionType.POSTGRES)})
    public String getVersionMigrationChecksum(@Bind(value="version") String var1) throws StatementException;

    @ConnectionAwareSqlQueryContainer(value={@ConnectionAwareSqlQuery(value="SELECT sqlStatement FROM SERVER_MIGRATION_SQL_LOGS where version = :version and checksum = :checksum", connectionType=ConnectionType.MYSQL), @ConnectionAwareSqlQuery(value="SELECT sqlStatement FROM SERVER_MIGRATION_SQL_LOGS where version = :version and checksum = :checksum", connectionType=ConnectionType.POSTGRES)})
    public String getSqlQuery(@Bind(value="version") String var1, @Bind(value="checksum") String var2) throws StatementException;

    @ConnectionAwareSqlUpdateContainer(value={@ConnectionAwareSqlUpdate(value="INSERT INTO SERVER_CHANGE_LOG (version, migrationFileName, checksum, metrics, installed_on)VALUES (:version, :migrationFileName, :checksum, :metrics, CURRENT_TIMESTAMP) ON DUPLICATE KEY UPDATE migrationFileName = :migrationFileName, checksum = :checksum, metrics = :metrics,installed_on = CURRENT_TIMESTAMP", connectionType=ConnectionType.MYSQL), @ConnectionAwareSqlUpdate(value="INSERT INTO server_change_log (version, migrationFileName, checksum, metrics, installed_on)VALUES (:version, :migrationFileName, :checksum, to_jsonb(:metrics::text), current_timestamp) ON CONFLICT (version) DO UPDATE SET migrationFileName = EXCLUDED.migrationFileName, metrics = to_jsonb(:metrics::text),checksum = EXCLUDED.checksum, installed_on = EXCLUDED.installed_on", connectionType=ConnectionType.POSTGRES)})
    public void upsertServerMigration(@Bind(value="version") String var1, @Bind(value="migrationFileName") String var2, @Bind(value="checksum") String var3, @Bind(value="metrics") String var4);

    @ConnectionAwareSqlUpdateContainer(value={@ConnectionAwareSqlUpdate(value="INSERT INTO SERVER_MIGRATION_SQL_LOGS (version, sqlStatement, checksum, executedAt)VALUES (:version, :sqlStatement, :checksum, CURRENT_TIMESTAMP) ON DUPLICATE KEY UPDATE version = :version, sqlStatement = :sqlStatement, executedAt = CURRENT_TIMESTAMP", connectionType=ConnectionType.MYSQL), @ConnectionAwareSqlUpdate(value="INSERT INTO SERVER_MIGRATION_SQL_LOGS (version, sqlStatement, checksum, executedAt)VALUES (:version, :sqlStatement, :checksum, current_timestamp) ON CONFLICT (checksum) DO UPDATE SET version = EXCLUDED.version, sqlStatement = EXCLUDED.sqlStatement, executedAt = EXCLUDED.executedAt", connectionType=ConnectionType.POSTGRES)})
    public void upsertServerMigrationSQL(@Bind(value="version") String var1, @Bind(value="sqlStatement") String var2, @Bind(value="checksum") String var3);

    @ConnectionAwareSqlQueryContainer(value={@ConnectionAwareSqlQuery(value="SELECT checksum FROM SERVER_MIGRATION_SQL_LOGS where version = :version", connectionType=ConnectionType.MYSQL), @ConnectionAwareSqlQuery(value="SELECT checksum FROM SERVER_MIGRATION_SQL_LOGS where version = :version", connectionType=ConnectionType.POSTGRES)})
    public List<String> getServerMigrationSQLWithVersion(@Bind(value="version") String var1);

    @ConnectionAwareSqlQueryContainer(value={@ConnectionAwareSqlQuery(value="SELECT sqlStatement FROM SERVER_MIGRATION_SQL_LOGS where checksum = :checksum", connectionType=ConnectionType.MYSQL), @ConnectionAwareSqlQuery(value="SELECT sqlStatement FROM SERVER_MIGRATION_SQL_LOGS where checksum = :checksum", connectionType=ConnectionType.POSTGRES)})
    public String checkIfQueryPreviouslyRan(@Bind(value="checksum") String var1);

    @SqlQuery(value="SELECT installed_rank, version, migrationFileName, checksum, installed_on, metrics FROM SERVER_CHANGE_LOG ORDER BY version ASC")
    @RegisterRowMapper(value=FromServerChangeLogMapper.class)
    public List<ServerChangeLog> listMetricsFromDBMigrations();

    public static class FromServerChangeLogMapper
    implements RowMapper<ServerChangeLog> {
        public ServerChangeLog map(ResultSet rs, StatementContext ctx) throws SQLException {
            return ServerChangeLog.builder().installedRank(rs.getInt("installed_rank")).version(rs.getString("version")).migrationFileName(rs.getString("migrationFileName")).checksum(rs.getString("checksum")).installedOn(rs.getString("installed_on")).metrics(rs.getString("metrics")).build();
        }
    }

    public static class ServerChangeLog {
        private Integer installedRank;
        private String version;
        private String migrationFileName;
        private String checksum;
        private String installedOn;
        private String metrics;

        ServerChangeLog(Integer installedRank, String version, String migrationFileName, String checksum, String installedOn, String metrics) {
            this.installedRank = installedRank;
            this.version = version;
            this.migrationFileName = migrationFileName;
            this.checksum = checksum;
            this.installedOn = installedOn;
            this.metrics = metrics;
        }

        public static ServerChangeLogBuilder builder() {
            return new ServerChangeLogBuilder();
        }

        public Integer getInstalledRank() {
            return this.installedRank;
        }

        public String getVersion() {
            return this.version;
        }

        public String getMigrationFileName() {
            return this.migrationFileName;
        }

        public String getChecksum() {
            return this.checksum;
        }

        public String getInstalledOn() {
            return this.installedOn;
        }

        public String getMetrics() {
            return this.metrics;
        }

        public void setInstalledRank(Integer installedRank) {
            this.installedRank = installedRank;
        }

        public void setVersion(String version) {
            this.version = version;
        }

        public void setMigrationFileName(String migrationFileName) {
            this.migrationFileName = migrationFileName;
        }

        public void setChecksum(String checksum) {
            this.checksum = checksum;
        }

        public void setInstalledOn(String installedOn) {
            this.installedOn = installedOn;
        }

        public void setMetrics(String metrics) {
            this.metrics = metrics;
        }

        public static class ServerChangeLogBuilder {
            private Integer installedRank;
            private String version;
            private String migrationFileName;
            private String checksum;
            private String installedOn;
            private String metrics;

            ServerChangeLogBuilder() {
            }

            public ServerChangeLogBuilder installedRank(Integer installedRank) {
                this.installedRank = installedRank;
                return this;
            }

            public ServerChangeLogBuilder version(String version) {
                this.version = version;
                return this;
            }

            public ServerChangeLogBuilder migrationFileName(String migrationFileName) {
                this.migrationFileName = migrationFileName;
                return this;
            }

            public ServerChangeLogBuilder checksum(String checksum) {
                this.checksum = checksum;
                return this;
            }

            public ServerChangeLogBuilder installedOn(String installedOn) {
                this.installedOn = installedOn;
                return this;
            }

            public ServerChangeLogBuilder metrics(String metrics) {
                this.metrics = metrics;
                return this;
            }

            public ServerChangeLog build() {
                return new ServerChangeLog(this.installedRank, this.version, this.migrationFileName, this.checksum, this.installedOn, this.metrics);
            }

            public String toString() {
                return "MigrationDAO.ServerChangeLog.ServerChangeLogBuilder(installedRank=" + this.installedRank + ", version=" + this.version + ", migrationFileName=" + this.migrationFileName + ", checksum=" + this.checksum + ", installedOn=" + this.installedOn + ", metrics=" + this.metrics + ")";
            }
        }
    }

    public static class ServerMigrationSQLTable {
        private String version;
        private String sqlStatement;
        private String checkSum;

        public String getVersion() {
            return this.version;
        }

        public String getSqlStatement() {
            return this.sqlStatement;
        }

        public String getCheckSum() {
            return this.checkSum;
        }

        public void setVersion(String version) {
            this.version = version;
        }

        public void setSqlStatement(String sqlStatement) {
            this.sqlStatement = sqlStatement;
        }

        public void setCheckSum(String checkSum) {
            this.checkSum = checkSum;
        }
    }
}

