/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.jdbi3;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.ws.rs.core.UriInfo;
import org.apache.commons.csv.CSVPrinter;
import org.apache.commons.csv.CSVRecord;
import org.jdbi.v3.sqlobject.transaction.Transaction;
import org.openmetadata.common.utils.CommonUtil;
import org.openmetadata.csv.CsvUtil;
import org.openmetadata.csv.EntityCsv;
import org.openmetadata.schema.EntityInterface;
import org.openmetadata.schema.api.teams.CreateTeam;
import org.openmetadata.schema.entity.teams.AuthenticationMechanism;
import org.openmetadata.schema.entity.teams.Team;
import org.openmetadata.schema.entity.teams.User;
import org.openmetadata.schema.services.connections.metadata.AuthProvider;
import org.openmetadata.schema.type.EntityReference;
import org.openmetadata.schema.type.Include;
import org.openmetadata.schema.type.Relationship;
import org.openmetadata.schema.type.csv.CsvDocumentation;
import org.openmetadata.schema.type.csv.CsvErrorType;
import org.openmetadata.schema.type.csv.CsvFile;
import org.openmetadata.schema.type.csv.CsvHeader;
import org.openmetadata.schema.type.csv.CsvImportResult;
import org.openmetadata.schema.utils.EntityInterfaceUtil;
import org.openmetadata.service.Entity;
import org.openmetadata.service.OpenMetadataApplicationConfig;
import org.openmetadata.service.exception.CatalogExceptionMessage;
import org.openmetadata.service.exception.EntityNotFoundException;
import org.openmetadata.service.jdbi3.CollectionDAO;
import org.openmetadata.service.jdbi3.EntityRepository;
import org.openmetadata.service.jdbi3.ListFilter;
import org.openmetadata.service.jdbi3.TeamRepository;
import org.openmetadata.service.secrets.SecretsManager;
import org.openmetadata.service.secrets.SecretsManagerFactory;
import org.openmetadata.service.security.SecurityUtil;
import org.openmetadata.service.security.policyevaluator.SubjectContext;
import org.openmetadata.service.util.EntityUtil;
import org.openmetadata.service.util.JsonUtils;
import org.openmetadata.service.util.UserUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UserRepository
extends EntityRepository<User> {
    private static final Logger LOG = LoggerFactory.getLogger(UserRepository.class);
    static final String ROLES_FIELD = "roles";
    static final String TEAMS_FIELD = "teams";
    public static final String AUTH_MECHANISM_FIELD = "authenticationMechanism";
    static final String USER_PATCH_FIELDS = "profile,roles,teams,authenticationMechanism,isEmailVerified,personas,defaultPersona";
    static final String USER_UPDATE_FIELDS = "profile,roles,teams,authenticationMechanism,isEmailVerified,personas,defaultPersona";
    private volatile EntityReference organization;

    public UserRepository() {
        super("v1/users/", "user", User.class, Entity.getCollectionDAO().userDAO(), "profile,roles,teams,authenticationMechanism,isEmailVerified,personas,defaultPersona", "profile,roles,teams,authenticationMechanism,isEmailVerified,personas,defaultPersona");
        this.quoteFqn = true;
        this.supportsSearch = true;
    }

    private EntityReference getOrganization() {
        if (this.organization == null) {
            this.organization = Entity.getEntityReferenceByName("team", "Organization", Include.ALL);
        }
        return this.organization;
    }

    @Override
    public void setFullyQualifiedName(User user) {
        user.setFullyQualifiedName(EntityInterfaceUtil.quoteName((String)user.getName().toLowerCase()));
    }

    public final EntityUtil.Fields getFieldsWithUserAuth(String fields) {
        Set<String> tempFields = this.getAllowedFieldsCopy();
        if (fields != null && fields.equals("*")) {
            tempFields.add(AUTH_MECHANISM_FIELD);
            return new EntityUtil.Fields(tempFields);
        }
        return new EntityUtil.Fields(tempFields, fields);
    }

    @Override
    public User getByName(UriInfo uriInfo, String name, EntityUtil.Fields fields) {
        return (User)super.getByName(uriInfo, EntityInterfaceUtil.quoteName((String)name), fields);
    }

    public User getByEmail(UriInfo uriInfo, String email, EntityUtil.Fields fields) {
        String userString = ((CollectionDAO.UserDAO)this.dao).findUserByEmail(email);
        if (userString == null) {
            throw EntityNotFoundException.byMessage(CatalogExceptionMessage.entityNotFound("user", email));
        }
        return this.withHref(uriInfo, this.setFieldsInternal(JsonUtils.readValue(userString, User.class), fields));
    }

    @Override
    public void prepare(User user, boolean update) {
        this.validateTeams(user);
        this.validateRoles(user.getRoles());
    }

    @Override
    public void restorePatchAttributes(User original, User updated) {
        super.restorePatchAttributes(original, updated);
        updated.withInheritedRoles(original.getInheritedRoles()).withAuthenticationMechanism(original.getAuthenticationMechanism());
    }

    private List<EntityReference> getInheritedRoles(User user) {
        if (Boolean.TRUE.equals(user.getIsBot())) {
            return Collections.emptyList();
        }
        return SubjectContext.getRolesForTeams(this.getTeams(user));
    }

    @Override
    public void storeEntity(User user, boolean update) {
        List roles = user.getRoles();
        List teams = user.getTeams();
        user.withRoles(null).withTeams(null).withInheritedRoles(null);
        SecretsManager secretsManager = SecretsManagerFactory.getSecretsManager();
        if (secretsManager != null && Boolean.TRUE.equals(user.getIsBot())) {
            secretsManager.encryptAuthenticationMechanism(user.getName(), user.getAuthenticationMechanism());
        }
        this.store(user, update);
        user.withRoles(roles).withTeams(teams);
    }

    @Override
    public void storeRelationships(User user) {
        this.assignRoles(user, user.getRoles());
        this.assignTeams(user, user.getTeams());
        this.assignDefaultPersona(user, user.getDefaultPersona());
        this.assignPersonas(user, user.getPersonas());
        user.setInheritedRoles(this.getInheritedRoles(user));
    }

    @Override
    public void setInheritedFields(User user, EntityUtil.Fields fields) {
        if (fields.contains("domain") && user.getDomain() == null) {
            List<EntityReference> teams;
            List<EntityReference> list = teams = !fields.contains(TEAMS_FIELD) ? this.getTeams(user) : user.getTeams();
            if (!CommonUtil.nullOrEmpty(teams)) {
                Team team = (Team)Entity.getEntity("team", teams.get(0).getId(), "domain", Include.ALL);
                this.inheritDomain(user, fields, (EntityInterface)team);
            }
        }
    }

    public UserUpdater getUpdater(User original, User updated, EntityRepository.Operation operation) {
        return new UserUpdater(original, updated, operation);
    }

    @Override
    public void setFields(User user, EntityUtil.Fields fields) {
        user.setTeams(fields.contains(TEAMS_FIELD) ? this.getTeams(user) : user.getTeams());
        user.setOwns(fields.contains("owns") ? this.getOwns(user) : user.getOwns());
        user.setFollows(fields.contains("follows") ? this.getFollows(user) : user.getFollows());
        user.setRoles(fields.contains(ROLES_FIELD) ? this.getRoles(user) : user.getRoles());
        user.setPersonas(fields.contains("personas") ? this.getPersonas(user) : user.getPersonas());
        user.setDefaultPersona(fields.contains("defaultPersonas") ? this.getDefaultPersona(user) : user.getDefaultPersona());
        user.withInheritedRoles(fields.contains(ROLES_FIELD) ? this.getInheritedRoles(user) : user.getInheritedRoles());
    }

    @Override
    public void clearFields(User user, EntityUtil.Fields fields) {
        user.setProfile(fields.contains("profile") ? user.getProfile() : null);
        user.setTeams(fields.contains(TEAMS_FIELD) ? user.getTeams() : null);
        user.setOwns(fields.contains("owns") ? user.getOwns() : null);
        user.setFollows(fields.contains("follows") ? user.getFollows() : null);
        user.setRoles(fields.contains(ROLES_FIELD) ? user.getRoles() : null);
        user.setAuthenticationMechanism(fields.contains(AUTH_MECHANISM_FIELD) ? user.getAuthenticationMechanism() : null);
        user.withInheritedRoles(fields.contains(ROLES_FIELD) ? user.getInheritedRoles() : null);
    }

    @Override
    public String exportToCsv(String importingTeam, String user) throws IOException {
        Team team = (Team)this.daoCollection.teamDAO().findEntityByName(importingTeam);
        return new UserCsv(team, user).exportCsv();
    }

    @Override
    public CsvImportResult importFromCsv(String importingTeam, String csv, boolean dryRun, String user) throws IOException {
        Team team = (Team)this.daoCollection.teamDAO().findEntityByName(importingTeam);
        UserCsv userCsv = new UserCsv(team, user);
        return userCsv.importCsv(csv, dryRun);
    }

    public boolean isTeamJoinable(String teamId) {
        Team team = (Team)this.daoCollection.teamDAO().findEntityById(UUID.fromString(teamId), Include.NON_DELETED);
        return team.getIsJoinable();
    }

    public void validateTeams(User user) {
        List teams = user.getTeams();
        if (teams != null) {
            for (EntityReference entityReference : teams) {
                EntityReference ref = Entity.getEntityReferenceById("team", entityReference.getId(), Include.ALL);
                EntityUtil.copy(ref, entityReference);
            }
            teams.sort(EntityUtil.compareEntityReference);
        } else {
            user.setTeams(new ArrayList<EntityReference>(List.of(this.getOrganization())));
        }
    }

    public void validateTeamAddition(UUID userId, UUID teamId) {
        User user = (User)this.find(userId, Include.NON_DELETED);
        List<EntityReference> teams = this.getTeams(user);
        Optional<EntityReference> team = teams.stream().filter(t -> t.getId().equals(teamId)).findFirst();
        if (team.isPresent()) {
            throw new IllegalArgumentException(CatalogExceptionMessage.userAlreadyPartOfTeam(user.getName(), team.get().getDisplayName()));
        }
    }

    public boolean checkEmailAlreadyExists(String emailId) {
        return this.daoCollection.userDAO().checkEmailExists(emailId) > 0;
    }

    public void initializeUsers(OpenMetadataApplicationConfig config) {
        AuthProvider authProvider = config.getAuthenticationConfiguration().getProvider();
        HashSet<String> adminUsers = new HashSet<String>(config.getAuthorizerConfiguration().getAdminPrincipals());
        String domain = SecurityUtil.getDomain(config);
        UserUtil.addUsers(authProvider, adminUsers, domain, true);
        HashSet<String> testUsers = new HashSet<String>(config.getAuthorizerConfiguration().getTestPrincipals());
        UserUtil.addUsers(authProvider, testUsers, domain, null);
    }

    private List<EntityReference> getOwns(User user) {
        List<CollectionDAO.EntityRelationshipRecord> ownedEntities = this.daoCollection.relationshipDAO().findTo(user.getId(), "user", Relationship.OWNS.ordinal());
        List<EntityReference> teams = user.getTeams() == null ? this.getTeams(user) : user.getTeams();
        for (EntityReference team : teams) {
            ownedEntities.addAll(this.daoCollection.relationshipDAO().findTo(team.getId(), "team", Relationship.OWNS.ordinal()));
        }
        return EntityUtil.getEntityReferences(ownedEntities);
    }

    private List<EntityReference> getFollows(User user) {
        return this.findTo(user.getId(), "user", Relationship.FOLLOWS, null);
    }

    private List<EntityReference> getTeamChildren(UUID teamId) {
        if (teamId.equals(this.getOrganization().getId())) {
            List<String> children = this.daoCollection.teamDAO().listTeamsUnderOrganization(teamId);
            return EntityUtil.populateEntityReferencesById(EntityUtil.strToIds(children), "team");
        }
        return this.findTo(teamId, "team", Relationship.PARENT_OF, "team");
    }

    public List<EntityReference> getGroupTeams(UriInfo uriInfo, String userName) {
        User user = (User)this.getByName(uriInfo, userName, EntityUtil.Fields.EMPTY_FIELDS, Include.ALL, true);
        List<EntityReference> teams = this.getTeams(user);
        return this.getGroupTeams(teams);
    }

    private List<EntityReference> getGroupTeams(List<EntityReference> teams) {
        HashSet<EntityReference> result = new HashSet<EntityReference>();
        for (EntityReference t : teams) {
            Team team = (Team)Entity.getEntity(t, "", Include.ALL);
            if (CreateTeam.TeamType.GROUP.equals((Object)team.getTeamType())) {
                result.add(t);
                continue;
            }
            List<EntityReference> children = this.getTeamChildren(team.getId());
            result.addAll(this.getGroupTeams(children));
        }
        return new ArrayList<EntityReference>(result);
    }

    private List<EntityReference> getRoles(User user) {
        return this.findTo(user.getId(), "user", Relationship.HAS, "role");
    }

    public List<EntityReference> getTeams(User user) {
        List<Object> teams = this.findFrom(user.getId(), "user", Relationship.HAS, "team");
        if (CommonUtil.listOrEmpty(teams = CommonUtil.listOrEmpty(teams).stream().filter(team -> team.getDeleted() == false).collect(Collectors.toList())).isEmpty()) {
            return new ArrayList<EntityReference>(List.of(this.getOrganization()));
        }
        return teams;
    }

    public List<EntityReference> getPersonas(User user) {
        return this.findFrom(user.getId(), "user", Relationship.APPLIED_TO, "persona");
    }

    public EntityReference getDefaultPersona(User user) {
        return this.getToEntityRef(user.getId(), Relationship.DEFAULTS_TO, "persona", false);
    }

    private void assignRoles(User user, List<EntityReference> roles) {
        roles = CommonUtil.listOrEmpty(roles);
        for (EntityReference role : roles) {
            this.addRelationship(user.getId(), role.getId(), "user", "role", Relationship.HAS);
        }
    }

    private void assignTeams(User user, List<EntityReference> teams) {
        teams = CommonUtil.listOrEmpty(teams);
        for (EntityReference team : teams) {
            if (team.getId().equals(this.getOrganization().getId())) continue;
            this.addRelationship(team.getId(), user.getId(), "team", "user", Relationship.HAS);
        }
        if (teams.size() > 1) {
            teams = teams.stream().filter(t -> !t.getId().equals(this.getOrganization().getId())).collect(Collectors.toList());
            user.setTeams(teams);
        }
    }

    private void assignPersonas(User user, List<EntityReference> personas) {
        for (EntityReference persona : CommonUtil.listOrEmpty(personas)) {
            this.addRelationship(persona.getId(), user.getId(), "persona", "user", Relationship.APPLIED_TO);
        }
    }

    private void assignDefaultPersona(User user, EntityReference persona) {
        if (persona != null) {
            this.addRelationship(persona.getId(), user.getId(), "persona", "user", Relationship.DEFAULTS_TO);
        }
    }

    public class UserUpdater
    extends EntityRepository.EntityUpdater {
        public UserUpdater(User original, User updated, EntityRepository.Operation operation) {
            super((EntityRepository)UserRepository.this, (EntityInterface)original, (EntityInterface)updated, operation);
        }

        @Override
        @Transaction
        public void entitySpecificUpdate() {
            this.updateRoles((User)this.original, (User)this.updated);
            this.updateTeams((User)this.original, (User)this.updated);
            this.updatePersonas((User)this.original, (User)this.updated);
            this.recordChange("defaultPersona", ((User)this.original).getDefaultPersona(), ((User)this.updated).getDefaultPersona(), true);
            this.recordChange("profile", ((User)this.original).getProfile(), ((User)this.updated).getProfile(), true);
            this.recordChange("timezone", ((User)this.original).getTimezone(), ((User)this.updated).getTimezone());
            this.recordChange("isBot", ((User)this.original).getIsBot(), ((User)this.updated).getIsBot());
            this.recordChange("isAdmin", ((User)this.original).getIsAdmin(), ((User)this.updated).getIsAdmin());
            this.recordChange("email", ((User)this.original).getEmail(), ((User)this.updated).getEmail());
            this.recordChange("isEmailVerified", ((User)this.original).getIsEmailVerified(), ((User)this.updated).getIsEmailVerified());
            this.updateAuthenticationMechanism((User)this.original, (User)this.updated);
        }

        private void updateRoles(User original, User updated) {
            UserRepository.this.deleteFrom(original.getId(), "user", Relationship.HAS, "role");
            UserRepository.this.assignRoles(updated, updated.getRoles());
            List origRoles = CommonUtil.listOrEmpty((List)original.getRoles());
            List updatedRoles = CommonUtil.listOrEmpty((List)updated.getRoles());
            origRoles.sort(EntityUtil.compareEntityReference);
            updatedRoles.sort(EntityUtil.compareEntityReference);
            ArrayList added = new ArrayList();
            ArrayList deleted = new ArrayList();
            this.recordListChange(UserRepository.ROLES_FIELD, origRoles, updatedRoles, added, deleted, EntityUtil.entityReferenceMatch);
        }

        private void updateTeams(User original, User updated) {
            UserRepository.this.deleteTo(original.getId(), "user", Relationship.HAS, "team");
            UserRepository.this.assignTeams(updated, updated.getTeams());
            List origTeams = CommonUtil.listOrEmpty((List)original.getTeams());
            List updatedTeams = CommonUtil.listOrEmpty((List)updated.getTeams());
            origTeams.sort(EntityUtil.compareEntityReference);
            updatedTeams.sort(EntityUtil.compareEntityReference);
            ArrayList added = new ArrayList();
            ArrayList deleted = new ArrayList();
            this.recordListChange(UserRepository.TEAMS_FIELD, origTeams, updatedTeams, added, deleted, EntityUtil.entityReferenceMatch);
        }

        private void updatePersonas(User original, User updated) {
            UserRepository.this.deleteTo(original.getId(), "user", Relationship.APPLIED_TO, "persona");
            UserRepository.this.assignPersonas(updated, updated.getPersonas());
            List origPersonas = CommonUtil.listOrEmpty((List)original.getPersonas());
            List updatedPersonas = CommonUtil.listOrEmpty((List)updated.getPersonas());
            origPersonas.sort(EntityUtil.compareEntityReference);
            updatedPersonas.sort(EntityUtil.compareEntityReference);
            ArrayList added = new ArrayList();
            ArrayList deleted = new ArrayList();
            this.recordListChange("personas", origPersonas, updatedPersonas, added, deleted, EntityUtil.entityReferenceMatch);
        }

        private void updateAuthenticationMechanism(User original, User updated) {
            AuthenticationMechanism origAuthMechanism = original.getAuthenticationMechanism();
            AuthenticationMechanism updatedAuthMechanism = updated.getAuthenticationMechanism();
            if (origAuthMechanism == null && updatedAuthMechanism != null) {
                this.recordChange(UserRepository.AUTH_MECHANISM_FIELD, original.getAuthenticationMechanism(), "new-encrypted-value");
            } else if (origAuthMechanism != null && updatedAuthMechanism != null && !JsonUtils.areEquals(origAuthMechanism, updatedAuthMechanism)) {
                this.recordChange(UserRepository.AUTH_MECHANISM_FIELD, "old-encrypted-value", "new-encrypted-value");
            }
        }
    }

    public static class UserCsv
    extends EntityCsv<User> {
        public static final CsvDocumentation DOCUMENTATION = UserCsv.getCsvDocumentation("user");
        public static final List<CsvHeader> HEADERS = DOCUMENTATION.getHeaders();
        public final Team team;

        UserCsv(Team importingTeam, String updatedBy) {
            super("user", HEADERS, updatedBy);
            this.team = importingTeam;
        }

        @Override
        protected void createEntity(CSVPrinter printer, List<CSVRecord> csvRecords) throws IOException {
            CSVRecord csvRecord = this.getNextRecord(printer, csvRecords);
            User user = new User().withName(csvRecord.get(0)).withDisplayName(csvRecord.get(1)).withDescription(csvRecord.get(2)).withEmail(csvRecord.get(3)).withTimezone(csvRecord.get(4)).withIsAdmin(this.getBoolean(printer, csvRecord, 5)).withTeams(this.getTeams(printer, csvRecord, csvRecord.get(0))).withRoles(this.getEntityReferences(printer, csvRecord, 7, "role"));
            if (this.processRecord) {
                this.createEntity(printer, csvRecord, user);
            }
        }

        @Override
        protected void addRecord(CsvFile csvFile, User entity) {
            ArrayList<String> recordList = new ArrayList<String>();
            CsvUtil.addField(recordList, entity.getName());
            CsvUtil.addField(recordList, entity.getDisplayName());
            CsvUtil.addField(recordList, entity.getDescription());
            CsvUtil.addField(recordList, entity.getEmail());
            CsvUtil.addField(recordList, entity.getTimezone());
            CsvUtil.addField(recordList, entity.getIsAdmin());
            CsvUtil.addField(recordList, ((EntityReference)entity.getTeams().get(0)).getFullyQualifiedName());
            CsvUtil.addEntityReferences(recordList, entity.getRoles());
            this.addRecord(csvFile, (List<String>)recordList);
        }

        private List<User> listUsers(TeamRepository teamRepository, UserRepository userRepository, String parentTeam, List<User> users, EntityUtil.Fields fields) {
            ListFilter filter = new ListFilter(Include.NON_DELETED).addQueryParam("team", parentTeam);
            List userList = userRepository.listAll(fields, filter);
            if (!CommonUtil.nullOrEmpty(userList)) {
                users.addAll(userList);
            }
            filter = new ListFilter(Include.NON_DELETED).addQueryParam("parentTeam", parentTeam);
            List teamList = teamRepository.listAll(EntityUtil.Fields.EMPTY_FIELDS, filter);
            for (Team teamEntry : teamList) {
                this.listUsers(teamRepository, userRepository, teamEntry.getName(), users, fields);
            }
            return users;
        }

        public String exportCsv() throws IOException {
            UserRepository userRepository = (UserRepository)Entity.getEntityRepository("user");
            TeamRepository teamRepository = (TeamRepository)Entity.getEntityRepository("team");
            EntityUtil.Fields fields = userRepository.getFields("roles,teams");
            return this.exportCsv(this.listUsers(teamRepository, userRepository, this.team.getName(), new ArrayList<User>(), fields));
        }

        private List<EntityReference> getTeams(CSVPrinter printer, CSVRecord csvRecord, String user) throws IOException {
            List<EntityReference> teams = this.getEntityReferences(printer, csvRecord, 6, "team");
            for (EntityReference teamRef : CommonUtil.listOrEmpty(teams)) {
                if (teamRef.getName().equals(this.team.getName()) || SubjectContext.isInTeam(this.team.getName(), teamRef)) continue;
                this.importFailure(printer, UserCsv.invalidTeam(6, this.team.getName(), user, teamRef.getName()), csvRecord);
                this.processRecord = false;
            }
            return teams;
        }

        public static String invalidTeam(int field, String team, String user, String userTeam) {
            String error = String.format("Team %s of user %s is not under %s team hierarchy", userTeam, user, team);
            return String.format("#%s: Field %d error - %s", CsvErrorType.INVALID_FIELD, field + 1, error);
        }
    }
}

