/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.migration.utils.v120;

import javax.json.Json;
import javax.json.JsonObject;
import javax.json.JsonObjectBuilder;
import javax.json.JsonValue;
import org.jdbi.v3.core.Handle;
import org.jdbi.v3.core.statement.Update;
import org.openmetadata.schema.EntityInterface;
import org.openmetadata.schema.entity.data.GlossaryTerm;
import org.openmetadata.schema.entity.data.Query;
import org.openmetadata.schema.type.EntityReference;
import org.openmetadata.schema.type.Relationship;
import org.openmetadata.service.Entity;
import org.openmetadata.service.jdbi3.CollectionDAO;
import org.openmetadata.service.jdbi3.GlossaryTermRepository;
import org.openmetadata.service.jdbi3.QueryRepository;
import org.openmetadata.service.resources.databases.DatasourceConfig;
import org.openmetadata.service.util.JsonUtils;
import org.postgresql.util.PGobject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MigrationUtil {
    private static final Logger LOG = LoggerFactory.getLogger(MigrationUtil.class);
    private static final String QUERY_LIST_SERVICE = "SELECT   q.id AS query_id,   q.json AS query_json,   er_table_query.fromId AS table_id,   er_schema_table.fromId AS schema_id,   er_database_schema.fromId AS database_id,   er_service_database.fromId AS service_id,   db_service.name AS service_name FROM query_entity q LEFT JOIN entity_relationship er_table_query   ON er_table_query.fromEntity = 'table'  AND er_table_query.toEntity = 'query'  AND er_table_query.toId = q.id LEFT JOIN entity_relationship er_schema_table   ON er_schema_table.fromEntity = 'databaseSchema'  AND er_schema_table.toEntity = 'table'  AND er_table_query.fromId = er_schema_table.toId LEFT JOIN entity_relationship er_database_schema   ON er_database_schema.fromEntity = 'database'  AND er_database_schema.toEntity = 'databaseSchema'  AND er_schema_table.fromId = er_database_schema.toId LEFT JOIN entity_relationship er_service_database   ON er_service_database.fromEntity = 'databaseService'  AND er_service_database.toEntity = 'database'  AND er_database_schema.fromId = er_service_database.toId LEFT JOIN dbservice_entity db_service   ON db_service.id = er_service_database.fromId";
    private static final String DELETE_QUERY = "DELETE FROM query_entity WHERE id = :id";
    private static final String DELETE_RELATIONSHIP = "DELETE FROM entity_relationship WHERE fromId = :id or toId = :id";
    private static final String GLOSSARY_TERM_LIST_QUERY = "SELECT json FROM glossary_term_entity";

    private MigrationUtil() {
    }

    public static void addQueryService(Handle handle, CollectionDAO collectionDAO) {
        QueryRepository queryRepository = (QueryRepository)Entity.getEntityRepository("query");
        try {
            handle.createQuery(QUERY_LIST_SERVICE).mapToMap().forEach(row -> {
                try {
                    JsonObject queryJson = JsonUtils.readJson((String)row.get("query_json")).asJsonObject();
                    String serviceName = (String)row.get("service_name");
                    String serviceId = (String)row.get("service_id");
                    if (serviceId == null) {
                        LOG.warn(String.format("Query [%s] cannot be linked to a service. Deleting...", queryJson.getString("id")));
                        ((Update)handle.createUpdate(DELETE_QUERY).bind("id", queryJson.getString("id"))).execute();
                        ((Update)handle.createUpdate(DELETE_RELATIONSHIP).bind("id", queryJson.getString("id"))).execute();
                    } else {
                        JsonObject serviceJson = Json.createObjectBuilder().add("id", serviceId).add("name", serviceName).add("fullyQualifiedName", serviceName).add("type", "databaseService").build();
                        JsonObjectBuilder queryWithService = Json.createObjectBuilder();
                        queryJson.forEach((arg_0, arg_1) -> ((JsonObjectBuilder)queryWithService).add(arg_0, arg_1));
                        queryWithService.add("service", (JsonValue)serviceJson);
                        Query query = JsonUtils.readValue(queryWithService.build().toString(), Query.class);
                        queryRepository.setFullyQualifiedName(query);
                        collectionDAO.queryDAO().update((EntityInterface)query);
                    }
                }
                catch (Exception ex) {
                    LOG.warn(String.format("Error updating query [%s] due to [%s]", row, ex));
                }
            });
        }
        catch (Exception ex) {
            LOG.warn("Error running the query migration ", (Throwable)ex);
        }
    }

    public static void updateGlossaryAndGlossaryTermRelations(Handle handle, CollectionDAO collectionDAO) {
        GlossaryTermRepository glossaryTermRepository = (GlossaryTermRepository)Entity.getEntityRepository("glossaryTerm");
        try {
            handle.createQuery(GLOSSARY_TERM_LIST_QUERY).mapToMap().forEach(row -> {
                String jsonRow;
                if (Boolean.TRUE.equals(DatasourceConfig.getInstance().isMySQL())) {
                    jsonRow = (String)row.get("json");
                } else {
                    PGobject pgObject = (PGobject)row.get("json");
                    jsonRow = pgObject.getValue();
                }
                GlossaryTerm term = JsonUtils.readValue(jsonRow, GlossaryTerm.class);
                if (term.getStatus() == GlossaryTerm.Status.DRAFT) {
                    term.setStatus(GlossaryTerm.Status.APPROVED);
                    collectionDAO.glossaryTermDAO().update((EntityInterface)term);
                }
                EntityReference glossaryRef = glossaryTermRepository.getFromEntityRef(term.getId(), Relationship.CONTAINS, "glossary", false);
                EntityReference glossaryTermRef = glossaryTermRepository.getFromEntityRef(term.getId(), Relationship.CONTAINS, "glossaryTerm", false);
                if (glossaryTermRef != null && glossaryRef != null) {
                    glossaryTermRepository.deleteRelationship(glossaryRef.getId(), "glossary", term.getId(), "glossaryTerm", Relationship.CONTAINS);
                    glossaryTermRepository.addRelationship(glossaryRef.getId(), term.getId(), "glossary", "glossaryTerm", Relationship.HAS);
                }
            });
        }
        catch (Exception ex) {
            LOG.warn("Error during the Glossary Term migration due to ", (Throwable)ex);
        }
    }
}

