/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.resources.searchindex;

import io.swagger.v3.oas.annotations.ExternalDocumentation;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.ExampleObject;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.List;
import java.util.UUID;
import javax.json.JsonPatch;
import javax.validation.Valid;
import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.PATCH;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.SecurityContext;
import javax.ws.rs.core.UriInfo;
import org.openmetadata.common.utils.CommonUtil;
import org.openmetadata.schema.CreateEntity;
import org.openmetadata.schema.api.VoteRequest;
import org.openmetadata.schema.api.data.CreateSearchIndex;
import org.openmetadata.schema.api.data.RestoreEntity;
import org.openmetadata.schema.entity.data.SearchIndex;
import org.openmetadata.schema.type.ChangeEvent;
import org.openmetadata.schema.type.EntityHistory;
import org.openmetadata.schema.type.Include;
import org.openmetadata.schema.type.MetadataOperation;
import org.openmetadata.schema.type.searchindex.SearchIndexSampleData;
import org.openmetadata.service.Entity;
import org.openmetadata.service.jdbi3.ListFilter;
import org.openmetadata.service.jdbi3.SearchIndexRepository;
import org.openmetadata.service.resources.Collection;
import org.openmetadata.service.resources.EntityResource;
import org.openmetadata.service.security.Authorizer;
import org.openmetadata.service.security.policyevaluator.OperationContext;
import org.openmetadata.service.security.policyevaluator.ResourceContext;
import org.openmetadata.service.util.ResultList;

@Path(value="/v1/searchIndexes")
@Tag(name="SearchIndex", description="A `SearchIndex` is a index mapping for indexing documents in a `Search Service`.")
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
@Collection(name="searchIndexes")
public class SearchIndexResource
extends EntityResource<SearchIndex, SearchIndexRepository> {
    public static final String COLLECTION_PATH = "v1/searchIndexes/";
    static final String FIELDS = "owner,followers,tags,extension,domain,dataProducts,sourceHash";

    @Override
    public SearchIndex addHref(UriInfo uriInfo, SearchIndex searchIndex) {
        super.addHref(uriInfo, searchIndex);
        Entity.withHref(uriInfo, searchIndex.getService());
        return searchIndex;
    }

    public SearchIndexResource(Authorizer authorizer) {
        super("searchIndex", authorizer);
    }

    @Override
    protected List<MetadataOperation> getEntitySpecificOperations() {
        this.addViewOperation("sampleData", MetadataOperation.VIEW_SAMPLE_DATA);
        return CommonUtil.listOf((Object[])new MetadataOperation[]{MetadataOperation.VIEW_SAMPLE_DATA, MetadataOperation.EDIT_SAMPLE_DATA});
    }

    @GET
    @Operation(operationId="listSearchIndexes", summary="List searchIndexes", description="Get a list of SearchIndexes, optionally filtered by `service` it belongs to. Use `fields` parameter to get only necessary fields. Use cursor-based pagination to limit the number entries in the list using `limit` and `before` or `after` query params.", responses={@ApiResponse(responseCode="200", description="List of SearchIndexes", content={@Content(mediaType="application/json", schema=@Schema(implementation=SearchIndexList.class))})})
    public ResultList<SearchIndex> list(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Parameter(description="Fields requested in the returned resource", schema=@Schema(type="string", example="owner,followers,tags,extension,domain,dataProducts,sourceHash")) @QueryParam(value="fields") String fieldsParam, @Parameter(description="Filter SearchIndexes by service name", schema=@Schema(type="string", example="ElasticSearchWestCoast")) @QueryParam(value="service") String serviceParam, @Parameter(description="Limit the number SearchIndexes returned. (1 to 1000000, default = 10)") @DefaultValue(value="10") @QueryParam(value="limit") @Min(value=0L) @Max(value=1000000L) @Min(value=0L) @Max(value=1000000L) int limitParam, @Parameter(description="Returns list of SearchIndexes before this cursor", schema=@Schema(type="string")) @QueryParam(value="before") String before, @Parameter(description="Returns list of SearchIndexes after this cursor", schema=@Schema(type="string")) @QueryParam(value="after") String after, @Parameter(description="Include all, deleted, or non-deleted entities.", schema=@Schema(implementation=Include.class)) @QueryParam(value="include") @DefaultValue(value="non-deleted") Include include) {
        ListFilter filter = new ListFilter(include).addQueryParam("service", serviceParam);
        return super.listInternal(uriInfo, securityContext, fieldsParam, filter, limitParam, before, after);
    }

    @GET
    @Path(value="/{id}/versions")
    @Operation(operationId="listAllSearchIndexVersion", summary="List SearchIndex versions", description="Get a list of all the versions of a SearchIndex identified by `id`", responses={@ApiResponse(responseCode="200", description="List of SearchIndex versions", content={@Content(mediaType="application/json", schema=@Schema(implementation=EntityHistory.class))})})
    public EntityHistory listVersions(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Parameter(description="Id of the SearchIndex", schema=@Schema(type="UUID")) @PathParam(value="id") UUID id) {
        return super.listVersionsInternal(securityContext, id);
    }

    @GET
    @Path(value="/{id}")
    @Operation(summary="Get a SearchIndex by id", description="Get a SearchIndex by `id`.", responses={@ApiResponse(responseCode="200", description="The SearchIndex", content={@Content(mediaType="application/json", schema=@Schema(implementation=SearchIndex.class))}), @ApiResponse(responseCode="404", description="SearchIndex for instance {id} is not found")})
    public SearchIndex get(@Context UriInfo uriInfo, @Parameter(description="Id of the SearchIndex", schema=@Schema(type="UUID")) @PathParam(value="id") UUID id, @Context SecurityContext securityContext, @Parameter(description="Fields requested in the returned resource", schema=@Schema(type="string", example="owner,followers,tags,extension,domain,dataProducts,sourceHash")) @QueryParam(value="fields") String fieldsParam, @Parameter(description="Include all, deleted, or non-deleted entities.", schema=@Schema(implementation=Include.class)) @QueryParam(value="include") @DefaultValue(value="non-deleted") Include include) {
        return (SearchIndex)this.getInternal(uriInfo, securityContext, id, fieldsParam, include);
    }

    @GET
    @Path(value="/name/{fqn}")
    @Operation(operationId="getSearchIndexByFQN", summary="Get a SearchIndex by fully qualified name", description="Get a SearchIndex by fully qualified name.", responses={@ApiResponse(responseCode="200", description="The SearchIndex", content={@Content(mediaType="application/json", schema=@Schema(implementation=SearchIndex.class))}), @ApiResponse(responseCode="404", description="SearchIndex for instance {fqn} is not found")})
    public SearchIndex getByName(@Context UriInfo uriInfo, @Parameter(description="Fully qualified name of the SearchIndex", schema=@Schema(type="string")) @PathParam(value="fqn") String fqn, @Context SecurityContext securityContext, @Parameter(description="Fields requested in the returned resource", schema=@Schema(type="string", example="owner,followers,tags,extension,domain,dataProducts,sourceHash")) @QueryParam(value="fields") String fieldsParam, @Parameter(description="Include all, deleted, or non-deleted entities.", schema=@Schema(implementation=Include.class)) @QueryParam(value="include") @DefaultValue(value="non-deleted") Include include) {
        return (SearchIndex)this.getByNameInternal(uriInfo, securityContext, fqn, fieldsParam, include);
    }

    @GET
    @Path(value="/{id}/versions/{version}")
    @Operation(operationId="getSpecificSearchIndexVersion", summary="Get a version of the SearchIndex", description="Get a version of the SearchIndex by given `id`", responses={@ApiResponse(responseCode="200", description="SearchIndex", content={@Content(mediaType="application/json", schema=@Schema(implementation=SearchIndex.class))}), @ApiResponse(responseCode="404", description="SearchIndex for instance {id} and version {version} is not found")})
    public SearchIndex getVersion(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Parameter(description="Id of the SearchIndex", schema=@Schema(type="UUID")) @PathParam(value="id") UUID id, @Parameter(description="SearchIndex version number in the form `major`.`minor`", schema=@Schema(type="string", example="0.1 or 1.1")) @PathParam(value="version") String version) {
        return (SearchIndex)super.getVersionInternal(securityContext, id, version);
    }

    @Override
    @POST
    @Operation(operationId="createSearchIndex", summary="Create a SearchIndex", description="Create a SearchIndex under an existing `service`.", responses={@ApiResponse(responseCode="200", description="The SearchIndex", content={@Content(mediaType="application/json", schema=@Schema(implementation=SearchIndex.class))}), @ApiResponse(responseCode="400", description="Bad request")})
    public Response create(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Valid CreateSearchIndex create) {
        SearchIndex searchIndex = this.getSearchIndex(create, securityContext.getUserPrincipal().getName());
        return this.create(uriInfo, securityContext, searchIndex);
    }

    @PATCH
    @Path(value="/{id}")
    @Operation(operationId="patchSearchIndex", summary="Update a SearchIndex", description="Update an existing SearchIndex using JsonPatch.", externalDocs=@ExternalDocumentation(description="JsonPatch RFC", url="https://tools.ietf.org/html/rfc6902"))
    @Consumes(value={"application/json-patch+json"})
    public Response updateDescription(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Parameter(description="Id of the SearchIndex", schema=@Schema(type="UUID")) @PathParam(value="id") UUID id, @RequestBody(description="JsonPatch with array of operations", content={@Content(mediaType="application/json-patch+json", examples={@ExampleObject(value="[{op:remove, path:/a},{op:add, path: /b, value: val}]")})}) JsonPatch patch) {
        return this.patchInternal(uriInfo, securityContext, id, patch);
    }

    @Override
    @PUT
    @Operation(operationId="createOrUpdateSearchIndex", summary="Update SearchIndex", description="Create a SearchIndex, it it does not exist or update an existing SearchIndex.", responses={@ApiResponse(responseCode="200", description="The updated SearchIndex ", content={@Content(mediaType="application/json", schema=@Schema(implementation=SearchIndex.class))})})
    public Response createOrUpdate(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Valid CreateSearchIndex create) {
        SearchIndex searchIndex = this.getSearchIndex(create, securityContext.getUserPrincipal().getName());
        return this.createOrUpdate(uriInfo, securityContext, searchIndex);
    }

    @PUT
    @Path(value="/{id}/sampleData")
    @Operation(operationId="addSampleData", summary="Add sample data", description="Add sample data to the searchIndex.", responses={@ApiResponse(responseCode="200", description="The SearchIndex", content={@Content(mediaType="application/json", schema=@Schema(implementation=SearchIndex.class))})})
    public SearchIndex addSampleData(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Parameter(description="Id of the SearchIndex", schema=@Schema(type="UUID")) @PathParam(value="id") UUID id, @Valid SearchIndexSampleData sampleData) {
        OperationContext operationContext = new OperationContext(this.entityType, MetadataOperation.EDIT_SAMPLE_DATA);
        this.authorizer.authorize(securityContext, operationContext, this.getResourceContextById(id));
        SearchIndex searchIndex = ((SearchIndexRepository)this.repository).addSampleData(id, sampleData);
        return this.addHref(uriInfo, searchIndex);
    }

    @GET
    @Path(value="/{id}/sampleData")
    @Operation(operationId="getSampleData", summary="Get sample data", description="Get sample data from the SearchIndex.", responses={@ApiResponse(responseCode="200", description="Successfully obtained the SampleData for SearchIndex", content={@Content(mediaType="application/json", schema=@Schema(implementation=SearchIndex.class))})})
    public SearchIndex getSampleData(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Parameter(description="Id of the SearchIndex", schema=@Schema(type="UUID")) @PathParam(value="id") UUID id) {
        OperationContext operationContext = new OperationContext(this.entityType, MetadataOperation.VIEW_SAMPLE_DATA);
        ResourceContext resourceContext = this.getResourceContextById(id);
        this.authorizer.authorize(securityContext, operationContext, resourceContext);
        boolean authorizePII = this.authorizer.authorizePII(securityContext, resourceContext.getOwner());
        SearchIndex searchIndex = ((SearchIndexRepository)this.repository).getSampleData(id, authorizePII);
        return this.addHref(uriInfo, searchIndex);
    }

    @PUT
    @Path(value="/{id}/followers")
    @Operation(operationId="addFollower", summary="Add a follower", description="Add a user identified by `userId` as followed of this SearchIndex", responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=ChangeEvent.class))}), @ApiResponse(responseCode="404", description="SearchIndex for instance {id} is not found")})
    public Response addFollower(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Parameter(description="Id of the SearchIndex", schema=@Schema(type="UUID")) @PathParam(value="id") UUID id, @Parameter(description="Id of the user to be added as follower", schema=@Schema(type="UUID")) UUID userId) {
        return ((SearchIndexRepository)this.repository).addFollower(securityContext.getUserPrincipal().getName(), id, userId).toResponse();
    }

    @DELETE
    @Path(value="/{id}/followers/{userId}")
    @Operation(summary="Remove a follower", description="Remove the user identified `userId` as a follower of the SearchIndex.", responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=ChangeEvent.class))})})
    public Response deleteFollower(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Parameter(description="Id of the SearchIndex", schema=@Schema(type="UUID")) @PathParam(value="id") UUID id, @Parameter(description="Id of the user being removed as follower", schema=@Schema(type="string")) @PathParam(value="userId") String userId) {
        return ((SearchIndexRepository)this.repository).deleteFollower(securityContext.getUserPrincipal().getName(), id, UUID.fromString(userId)).toResponse();
    }

    @PUT
    @Path(value="/{id}/vote")
    @Operation(operationId="updateVoteForEntity", summary="Update Vote for a Entity", description="Update vote for a Entity", responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=ChangeEvent.class))}), @ApiResponse(responseCode="404", description="model for instance {id} is not found")})
    public Response updateVote(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Parameter(description="Id of the Entity", schema=@Schema(type="UUID")) @PathParam(value="id") UUID id, @Valid VoteRequest request) {
        return ((SearchIndexRepository)this.repository).updateVote(securityContext.getUserPrincipal().getName(), id, request).toResponse();
    }

    @DELETE
    @Path(value="/{id}")
    @Operation(operationId="deleteSearchIndex", summary="Delete a SearchIndex by id", description="Delete a SearchIndex by `id`.", responses={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="404", description="SearchIndex for instance {id} is not found")})
    public Response delete(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Parameter(description="Hard delete the entity. (Default = `false`)") @QueryParam(value="hardDelete") @DefaultValue(value="false") boolean hardDelete, @Parameter(description="Recursively delete this entity and it's children. (Default `false`)") @QueryParam(value="recursive") @DefaultValue(value="false") boolean recursive, @Parameter(description="Id of the SearchIndex", schema=@Schema(type="UUID")) @PathParam(value="id") UUID id) {
        return this.delete(uriInfo, securityContext, id, recursive, hardDelete);
    }

    @DELETE
    @Path(value="/name/{fqn}")
    @Operation(operationId="deleteSearchIndexByFQN", summary="Delete a SearchIndex by fully qualified name", description="Delete a SearchIndex by `fullyQualifiedName`.", responses={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="404", description="SearchIndex for instance {fqn} is not found")})
    public Response delete(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Parameter(description="Hard delete the entity. (Default = `false`)") @QueryParam(value="hardDelete") @DefaultValue(value="false") boolean hardDelete, @Parameter(description="Recursively delete this entity and it's children. (Default `false`)") @QueryParam(value="recursive") @DefaultValue(value="false") boolean recursive, @Parameter(description="Fully qualified name of the SearchIndex", schema=@Schema(type="string")) @PathParam(value="fqn") String fqn) {
        return this.deleteByName(uriInfo, securityContext, fqn, recursive, hardDelete);
    }

    @PUT
    @Path(value="/restore")
    @Operation(operationId="restore", summary="Restore a soft deleted SearchIndex", description="Restore a soft deleted SearchIndex.", responses={@ApiResponse(responseCode="200", description="Successfully restored the SearchIndex. ", content={@Content(mediaType="application/json", schema=@Schema(implementation=SearchIndex.class))})})
    public Response restoreSearchIndex(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Valid RestoreEntity restore) {
        return this.restoreEntity(uriInfo, securityContext, restore.getId());
    }

    private SearchIndex getSearchIndex(CreateSearchIndex create, String user) {
        return ((SearchIndexRepository)this.repository).copy(new SearchIndex(), (CreateEntity)create, user).withService(this.getEntityReference("searchService", create.getService())).withFields(create.getFields()).withSearchIndexSettings(create.getSearchIndexSettings()).withSourceHash(create.getSourceHash());
    }

    public static class SearchIndexList
    extends ResultList<SearchIndex> {
    }
}

