/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.resources.tags;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.openmetadata.common.utils.CommonUtil;
import org.openmetadata.schema.entity.classification.Classification;
import org.openmetadata.schema.entity.classification.Tag;
import org.openmetadata.schema.entity.data.Glossary;
import org.openmetadata.schema.entity.data.GlossaryTerm;
import org.openmetadata.schema.type.Include;
import org.openmetadata.schema.type.TagLabel;
import org.openmetadata.service.Entity;
import org.openmetadata.service.exception.CatalogExceptionMessage;
import org.openmetadata.service.util.EntityUtil;
import org.openmetadata.service.util.FullyQualifiedName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TagLabelUtil {
    private static final Logger LOG = LoggerFactory.getLogger(TagLabelUtil.class);

    private TagLabelUtil() {
    }

    public static Classification getClassification(String classificationName) {
        return (Classification)Entity.getEntityByName("classification", classificationName, "", Include.NON_DELETED);
    }

    public static Tag getTag(String tagFqn) {
        return (Tag)Entity.getEntityByName("tag", tagFqn, "", Include.NON_DELETED);
    }

    public static Glossary getGlossary(String glossaryName) {
        return (Glossary)Entity.getEntityByName("glossary", glossaryName, "", Include.NON_DELETED);
    }

    public static GlossaryTerm getGlossaryTerm(String glossaryTermFqn) {
        return (GlossaryTerm)Entity.getEntityByName("glossaryTerm", glossaryTermFqn, "", Include.NON_DELETED);
    }

    public static void applyTagCommonFields(TagLabel label) {
        if (label.getSource() == TagLabel.TagSource.CLASSIFICATION) {
            Tag tag = TagLabelUtil.getTag(label.getTagFQN());
            label.setName(tag.getName());
            label.setDisplayName(tag.getDisplayName());
            label.setDescription(tag.getDescription());
            label.setStyle(tag.getStyle());
        } else if (label.getSource() == TagLabel.TagSource.GLOSSARY) {
            GlossaryTerm glossaryTerm = TagLabelUtil.getGlossaryTerm(label.getTagFQN());
            label.setName(glossaryTerm.getName());
            label.setDisplayName(glossaryTerm.getDisplayName());
            label.setDescription(glossaryTerm.getDescription());
            label.setStyle(glossaryTerm.getStyle());
        } else {
            throw new IllegalArgumentException("Invalid source type " + label.getSource());
        }
    }

    public static boolean mutuallyExclusive(TagLabel label) {
        boolean rootParent;
        String[] fqnParts = FullyQualifiedName.split(label.getTagFQN());
        String parentFqn = FullyQualifiedName.getParentFQN(fqnParts);
        boolean bl = rootParent = fqnParts.length == 2;
        if (label.getSource() == TagLabel.TagSource.CLASSIFICATION) {
            return rootParent ? TagLabelUtil.getClassification(parentFqn).getMutuallyExclusive() : TagLabelUtil.getTag(parentFqn).getMutuallyExclusive();
        }
        if (label.getSource() == TagLabel.TagSource.GLOSSARY) {
            return rootParent ? TagLabelUtil.getGlossary(parentFqn).getMutuallyExclusive() : TagLabelUtil.getGlossaryTerm(parentFqn).getMutuallyExclusive();
        }
        throw new IllegalArgumentException("Invalid source type " + label.getSource());
    }

    public static List<TagLabel> addDerivedTags(List<TagLabel> tagLabels) {
        if (CommonUtil.nullOrEmpty(tagLabels)) {
            return tagLabels;
        }
        ArrayList<TagLabel> updatedTagLabels = new ArrayList<TagLabel>();
        EntityUtil.mergeTags(updatedTagLabels, tagLabels);
        for (TagLabel tagLabel : tagLabels) {
            EntityUtil.mergeTags(updatedTagLabels, TagLabelUtil.getDerivedTags(tagLabel));
        }
        updatedTagLabels.sort(EntityUtil.compareTagLabel);
        return updatedTagLabels;
    }

    private static List<TagLabel> getDerivedTags(TagLabel tagLabel) {
        if (tagLabel.getSource() == TagLabel.TagSource.GLOSSARY) {
            List<TagLabel> derivedTags = Entity.getCollectionDAO().tagUsageDAO().getTags(tagLabel.getTagFQN());
            derivedTags.forEach(tag -> tag.setLabelType(TagLabel.LabelType.DERIVED));
            return derivedTags;
        }
        return Collections.emptyList();
    }

    public static List<TagLabel> getUniqueTags(List<TagLabel> tags) {
        TreeSet<TagLabel> uniqueTags = new TreeSet<TagLabel>(EntityUtil.compareTagLabel);
        uniqueTags.addAll(tags);
        return uniqueTags.stream().toList();
    }

    public static void checkMutuallyExclusive(List<TagLabel> tagLabels) {
        HashMap<String, TagLabel> map = new HashMap<String, TagLabel>();
        for (TagLabel tagLabel : CommonUtil.listOrEmpty(tagLabels)) {
            String parentFqn = FullyQualifiedName.getParentFQN(tagLabel.getTagFQN());
            TagLabel stored = map.put(parentFqn, tagLabel);
            if (stored == null || !TagLabelUtil.mutuallyExclusive(tagLabel)) continue;
            throw new IllegalArgumentException(CatalogExceptionMessage.mutuallyExclusiveLabels(tagLabel, stored));
        }
    }

    public static void checkMutuallyExclusiveForParentAndSubField(String assetFqn, String assetFqnHash, Map<String, List<TagLabel>> allAssetTags, List<TagLabel> glossaryTags, boolean validateSubFields) {
        boolean failed = false;
        StringBuilder errorMessage = new StringBuilder();
        Map<String, List> filteredTags = allAssetTags.entrySet().stream().filter(entry -> ((String)entry.getKey()).startsWith(assetFqnHash)).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        List parentTags = filteredTags.remove(assetFqnHash);
        if (parentTags != null) {
            ArrayList<TagLabel> tempList = new ArrayList<TagLabel>(TagLabelUtil.addDerivedTags(parentTags));
            tempList.addAll(glossaryTags);
            try {
                TagLabelUtil.checkMutuallyExclusive(TagLabelUtil.getUniqueTags(tempList));
            }
            catch (IllegalArgumentException ex) {
                failed = true;
                errorMessage.append(String.format("Asset %s has a tag %s which is mutually exclusive with the one of the glossary tags %s. %n", assetFqn, TagLabelUtil.converTagLabelArrayToString(tempList), TagLabelUtil.converTagLabelArrayToString(glossaryTags)));
            }
        }
        if (validateSubFields) {
            Set subFieldTags = filteredTags.values().stream().flatMap(Collection::stream).collect(Collectors.toSet());
            ArrayList<TagLabel> tempList = new ArrayList<TagLabel>(TagLabelUtil.addDerivedTags(subFieldTags.stream().toList()));
            tempList.addAll(glossaryTags);
            try {
                TagLabelUtil.checkMutuallyExclusive(TagLabelUtil.getUniqueTags(tempList));
            }
            catch (IllegalArgumentException ex) {
                failed = true;
                errorMessage.append(String.format("Asset %s has a Subfield Column/Schema/Field containing tags %s which is mutually exclusive with the one of the glossary tags %s", assetFqn, TagLabelUtil.converTagLabelArrayToString(tempList), TagLabelUtil.converTagLabelArrayToString(glossaryTags)));
            }
        }
        if (failed) {
            throw new IllegalArgumentException(errorMessage.toString());
        }
    }

    public static String converTagLabelArrayToString(List<TagLabel> tags) {
        return String.format("[%s]", tags.stream().map(TagLabel::getTagFQN).collect(Collectors.joining(", ")));
    }
}

