/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.search.indexes;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.openmetadata.schema.EntityInterface;
import org.openmetadata.schema.entity.data.DashboardDataModel;
import org.openmetadata.schema.type.TagLabel;
import org.openmetadata.service.Entity;
import org.openmetadata.service.search.ParseTags;
import org.openmetadata.service.search.SearchIndexUtils;
import org.openmetadata.service.search.indexes.ColumnIndex;
import org.openmetadata.service.search.indexes.SearchIndex;
import org.openmetadata.service.search.models.FlattenColumn;
import org.openmetadata.service.search.models.SearchSuggest;
import org.openmetadata.service.util.JsonUtils;

public record DashboardDataModelIndex(DashboardDataModel dashboardDataModel) implements ColumnIndex
{
    private static final List<String> excludeFields = List.of("changeDescription");

    @Override
    public Map<String, Object> buildESDoc() {
        Map<String, Object> doc = JsonUtils.getMap(this.dashboardDataModel);
        SearchIndexUtils.removeNonIndexableFields(doc, excludeFields);
        ArrayList<SearchSuggest> suggest = new ArrayList<SearchSuggest>();
        ArrayList<SearchSuggest> columnSuggest = new ArrayList<SearchSuggest>();
        suggest.add(SearchSuggest.builder().input(this.dashboardDataModel.getName()).weight(10).build());
        suggest.add(SearchSuggest.builder().input(this.dashboardDataModel.getFullyQualifiedName()).weight(5).build());
        HashSet<List<TagLabel>> tagsWithChildren = new HashSet<List<TagLabel>>();
        ArrayList<String> columnsWithChildrenName = new ArrayList<String>();
        SearchIndexUtils.removeNonIndexableFields(doc, excludeFields);
        if (this.dashboardDataModel.getColumns() != null) {
            ArrayList<FlattenColumn> cols = new ArrayList<FlattenColumn>();
            this.parseColumns(this.dashboardDataModel.getColumns(), cols, null);
            for (FlattenColumn col : cols) {
                columnSuggest.add(SearchSuggest.builder().input(col.getName()).weight(5).build());
                columnsWithChildrenName.add(col.getName());
                if (col.getTags() == null) continue;
                tagsWithChildren.add(col.getTags());
            }
            doc.put("columnNames", columnsWithChildrenName);
        }
        ParseTags parseTags = new ParseTags(Entity.getEntityTags("dashboardDataModel", (EntityInterface)this.dashboardDataModel));
        tagsWithChildren.add(parseTags.getTags());
        List flattenedTagList = tagsWithChildren.stream().flatMap(Collection::stream).collect(ArrayList::new, ArrayList::add, ArrayList::addAll);
        doc.put("tags", flattenedTagList);
        doc.put("column_suggest", columnSuggest);
        doc.put("suggest", suggest);
        doc.put("entityType", "dashboardDataModel");
        doc.put("fqnParts", this.getFQNParts(this.dashboardDataModel.getFullyQualifiedName(), suggest.stream().map(SearchSuggest::getInput).toList()));
        doc.put("tier", parseTags.getTierTag());
        doc.put("owner", this.getEntityWithDisplayName(this.dashboardDataModel.getOwner()));
        doc.put("service", this.getEntityWithDisplayName(this.dashboardDataModel.getService()));
        doc.put("lineage", SearchIndex.getLineageData(this.dashboardDataModel.getEntityReference()));
        doc.put("domain", this.getEntityWithDisplayName(this.dashboardDataModel.getDomain()));
        return doc;
    }

    public static Map<String, Float> getFields() {
        Map<String, Float> fields = SearchIndex.getDefaultFields();
        fields.put("columns.name.keyword", Float.valueOf(10.0f));
        fields.put("columns.name", Float.valueOf(2.0f));
        fields.put("columns.displayName", Float.valueOf(1.0f));
        fields.put("columns.description", Float.valueOf(1.0f));
        fields.put("columns.children.name", Float.valueOf(2.0f));
        return fields;
    }
}

