/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.secrets;

import com.google.common.annotations.VisibleForTesting;
import org.openmetadata.schema.security.secrets.SecretsManagerProvider;
import org.openmetadata.service.secrets.AWSBasedSecretsManager;
import org.openmetadata.service.secrets.SecretsManager;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.ssm.SsmClient;
import software.amazon.awssdk.services.ssm.SsmClientBuilder;
import software.amazon.awssdk.services.ssm.model.DeleteParameterRequest;
import software.amazon.awssdk.services.ssm.model.GetParameterRequest;
import software.amazon.awssdk.services.ssm.model.ParameterType;
import software.amazon.awssdk.services.ssm.model.PutParameterRequest;
import software.amazon.awssdk.services.ssm.model.Tag;

public class AWSSSMSecretsManager
extends AWSBasedSecretsManager {
    private static AWSSSMSecretsManager instance = null;
    private SsmClient ssmClient;

    private AWSSSMSecretsManager(SecretsManager.SecretsConfig secretsConfig) {
        super(SecretsManagerProvider.MANAGED_AWS_SSM, secretsConfig);
    }

    @Override
    void initClientWithoutCredentials() {
        this.ssmClient = SsmClient.create();
    }

    @Override
    void initClientWithCredentials(String region, AwsCredentialsProvider staticCredentialsProvider) {
        this.ssmClient = (SsmClient)((SsmClientBuilder)((SsmClientBuilder)SsmClient.builder().region(Region.of((String)region))).credentialsProvider(staticCredentialsProvider)).build();
    }

    @Override
    public void storeSecret(String secretName, String secretValue) {
        this.putSecretParameter(secretName, secretValue, false);
    }

    @Override
    public void updateSecret(String secretName, String secretValue) {
        this.putSecretParameter(secretName, secretValue, true);
    }

    private void putSecretParameter(String parameterName, String parameterValue, boolean overwrite) {
        PutParameterRequest putParameterRequest = (PutParameterRequest)PutParameterRequest.builder().name(parameterName).description("This secret parameter was created by OpenMetadata").value(parameterValue).overwrite(Boolean.valueOf(overwrite)).type(ParameterType.SECURE_STRING).tags(SecretsManager.getTags(this.getSecretsConfig()).entrySet().stream().map(entry -> (Tag)Tag.builder().key((String)entry.getKey()).value((String)entry.getValue()).build()).toList()).build();
        this.ssmClient.putParameter(putParameterRequest);
    }

    @Override
    public String getSecret(String secretName) {
        GetParameterRequest parameterRequest = (GetParameterRequest)GetParameterRequest.builder().name(secretName).withDecryption(Boolean.valueOf(true)).build();
        return this.ssmClient.getParameter(parameterRequest).parameter().value();
    }

    @Override
    protected void deleteSecretInternal(String secretName) {
        DeleteParameterRequest deleteParameterRequest = (DeleteParameterRequest)DeleteParameterRequest.builder().name(secretName).build();
        this.ssmClient.deleteParameter(deleteParameterRequest);
    }

    public static AWSSSMSecretsManager getInstance(SecretsManager.SecretsConfig secretsConfig) {
        if (instance == null) {
            instance = new AWSSSMSecretsManager(secretsConfig);
        }
        return instance;
    }

    @VisibleForTesting
    protected void setSsmClient(SsmClient ssmClient) {
        this.ssmClient = ssmClient;
    }
}

