/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.util;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.Invocation;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.openmetadata.common.utils.CommonUtil;
import org.openmetadata.schema.EntityInterface;
import org.openmetadata.schema.SubscriptionAction;
import org.openmetadata.schema.entity.events.SubscriptionDestination;
import org.openmetadata.schema.entity.feed.Thread;
import org.openmetadata.schema.entity.teams.Team;
import org.openmetadata.schema.entity.teams.User;
import org.openmetadata.schema.type.ChangeEvent;
import org.openmetadata.schema.type.Include;
import org.openmetadata.schema.type.Profile;
import org.openmetadata.schema.type.Relationship;
import org.openmetadata.schema.type.Webhook;
import org.openmetadata.schema.type.profile.SubscriptionConfig;
import org.openmetadata.service.Entity;
import org.openmetadata.service.apps.bundles.changeEvent.Destination;
import org.openmetadata.service.events.subscription.AlertsRuleEvaluator;
import org.openmetadata.service.jdbi3.CollectionDAO;
import org.openmetadata.service.jdbi3.ListFilter;
import org.openmetadata.service.jdbi3.UserRepository;
import org.openmetadata.service.util.ResultList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SubscriptionUtil {
    private static final Logger LOG = LoggerFactory.getLogger(SubscriptionUtil.class);

    private SubscriptionUtil() {
    }

    public static Set<String> getAdminsData(SubscriptionDestination.SubscriptionType type) {
        HashSet<String> data = new HashSet<String>();
        UserRepository userEntityRepository = (UserRepository)Entity.getEntityRepository("user");
        ListFilter listFilter = new ListFilter(Include.ALL);
        listFilter.addQueryParam("isAdmin", "true");
        String after = null;
        try {
            ResultList result;
            do {
                result = userEntityRepository.listAfter(null, userEntityRepository.getFields("email,profile"), listFilter, 50, after);
                data.addAll(SubscriptionUtil.getEmailOrWebhookEndpointForUsers(result.getData(), type));
            } while ((after = result.getPaging().getAfter()) != null);
        }
        catch (Exception ex) {
            LOG.error("Failed in listing all Users , Reason", (Throwable)ex);
        }
        return data;
    }

    private static Set<String> getEmailOrWebhookEndpointForUsers(List<User> users, SubscriptionDestination.SubscriptionType type) {
        if (type == SubscriptionDestination.SubscriptionType.EMAIL) {
            return users.stream().map(User::getEmail).collect(Collectors.toSet());
        }
        return users.stream().map(user -> SubscriptionUtil.getWebhookUrlFromProfile(user.getProfile(), user.getId(), "user", type)).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toSet());
    }

    private static Set<String> getEmailOrWebhookEndpointForTeams(List<Team> users, SubscriptionDestination.SubscriptionType type) {
        if (type == SubscriptionDestination.SubscriptionType.EMAIL) {
            return users.stream().map(Team::getEmail).collect(Collectors.toSet());
        }
        return users.stream().map(team -> SubscriptionUtil.getWebhookUrlFromProfile(team.getProfile(), team.getId(), "team", type)).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toSet());
    }

    public static Set<String> getOwnerOrFollowers(SubscriptionDestination.SubscriptionType type, CollectionDAO daoCollection, UUID entityId, String entityType, Relationship relationship) {
        HashSet<String> data = new HashSet<String>();
        try {
            List<CollectionDAO.EntityRelationshipRecord> ownerOrFollowers = daoCollection.relationshipDAO().findFrom(entityId, entityType, relationship.ordinal());
            List<User> users = ownerOrFollowers.stream().filter(e -> "user".equals(e.getType())).map(user -> (User)Entity.getEntity("user", user.getId(), "", Include.NON_DELETED)).toList();
            data.addAll(SubscriptionUtil.getEmailOrWebhookEndpointForUsers(users, type));
            List<Team> teams = ownerOrFollowers.stream().filter(e -> "team".equals(e.getType())).map(team -> (Team)Entity.getEntity("team", team.getId(), "", Include.NON_DELETED)).toList();
            data.addAll(SubscriptionUtil.getEmailOrWebhookEndpointForTeams(teams, type));
        }
        catch (Exception ex) {
            LOG.error("Failed in listing all Owners/Followers, Reason : ", (Throwable)ex);
        }
        return data;
    }

    private static Set<UUID> getTaskAssignees(Thread thread) {
        List assignees = thread.getTask().getAssignees();
        HashSet<UUID> receiversList = new HashSet<UUID>();
        assignees.forEach(e -> {
            if ("user".equals(e.getType())) {
                receiversList.add(e.getId());
            } else if ("team".equals(e.getType())) {
                List<CollectionDAO.EntityRelationshipRecord> records = Entity.getCollectionDAO().relationshipDAO().findTo(e.getId(), "team", Relationship.HAS.ordinal(), "user");
                records.forEach(eRecord -> receiversList.add(eRecord.getId()));
            }
        });
        return receiversList;
    }

    private static Optional<String> getWebhookUrlFromProfile(Profile profile, UUID id, String entityType, SubscriptionDestination.SubscriptionType type) {
        SubscriptionConfig subscriptionConfig;
        if (profile != null && (subscriptionConfig = profile.getSubscription()) != null) {
            Webhook webhookConfig;
            switch (type) {
                case SLACK: {
                    Webhook webhook = profile.getSubscription().getSlack();
                    break;
                }
                case MS_TEAMS: {
                    Webhook webhook = profile.getSubscription().getMsTeams();
                    break;
                }
                case G_CHAT: {
                    Webhook webhook = profile.getSubscription().getgChat();
                    break;
                }
                case GENERIC: {
                    Webhook webhook = profile.getSubscription().getGeneric();
                    break;
                }
                default: {
                    Webhook webhook = webhookConfig = null;
                }
            }
            if (webhookConfig != null && !CommonUtil.nullOrEmpty((Object)webhookConfig.getEndpoint())) {
                return Optional.of(webhookConfig.getEndpoint().toString());
            }
            LOG.debug("[GetWebhookUrlsFromProfile] Owner with id {} type {}, will not get any Notification as not webhook config is missing for type {}, webhookConfig {} ", new Object[]{id, entityType, type.value(), webhookConfig});
        }
        LOG.debug("[GetWebhookUrlsFromProfile] Failed to Get Profile for Owner with ID : {} and type {} ", (Object)id, (Object)type);
        return Optional.empty();
    }

    public static Set<String> buildReceiversListFromActions(SubscriptionAction action, SubscriptionDestination.SubscriptionType type, CollectionDAO daoCollection, UUID entityId, String entityType) {
        HashSet<String> receiverList = new HashSet<String>();
        if (action.getReferences() != null) {
            List<User> users = action.getReferences().stream().filter(e -> "user".equals(e.getType())).map(user -> (User)Entity.getEntity("user", user.getId(), "", Include.NON_DELETED)).toList();
            receiverList.addAll(SubscriptionUtil.getEmailOrWebhookEndpointForUsers(users, type));
            List<Team> teams = action.getReferences().stream().filter(e -> "team".equals(e.getType())).map(team -> (Team)Entity.getEntity("team", team.getId(), "", Include.NON_DELETED)).toList();
            receiverList.addAll(SubscriptionUtil.getEmailOrWebhookEndpointForTeams(teams, type));
        }
        if (Boolean.TRUE.equals(action.getSendToAdmins())) {
            receiverList.addAll(SubscriptionUtil.getAdminsData(type));
        }
        if (Boolean.TRUE.equals(action.getSendToOwners())) {
            receiverList.addAll(SubscriptionUtil.getOwnerOrFollowers(type, daoCollection, entityId, entityType, Relationship.OWNS));
        }
        if (Boolean.TRUE.equals(action.getSendToFollowers())) {
            receiverList.addAll(SubscriptionUtil.getOwnerOrFollowers(type, daoCollection, entityId, entityType, Relationship.FOLLOWS));
        }
        return receiverList;
    }

    public static List<Invocation.Builder> getTargetsForWebhook(SubscriptionAction action, SubscriptionDestination.SubscriptionType type, Client client, ChangeEvent event) {
        ArrayList<Invocation.Builder> targets = new ArrayList<Invocation.Builder>();
        if (!event.getEntityType().equals("THREAD")) {
            EntityInterface entityInterface = AlertsRuleEvaluator.getEntity(event);
            Set<String> receiversUrls = SubscriptionUtil.buildReceiversListFromActions(action, type, Entity.getCollectionDAO(), entityInterface.getId(), event.getEntityType());
            for (String url : receiversUrls) {
                targets.add(client.target(url).request());
            }
        }
        return targets;
    }

    public static void postWebhookMessage(Destination<ChangeEvent> destination, Invocation.Builder target, Object message) {
        long attemptTime = System.currentTimeMillis();
        Response response = target.post(javax.ws.rs.client.Entity.entity((Object)message, (MediaType)MediaType.APPLICATION_JSON_TYPE));
        LOG.debug("Subscription Destination Posted Message {}:{} received response {}", new Object[]{destination.getSubscriptionDestination().getId(), message, response.getStatusInfo()});
        if (response.getStatus() >= 300 && response.getStatus() < 400) {
            destination.setErrorStatus(attemptTime, response.getStatus(), response.getStatusInfo().getReasonPhrase());
        } else if (response.getStatus() >= 400 && response.getStatus() < 600) {
            destination.setAwaitingRetry(attemptTime, response.getStatus(), response.getStatusInfo().getReasonPhrase());
        } else if (response.getStatus() == 200) {
            destination.setSuccessStatus(System.currentTimeMillis());
        }
    }

    public static Client getClient(int connectTimeout, int readTimeout) {
        ClientBuilder clientBuilder = ClientBuilder.newBuilder();
        clientBuilder.connectTimeout((long)connectTimeout, TimeUnit.SECONDS);
        clientBuilder.readTimeout((long)readTimeout, TimeUnit.SECONDS);
        return clientBuilder.build();
    }
}

