/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.workflows.searchIndex;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.glassfish.jersey.internal.util.ExceptionUtils;
import org.openmetadata.schema.EntityInterface;
import org.openmetadata.schema.system.IndexingError;
import org.openmetadata.schema.system.StepStats;
import org.openmetadata.schema.type.Include;
import org.openmetadata.service.Entity;
import org.openmetadata.service.exception.SearchIndexException;
import org.openmetadata.service.jdbi3.EntityRepository;
import org.openmetadata.service.jdbi3.ListFilter;
import org.openmetadata.service.util.RestUtil;
import org.openmetadata.service.util.ResultList;
import org.openmetadata.service.workflows.interfaces.Source;
import org.openmetadata.service.workflows.searchIndex.ReindexingUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PaginatedEntitiesSource
implements Source<ResultList<? extends EntityInterface>> {
    private static final Logger LOG = LoggerFactory.getLogger(PaginatedEntitiesSource.class);
    private final int batchSize;
    private final String entityType;
    private final List<String> fields;
    private final List<String> readerErrors = new ArrayList<String>();
    private final StepStats stats = new StepStats();
    private String lastFailedCursor = null;
    private String cursor = RestUtil.encodeCursor("0");
    private boolean isDone = false;

    public PaginatedEntitiesSource(String entityType, int batchSize, List<String> fields) {
        this.entityType = entityType;
        this.batchSize = batchSize;
        this.fields = fields;
        this.stats.withTotalRecords(Integer.valueOf(Entity.getEntityRepository(entityType).getDao().listTotalCount())).withSuccessRecords(Integer.valueOf(0)).withFailedRecords(Integer.valueOf(0));
    }

    @Override
    public ResultList<? extends EntityInterface> readNext(Map<String, Object> contextData) throws SearchIndexException {
        ResultList<? extends EntityInterface> data = null;
        if (!this.isDone) {
            data = this.read(this.cursor);
            this.cursor = data.getPaging().getAfter();
            if (this.cursor == null) {
                this.isDone = true;
            }
        }
        return data;
    }

    private ResultList<? extends EntityInterface> read(String cursor) throws SearchIndexException {
        LOG.debug("[PaginatedEntitiesSource] Fetching a Batch of Size: {} ", (Object)this.batchSize);
        EntityRepository<? extends EntityInterface> entityRepository = Entity.getEntityRepository(this.entityType);
        ResultList<? extends EntityInterface> result = null;
        try {
            result = entityRepository.listAfterWithSkipFailure(null, Entity.getFields(this.entityType, this.fields), new ListFilter(Include.ALL), this.batchSize, cursor);
            if (!result.getErrors().isEmpty()) {
                this.lastFailedCursor = this.cursor;
                throw new SearchIndexException(new IndexingError().withErrorSource(IndexingError.ErrorSource.READER).withLastFailedCursor(this.lastFailedCursor).withSubmittedCount(Integer.valueOf(this.batchSize)).withSuccessCount(Integer.valueOf(result.getData().size())).withFailedCount(Integer.valueOf(result.getErrors().size())).withMessage("Issues in Reading A Batch For Entities. Check Errors Corresponding to Entities.").withFailedEntities(result.getErrors()));
            }
            LOG.debug("[PaginatedEntitiesSource] Batch Stats :- %n Submitted : {} Success: {} Failed: {}", new Object[]{this.batchSize, result.getData().size(), result.getErrors().size()});
            this.updateStats(result.getData().size(), result.getErrors().size());
        }
        catch (SearchIndexException ex) {
            this.lastFailedCursor = this.cursor;
            if (result.getPaging().getAfter() == null) {
                this.isDone = true;
            } else {
                this.cursor = result.getPaging().getAfter();
            }
            this.updateStats(result.getData().size(), result.getErrors().size());
            throw ex;
        }
        catch (Exception e) {
            this.lastFailedCursor = this.cursor;
            IndexingError indexingError = new IndexingError().withErrorSource(IndexingError.ErrorSource.READER).withSubmittedCount(Integer.valueOf(this.batchSize)).withSuccessCount(Integer.valueOf(0)).withFailedCount(Integer.valueOf(this.batchSize)).withMessage("Issues in Reading A Batch For Entities. No Relationship Issue , Json Processing or DB issue.").withLastFailedCursor(this.lastFailedCursor).withStackTrace(ExceptionUtils.exceptionStackTraceAsString((Throwable)e));
            LOG.debug(indexingError.getMessage());
            throw new SearchIndexException(indexingError);
        }
        return result;
    }

    @Override
    public void reset() {
        this.cursor = null;
        this.isDone = false;
    }

    @Override
    public void updateStats(int currentSuccess, int currentFailed) {
        ReindexingUtil.getUpdatedStats(this.stats, currentSuccess, currentFailed);
    }

    public void setCursor(String cursor) {
        this.cursor = cursor;
    }

    public int getBatchSize() {
        return this.batchSize;
    }

    public String getEntityType() {
        return this.entityType;
    }

    public List<String> getFields() {
        return this.fields;
    }

    @Override
    public List<String> getReaderErrors() {
        return this.readerErrors;
    }

    @Override
    public StepStats getStats() {
        return this.stats;
    }

    public String getLastFailedCursor() {
        return this.lastFailedCursor;
    }

    public boolean isDone() {
        return this.isDone;
    }
}

