/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.apps;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.openmetadata.schema.entity.app.App;
import org.openmetadata.service.exception.UnhandledServerException;
import org.openmetadata.service.jdbi3.CollectionDAO;
import org.openmetadata.service.search.SearchRepository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApplicationHandler {
    private static final Logger LOG = LoggerFactory.getLogger(ApplicationHandler.class);

    private ApplicationHandler() {
    }

    public static void triggerApplicationOnDemand(App app, CollectionDAO daoCollection, SearchRepository searchRepository) {
        ApplicationHandler.runMethodFromApplication(app, daoCollection, searchRepository, "triggerOnDemand");
    }

    public static void installApplication(App app, CollectionDAO daoCollection, SearchRepository searchRepository) {
        ApplicationHandler.runMethodFromApplication(app, daoCollection, searchRepository, "install");
    }

    public static void configureApplication(App app, CollectionDAO daoCollection, SearchRepository searchRepository) {
        ApplicationHandler.runMethodFromApplication(app, daoCollection, searchRepository, "configure");
    }

    public static void runMethodFromApplication(App app, CollectionDAO daoCollection, SearchRepository searchRepository, String methodName) {
        try {
            Class<?> clz = Class.forName(app.getClassName());
            Object resource = clz.getConstructor(new Class[0]).newInstance(new Object[0]);
            Method initMethod = resource.getClass().getMethod("init", App.class, CollectionDAO.class, SearchRepository.class);
            initMethod.invoke(resource, app, daoCollection, searchRepository);
            Method scheduleMethod = resource.getClass().getMethod(methodName, new Class[0]);
            scheduleMethod.invoke(resource, new Object[0]);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            LOG.error("Exception encountered", (Throwable)e);
            throw new UnhandledServerException("Exception encountered", e);
        }
        catch (ClassNotFoundException e) {
            throw new UnhandledServerException("Exception encountered", e);
        }
    }
}

