/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.apps.bundles.insights;

import com.cronutils.model.Cron;
import java.util.List;
import org.openmetadata.schema.EntityInterface;
import org.openmetadata.schema.api.services.ingestionPipelines.CreateIngestionPipeline;
import org.openmetadata.schema.entity.services.ServiceType;
import org.openmetadata.schema.entity.services.ingestionPipelines.AirflowConfig;
import org.openmetadata.schema.entity.services.ingestionPipelines.IngestionPipeline;
import org.openmetadata.schema.entity.services.ingestionPipelines.PipelineType;
import org.openmetadata.schema.metadataIngestion.MetadataToElasticSearchPipeline;
import org.openmetadata.schema.metadataIngestion.SourceConfig;
import org.openmetadata.schema.type.EntityReference;
import org.openmetadata.schema.type.ProviderType;
import org.openmetadata.schema.type.Relationship;
import org.openmetadata.service.Entity;
import org.openmetadata.service.apps.AbstractNativeApplication;
import org.openmetadata.service.exception.EntityNotFoundException;
import org.openmetadata.service.jdbi3.CollectionDAO;
import org.openmetadata.service.jdbi3.EntityRepository;
import org.openmetadata.service.jdbi3.IngestionPipelineRepository;
import org.openmetadata.service.util.FullyQualifiedName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataInsightsApp
extends AbstractNativeApplication {
    private static final Logger LOG = LoggerFactory.getLogger(DataInsightsApp.class);
    private static final String INGESTION_PIPELINE_NAME = "OpenMetadata_dataInsight";
    private static final String SERVICE_NAME = "OpenMetadata";
    private static final String SERVICE_TYPE = "Metadata";
    private static final String PIPELINE_DESCRIPTION = "OpenMetadata DataInsight Pipeline";

    @Override
    public void install() {
        IngestionPipelineRepository ingestionPipelineRepository = (IngestionPipelineRepository)Entity.getEntityRepository("ingestionPipeline");
        try {
            this.bindExistingIngestionToApplication(ingestionPipelineRepository);
        }
        catch (EntityNotFoundException ex) {
            this.createAndBindIngestionPipeline(ingestionPipelineRepository);
        }
    }

    private void bindExistingIngestionToApplication(IngestionPipelineRepository ingestionPipelineRepository) {
        String fqn = FullyQualifiedName.add(SERVICE_NAME, INGESTION_PIPELINE_NAME);
        IngestionPipeline storedPipeline = (IngestionPipeline)ingestionPipelineRepository.getByName(null, fqn, ingestionPipelineRepository.getFields("id"));
        List<CollectionDAO.EntityRelationshipRecord> records = this.collectionDAO.relationshipDAO().findTo(this.getApp().getId(), "app", Relationship.HAS.ordinal(), "ingestionPipeline");
        if (records.isEmpty()) {
            this.collectionDAO.relationshipDAO().insert(this.getApp().getId(), storedPipeline.getId(), "app", "ingestionPipeline", Relationship.HAS.ordinal());
        }
    }

    private void createAndBindIngestionPipeline(IngestionPipelineRepository ingestionPipelineRepository) {
        EntityRepository<? extends EntityInterface> serviceRepository = Entity.getServiceEntityRepository(ServiceType.fromValue((String)SERVICE_TYPE));
        EntityReference service = serviceRepository.getByName(null, SERVICE_NAME, serviceRepository.getFields("id")).getEntityReference();
        Cron quartzCron = this.getCronParser().parse(this.getApp().getAppSchedule().getCronExpression());
        CreateIngestionPipeline createPipelineRequest = new CreateIngestionPipeline().withName(INGESTION_PIPELINE_NAME).withDisplayName(INGESTION_PIPELINE_NAME).withDescription(PIPELINE_DESCRIPTION).withPipelineType(PipelineType.DATA_INSIGHT).withSourceConfig(new SourceConfig().withConfig((Object)new MetadataToElasticSearchPipeline())).withAirflowConfig(new AirflowConfig().withScheduleInterval(this.getCronMapper().map(quartzCron).asString())).withService(service);
        IngestionPipeline dataInsightPipeline = this.getIngestionPipeline(createPipelineRequest, String.format("%sBot", this.getApp().getName()), "admin").withProvider(ProviderType.USER);
        ingestionPipelineRepository.setFullyQualifiedName(dataInsightPipeline);
        ingestionPipelineRepository.initializeEntity(dataInsightPipeline);
        this.collectionDAO.relationshipDAO().insert(this.getApp().getId(), dataInsightPipeline.getId(), "app", "ingestionPipeline", Relationship.HAS.ordinal());
    }
}

