/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.apps.scheduler;

import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.openmetadata.common.utils.CommonUtil;
import org.openmetadata.schema.AppRuntime;
import org.openmetadata.schema.entity.app.App;
import org.openmetadata.schema.entity.app.AppRunType;
import org.openmetadata.schema.entity.app.AppSchedule;
import org.openmetadata.service.apps.AbstractNativeApplication;
import org.openmetadata.service.apps.scheduler.OmAppJobListener;
import org.openmetadata.service.exception.UnhandledServerException;
import org.openmetadata.service.jdbi3.CollectionDAO;
import org.openmetadata.service.search.SearchRepository;
import org.quartz.CronScheduleBuilder;
import org.quartz.JobBuilder;
import org.quartz.JobDataMap;
import org.quartz.JobDetail;
import org.quartz.JobListener;
import org.quartz.Matcher;
import org.quartz.ScheduleBuilder;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.Trigger;
import org.quartz.TriggerBuilder;
import org.quartz.TriggerKey;
import org.quartz.impl.StdSchedulerFactory;
import org.quartz.impl.matchers.GroupMatcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AppScheduler {
    private static final Logger LOG = LoggerFactory.getLogger(AppScheduler.class);
    public static final String APPS_JOB_GROUP = "OMAppsJobGroup";
    public static final String APPS_TRIGGER_GROUP = "OMAppsJobGroup";
    public static final String APP_CRON_TRIGGER = "appCronTrigger";
    public static final String APP_INFO_KEY = "applicationInfoKey";
    public static final String COLLECTION_DAO_KEY = "daoKey";
    public static final String SEARCH_CLIENT_KEY = "searchClientKey";
    private static AppScheduler instance;
    private static volatile boolean initialized;
    private final Scheduler scheduler;
    private static final ConcurrentHashMap<UUID, JobDetail> appJobsKeyMap;
    private final CollectionDAO collectionDAO;
    private final SearchRepository searchClient;

    private AppScheduler(CollectionDAO dao, SearchRepository searchClient) throws SchedulerException {
        this.collectionDAO = dao;
        this.searchClient = searchClient;
        this.scheduler = new StdSchedulerFactory().getScheduler();
        this.scheduler.getListenerManager().addJobListener((JobListener)new OmAppJobListener(dao), (Matcher)GroupMatcher.jobGroupEquals((String)"OMAppsJobGroup"));
        this.scheduler.start();
    }

    public static void initialize(CollectionDAO dao, SearchRepository searchClient) throws SchedulerException {
        if (!initialized) {
            instance = new AppScheduler(dao, searchClient);
            initialized = true;
        } else {
            LOG.info("Reindexing Handler is already initialized");
        }
    }

    public static AppScheduler getInstance() {
        if (initialized) {
            return instance;
        }
        throw new UnhandledServerException("App Scheduler is not Initialized");
    }

    public ConcurrentMap<UUID, JobDetail> getReportMap() {
        return appJobsKeyMap;
    }

    public void addApplicationSchedule(App application) {
        try {
            AppRuntime context = AbstractNativeApplication.getAppRuntime(application);
            if (Boolean.TRUE.equals(context.getEnabled())) {
                JobDetail jobDetail = this.jobBuilder(application, String.format("%s", application.getId().toString()));
                Trigger trigger = this.trigger(application);
                this.scheduler.scheduleJob(jobDetail, trigger);
                appJobsKeyMap.put(application.getId(), jobDetail);
            } else {
                LOG.info("[Applications] App cannot be scheduled since it is disabled");
            }
        }
        catch (Exception ex) {
            LOG.error("Failed in setting up job Scheduler for Data Reporting", (Throwable)ex);
            throw new UnhandledServerException("Failed in scheduling Job for the Application", ex);
        }
    }

    public void deleteScheduledApplication(App app) throws SchedulerException {
        JobDetail jobDetail = this.getJobKey(app.getId());
        if (jobDetail != null) {
            this.scheduler.deleteJob(jobDetail.getKey());
            this.scheduler.unscheduleJob(new TriggerKey(app.getId().toString(), "OMAppsJobGroup"));
            appJobsKeyMap.remove(app.getId());
        }
    }

    private JobDetail jobBuilder(App app, String jobIdentity) throws ClassNotFoundException {
        JobDataMap dataMap = new JobDataMap();
        dataMap.put(APP_INFO_KEY, (Object)app);
        dataMap.put(COLLECTION_DAO_KEY, (Object)this.collectionDAO);
        dataMap.put(SEARCH_CLIENT_KEY, (Object)this.searchClient);
        dataMap.put("triggerType", AppRunType.Scheduled.value());
        Class<?> clz = Class.forName(app.getClassName());
        JobBuilder jobBuilder = JobBuilder.newJob(clz).withIdentity(jobIdentity, "OMAppsJobGroup").usingJobData(dataMap);
        return jobBuilder.build();
    }

    private Trigger trigger(App app) {
        return TriggerBuilder.newTrigger().withIdentity(app.getId().toString(), "OMAppsJobGroup").withSchedule((ScheduleBuilder)AppScheduler.getCronSchedule(app.getAppSchedule())).build();
    }

    private JobDetail getJobKey(UUID id) {
        return appJobsKeyMap.get(id);
    }

    public static void shutDown() throws SchedulerException {
        if (instance != null) {
            AppScheduler.instance.scheduler.shutdown();
        }
    }

    public static CronScheduleBuilder getCronSchedule(AppSchedule scheduleInfo) {
        switch (scheduleInfo.getScheduleType()) {
            case HOURLY: {
                return CronScheduleBuilder.cronSchedule((String)"0 0 * ? * *");
            }
            case DAILY: {
                return CronScheduleBuilder.dailyAtHourAndMinute((int)0, (int)0);
            }
            case WEEKLY: {
                return CronScheduleBuilder.weeklyOnDayAndHourAndMinute((int)7, (int)0, (int)0);
            }
            case MONTHLY: {
                return CronScheduleBuilder.monthlyOnDayAndHourAndMinute((int)1, (int)0, (int)0);
            }
            case CUSTOM: {
                if (!CommonUtil.nullOrEmpty((String)scheduleInfo.getCronExpression())) {
                    return CronScheduleBuilder.cronSchedule((String)scheduleInfo.getCronExpression());
                }
                throw new IllegalArgumentException("Missing Cron Expression for Custom Schedule.");
            }
        }
        throw new IllegalArgumentException("Invalid Trigger Info for the scheduled application.");
    }

    public void triggerOnDemandApplication(App application) {
        try {
            AppRuntime context = AbstractNativeApplication.getAppRuntime(application);
            if (Boolean.TRUE.equals(context.getEnabled())) {
                JobDetail jobDetail = this.jobBuilder(application, String.format("%s.onDemand.%s", application.getId().toString(), UUID.randomUUID()));
                jobDetail.getJobDataMap().put("triggerType", AppRunType.OnDemand.value());
                Trigger trigger = TriggerBuilder.newTrigger().withIdentity(application.toString(), "OMAppsJobGroup").startNow().build();
                this.scheduler.scheduleJob(jobDetail, trigger);
                appJobsKeyMap.put(application.getId(), jobDetail);
            } else {
                LOG.info("[Applications] App cannot be scheduled since it is disabled");
            }
        }
        catch (Exception ex) {
            LOG.error("Failed in running job", (Throwable)ex);
        }
    }

    public Scheduler getScheduler() {
        return this.scheduler;
    }

    static {
        initialized = false;
        appJobsKeyMap = new ConcurrentHashMap();
    }
}

