/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.dataInsight;

import java.util.ArrayList;
import java.util.List;
import org.openmetadata.schema.dataInsight.type.MostViewedEntities;
import org.openmetadata.service.dataInsight.DataInsightAggregatorInterface;

public abstract class MostViewedEntitiesAggregator<A, B, M, S>
implements DataInsightAggregatorInterface {
    protected final A aggregations;

    protected MostViewedEntitiesAggregator(A aggregations) {
        this.aggregations = aggregations;
    }

    @Override
    public List<Object> aggregate() {
        M entityFqnBuckets = this.getEntityFqnBuckets(this.aggregations);
        ArrayList<Object> data = new ArrayList<Object>();
        for (B entityFqnBucket : this.getBuckets(entityFqnBuckets)) {
            String tableFqn = this.getKeyAsString(entityFqnBucket);
            S sumPageViews = this.getAggregations(entityFqnBucket, "pageViews");
            M ownerBucket = this.getBucketAggregation(entityFqnBucket, "owner");
            M entityTypeBucket = this.getBucketAggregation(entityFqnBucket, "entityType");
            M entityHrefBucket = this.getBucketAggregation(entityFqnBucket, "entityHref");
            String owner = this.getFirstValueFromBucketOrNull(ownerBucket);
            String entityType = this.getFirstValueFromBucketOrNull(entityTypeBucket);
            String entityHref = this.getFirstValueFromBucketOrNull(entityHrefBucket);
            data.add(new MostViewedEntities().withEntityFqn(tableFqn).withOwner(owner).withEntityType(entityType).withEntityHref(entityHref).withPageViews(this.getValue(sumPageViews)));
        }
        return data;
    }

    protected abstract Double getValue(S var1);

    protected abstract M getBucketAggregation(B var1, String var2);

    protected abstract S getAggregations(B var1, String var2);

    protected abstract String getKeyAsString(B var1);

    protected abstract List<? extends B> getBuckets(M var1);

    protected abstract M getEntityFqnBuckets(A var1);

    protected String getFirstValueFromBucketOrNull(M bucket) {
        if (!this.getBuckets(bucket).isEmpty()) {
            return this.getKeyAsString(this.getBuckets(bucket).get(0));
        }
        return null;
    }
}

