/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.events;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerResponseContext;
import javax.ws.rs.core.SecurityContext;
import org.openmetadata.common.utils.CommonUtil;
import org.openmetadata.schema.EntityInterface;
import org.openmetadata.schema.entity.feed.Thread;
import org.openmetadata.schema.type.ChangeEvent;
import org.openmetadata.schema.type.EventType;
import org.openmetadata.service.Entity;
import org.openmetadata.service.OpenMetadataApplicationConfig;
import org.openmetadata.service.events.EventHandler;
import org.openmetadata.service.events.subscription.AlertUtil;
import org.openmetadata.service.events.subscription.AlertsRuleEvaluator;
import org.openmetadata.service.formatter.decorators.FeedMessageDecorator;
import org.openmetadata.service.formatter.util.FormatterUtil;
import org.openmetadata.service.jdbi3.CollectionDAO;
import org.openmetadata.service.jdbi3.FeedRepository;
import org.openmetadata.service.socket.WebSocketManager;
import org.openmetadata.service.util.FeedUtils;
import org.openmetadata.service.util.JsonUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChangeEventHandler
implements EventHandler {
    private static final Logger LOG = LoggerFactory.getLogger(ChangeEventHandler.class);
    private ObjectMapper mapper;
    private FeedMessageDecorator feedMessageDecorator = new FeedMessageDecorator();

    @Override
    public void init(OpenMetadataApplicationConfig config) {
        this.mapper = new ObjectMapper();
    }

    @Override
    public Void process(ContainerRequestContext requestContext, ContainerResponseContext responseContext) {
        String method = requestContext.getMethod();
        SecurityContext securityContext = requestContext.getSecurityContext();
        String loggedInUserName = securityContext.getUserPrincipal().getName();
        try {
            CollectionDAO collectionDAO = Entity.getCollectionDAO();
            CollectionDAO.ChangeEventDAO changeEventDAO = collectionDAO.changeEventDAO();
            FeedRepository feedRepository = new FeedRepository();
            Optional<ChangeEvent> optionalChangeEvent = FormatterUtil.getChangeEventFromResponseContext(responseContext, loggedInUserName, method);
            if (optionalChangeEvent.isPresent()) {
                ChangeEvent changeEvent = optionalChangeEvent.get();
                changeEvent.setUserName(loggedInUserName);
                LOG.info("Recording change event {}:{}:{}:{}", new Object[]{changeEvent.getTimestamp(), changeEvent.getEntityId(), changeEvent.getEventType(), changeEvent.getEntityType()});
                if (changeEvent.getEntity() != null) {
                    Object entity = changeEvent.getEntity();
                    changeEvent = ChangeEventHandler.copyChangeEvent(changeEvent);
                    changeEvent.setEntity((Object)JsonUtils.pojoToMaskedJson(entity));
                }
                changeEventDAO.insert(JsonUtils.pojoToJson(changeEvent));
                if (!changeEvent.getEntityType().equals("THREAD") && AlertUtil.shouldProcessActivityFeedRequest(changeEvent)) {
                    for (Thread thread : CommonUtil.listOrEmpty(FeedUtils.getThreadWithMessage(this.feedMessageDecorator, changeEvent, loggedInUserName))) {
                        if (thread.getMessage() == null || thread.getMessage().isEmpty()) continue;
                        feedRepository.create(thread, changeEvent);
                        String jsonThread = this.mapper.writeValueAsString((Object)thread);
                        WebSocketManager.getInstance().broadCastMessageToAll("activityFeed", jsonThread);
                        if (!changeEvent.getEventType().equals((Object)EventType.ENTITY_DELETED)) continue;
                        this.deleteAllConversationsRelatedToEntity(AlertsRuleEvaluator.getEntity(changeEvent), collectionDAO);
                    }
                }
            }
        }
        catch (Exception e) {
            LOG.error("Failed to capture the change event for method {} due to ", (Object)method, (Object)e);
        }
        return null;
    }

    private static ChangeEvent copyChangeEvent(ChangeEvent changeEvent) {
        return new ChangeEvent().withId(changeEvent.getId()).withEventType(changeEvent.getEventType()).withEntityId(changeEvent.getEntityId()).withEntityType(changeEvent.getEntityType()).withUserName(changeEvent.getUserName()).withTimestamp(changeEvent.getTimestamp()).withChangeDescription(changeEvent.getChangeDescription()).withCurrentVersion(changeEvent.getCurrentVersion());
    }

    private void deleteAllConversationsRelatedToEntity(EntityInterface entityInterface, CollectionDAO collectionDAO) {
        String entityId = entityInterface.getId().toString();
        List<String> threadIds = collectionDAO.feedDAO().findByEntityId(entityId);
        for (String threadId : threadIds) {
            UUID id = UUID.fromString(threadId);
            collectionDAO.relationshipDAO().deleteAll(id, "THREAD");
            collectionDAO.feedDAO().delete(id);
        }
    }

    @Override
    public void close() {
    }
}

