/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.jdbi3;

import java.util.List;
import java.util.function.BiPredicate;
import org.jdbi.v3.sqlobject.transaction.Transaction;
import org.openmetadata.schema.EntityInterface;
import org.openmetadata.schema.api.feed.ResolveTask;
import org.openmetadata.schema.entity.data.DashboardDataModel;
import org.openmetadata.schema.entity.services.DashboardService;
import org.openmetadata.schema.type.Column;
import org.openmetadata.schema.type.EntityReference;
import org.openmetadata.schema.type.Include;
import org.openmetadata.schema.type.TagLabel;
import org.openmetadata.schema.type.TaskType;
import org.openmetadata.service.Entity;
import org.openmetadata.service.jdbi3.ColumnUtil;
import org.openmetadata.service.jdbi3.EntityRepository;
import org.openmetadata.service.jdbi3.FeedRepository;
import org.openmetadata.service.resources.databases.DatabaseUtil;
import org.openmetadata.service.resources.feeds.MessageParser;
import org.openmetadata.service.util.EntityUtil;
import org.openmetadata.service.util.FullyQualifiedName;
import org.openmetadata.service.util.JsonUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DashboardDataModelRepository
extends EntityRepository<DashboardDataModel> {
    private static final Logger LOG = LoggerFactory.getLogger(DashboardDataModelRepository.class);

    public DashboardDataModelRepository() {
        super("/v1/dashboard/datamodels", "dashboardDataModel", DashboardDataModel.class, Entity.getCollectionDAO().dashboardDataModelDAO(), "", "");
        this.supportsSearch = true;
    }

    @Override
    public void setFullyQualifiedName(DashboardDataModel dashboardDataModel) {
        dashboardDataModel.setFullyQualifiedName(FullyQualifiedName.add(dashboardDataModel.getService().getName() + ".model", dashboardDataModel.getName()));
        ColumnUtil.setColumnFQN(dashboardDataModel.getFullyQualifiedName(), dashboardDataModel.getColumns());
    }

    @Override
    public FeedRepository.TaskWorkflow getTaskWorkflow(FeedRepository.ThreadContext threadContext) {
        this.validateTaskThread(threadContext);
        MessageParser.EntityLink entityLink = threadContext.getAbout();
        if (entityLink.getFieldName().equals("columns")) {
            TaskType taskType = threadContext.getThread().getTask().getType();
            if (EntityUtil.isDescriptionTask(taskType)) {
                return new ColumnDescriptionTaskWorkflow(threadContext);
            }
            if (EntityUtil.isTagTask(taskType)) {
                return new ColumnTagTaskWorkflow(threadContext);
            }
            throw new IllegalArgumentException(String.format("Invalid task type %s", taskType));
        }
        return super.getTaskWorkflow(threadContext);
    }

    @Override
    public void prepare(DashboardDataModel dashboardDataModel, boolean update) {
        DashboardService dashboardService = (DashboardService)Entity.getEntity(dashboardDataModel.getService(), "", Include.ALL);
        dashboardDataModel.setService(dashboardService.getEntityReference());
        dashboardDataModel.setServiceType(dashboardService.getServiceType());
    }

    @Override
    public void storeEntity(DashboardDataModel dashboardDataModel, boolean update) {
        EntityReference service = dashboardDataModel.getService();
        dashboardDataModel.withService(null);
        this.store(dashboardDataModel, update);
        dashboardDataModel.withService(service);
    }

    @Override
    public void storeRelationships(DashboardDataModel dashboardDataModel) {
        this.addServiceRelationship(dashboardDataModel, dashboardDataModel.getService());
    }

    @Override
    public void setFields(DashboardDataModel dashboardDataModel, EntityUtil.Fields fields) {
        Entity.populateEntityFieldTags(this.entityType, dashboardDataModel.getColumns(), dashboardDataModel.getFullyQualifiedName(), fields.contains("tags"));
        dashboardDataModel.setSourceHash(fields.contains("sourceHash") ? dashboardDataModel.getSourceHash() : null);
        if (dashboardDataModel.getService() == null) {
            dashboardDataModel.withService(this.getContainer(dashboardDataModel.getId()));
        }
    }

    @Override
    public void clearFields(DashboardDataModel dashboardDataModel, EntityUtil.Fields fields) {
    }

    @Override
    public void restorePatchAttributes(DashboardDataModel original, DashboardDataModel updated) {
        super.restorePatchAttributes(original, updated);
        updated.withService(original.getService());
    }

    @Override
    public void applyTags(DashboardDataModel dashboardDataModel) {
        super.applyTags(dashboardDataModel);
        this.applyColumnTags(dashboardDataModel.getColumns());
    }

    @Override
    public EntityInterface getParentEntity(DashboardDataModel entity, String fields) {
        return (EntityInterface)Entity.getEntity(entity.getService(), fields, Include.NON_DELETED);
    }

    @Override
    public EntityRepository.EntityUpdater getUpdater(DashboardDataModel original, DashboardDataModel updated, EntityRepository.Operation operation) {
        return new DataModelUpdater(original, updated, operation);
    }

    @Override
    public void validateTags(DashboardDataModel entity) {
        super.validateTags(entity);
        this.validateColumnTags(entity.getColumns());
    }

    static class ColumnDescriptionTaskWorkflow
    extends EntityRepository.DescriptionTaskWorkflow {
        private final Column column;

        ColumnDescriptionTaskWorkflow(FeedRepository.ThreadContext threadContext) {
            super(threadContext);
            DashboardDataModel dataModel = (DashboardDataModel)Entity.getEntity("dashboardDataModel", threadContext.getAboutEntity().getId(), "columns", Include.ALL);
            threadContext.setAboutEntity((EntityInterface)dataModel);
            this.column = EntityUtil.findColumn(dataModel.getColumns(), threadContext.getAbout().getArrayFieldName());
        }

        @Override
        public EntityInterface performTask(String user, ResolveTask resolveTask) {
            this.column.setDescription(resolveTask.getNewValue());
            return this.threadContext.getAboutEntity();
        }
    }

    static class ColumnTagTaskWorkflow
    extends EntityRepository.TagTaskWorkflow {
        private final Column column;

        ColumnTagTaskWorkflow(FeedRepository.ThreadContext threadContext) {
            super(threadContext);
            DashboardDataModel dataModel = (DashboardDataModel)Entity.getEntity("dashboardDataModel", threadContext.getAboutEntity().getId(), "columns,tags", Include.ALL);
            threadContext.setAboutEntity((EntityInterface)dataModel);
            this.column = EntityUtil.findColumn(dataModel.getColumns(), threadContext.getAbout().getArrayFieldName());
        }

        @Override
        public EntityInterface performTask(String user, ResolveTask resolveTask) {
            List<TagLabel> tags = JsonUtils.readObjects(resolveTask.getNewValue(), TagLabel.class);
            this.column.setTags(tags);
            return this.threadContext.getAboutEntity();
        }
    }

    public class DataModelUpdater
    extends EntityRepository.ColumnEntityUpdater {
        public DataModelUpdater(DashboardDataModel original, DashboardDataModel updated, EntityRepository.Operation operation) {
            super((EntityRepository)DashboardDataModelRepository.this, (EntityInterface)original, (EntityInterface)updated, operation);
        }

        @Override
        @Transaction
        public void entitySpecificUpdate() {
            DatabaseUtil.validateColumns(((DashboardDataModel)this.original).getColumns());
            this.updateColumns("columns", ((DashboardDataModel)this.original).getColumns(), ((DashboardDataModel)this.updated).getColumns(), (BiPredicate)EntityUtil.columnMatch);
            this.recordChange("sourceHash", ((DashboardDataModel)this.original).getSourceHash(), ((DashboardDataModel)this.updated).getSourceHash());
        }
    }
}

