/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.jdbi3;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.UUID;
import org.apache.commons.csv.CSVPrinter;
import org.apache.commons.csv.CSVRecord;
import org.jdbi.v3.sqlobject.transaction.Transaction;
import org.openmetadata.csv.CsvUtil;
import org.openmetadata.csv.EntityCsv;
import org.openmetadata.schema.EntityInterface;
import org.openmetadata.schema.entity.data.Database;
import org.openmetadata.schema.entity.data.DatabaseSchema;
import org.openmetadata.schema.entity.data.Table;
import org.openmetadata.schema.type.DatabaseSchemaProfilerConfig;
import org.openmetadata.schema.type.EntityReference;
import org.openmetadata.schema.type.Include;
import org.openmetadata.schema.type.Relationship;
import org.openmetadata.schema.type.csv.CsvDocumentation;
import org.openmetadata.schema.type.csv.CsvFile;
import org.openmetadata.schema.type.csv.CsvHeader;
import org.openmetadata.schema.type.csv.CsvImportResult;
import org.openmetadata.service.Entity;
import org.openmetadata.service.jdbi3.EntityRepository;
import org.openmetadata.service.jdbi3.ListFilter;
import org.openmetadata.service.jdbi3.TableRepository;
import org.openmetadata.service.util.EntityUtil;
import org.openmetadata.service.util.FullyQualifiedName;
import org.openmetadata.service.util.JsonUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DatabaseSchemaRepository
extends EntityRepository<DatabaseSchema> {
    private static final Logger LOG = LoggerFactory.getLogger(DatabaseSchemaRepository.class);
    public static final String DATABASE_SCHEMA_PROFILER_CONFIG_EXTENSION = "databaseSchema.databaseSchemaProfilerConfig";
    public static final String DATABASE_SCHEMA_PROFILER_CONFIG = "databaseSchemaProfilerConfig";

    public DatabaseSchemaRepository() {
        super("v1/databaseSchemas/", "databaseSchema", DatabaseSchema.class, Entity.getCollectionDAO().databaseSchemaDAO(), "", "");
        this.supportsSearch = true;
    }

    @Override
    public void setFullyQualifiedName(DatabaseSchema schema) {
        schema.setFullyQualifiedName(FullyQualifiedName.add(schema.getDatabase().getFullyQualifiedName(), schema.getName()));
    }

    @Override
    public void prepare(DatabaseSchema schema, boolean update) {
        this.populateDatabase(schema);
    }

    @Override
    public void storeEntity(DatabaseSchema schema, boolean update) {
        EntityReference service = schema.getService();
        schema.withService(null);
        this.store(schema, update);
        schema.withService(service);
    }

    @Override
    public void storeRelationships(DatabaseSchema schema) {
        EntityReference database = schema.getDatabase();
        this.addRelationship(database.getId(), schema.getId(), database.getType(), "databaseSchema", Relationship.CONTAINS);
    }

    private List<EntityReference> getTables(DatabaseSchema schema) {
        return schema == null ? Collections.emptyList() : this.findTo(schema.getId(), "databaseSchema", Relationship.CONTAINS, "table");
    }

    @Override
    public void setFields(DatabaseSchema schema, EntityUtil.Fields fields) {
        this.setDefaultFields(schema);
        schema.setSourceHash(fields.contains("sourceHash") ? schema.getSourceHash() : null);
        schema.setTables(fields.contains("tables") ? this.getTables(schema) : null);
        schema.setDatabaseSchemaProfilerConfig(fields.contains(DATABASE_SCHEMA_PROFILER_CONFIG) ? this.getDatabaseSchemaProfilerConfig(schema) : schema.getDatabaseSchemaProfilerConfig());
        schema.withUsageSummary(fields.contains("usageSummary") ? EntityUtil.getLatestUsage(this.daoCollection.usageDAO(), schema.getId()) : null);
    }

    @Override
    public void clearFields(DatabaseSchema schema, EntityUtil.Fields fields) {
        schema.setTables(fields.contains("tables") ? schema.getTables() : null);
        schema.setDatabaseSchemaProfilerConfig(fields.contains(DATABASE_SCHEMA_PROFILER_CONFIG) ? schema.getDatabaseSchemaProfilerConfig() : null);
        schema.withUsageSummary(fields.contains("usageSummary") ? schema.getUsageSummary() : null);
    }

    private void setDefaultFields(DatabaseSchema schema) {
        EntityReference databaseRef = this.getContainer(schema.getId());
        Database database = (Database)Entity.getEntity(databaseRef, "", Include.ALL);
        schema.withDatabase(databaseRef).withService(database.getService());
    }

    @Override
    public void setInheritedFields(DatabaseSchema schema, EntityUtil.Fields fields) {
        Database database = (Database)Entity.getEntity("database", schema.getDatabase().getId(), "owner,domain", Include.ALL);
        this.inheritOwner(schema, fields, (EntityInterface)database);
        this.inheritDomain(schema, fields, (EntityInterface)database);
        schema.withRetentionPeriod(schema.getRetentionPeriod() == null ? database.getRetentionPeriod() : schema.getRetentionPeriod());
    }

    @Override
    public void restorePatchAttributes(DatabaseSchema original, DatabaseSchema updated) {
        super.restorePatchAttributes(original, updated);
        updated.withService(original.getService());
    }

    @Override
    public EntityInterface getParentEntity(DatabaseSchema entity, String fields) {
        return (EntityInterface)Entity.getEntity(entity.getDatabase(), fields, Include.NON_DELETED);
    }

    @Override
    public EntityRepository.EntityUpdater getUpdater(DatabaseSchema original, DatabaseSchema updated, EntityRepository.Operation operation) {
        return new DatabaseSchemaUpdater(original, updated, operation);
    }

    private void populateDatabase(DatabaseSchema schema) {
        Database database = (Database)Entity.getEntity(schema.getDatabase(), "", Include.ALL);
        schema.withDatabase(database.getEntityReference()).withService(database.getService()).withServiceType(database.getServiceType());
    }

    @Override
    public String exportToCsv(String name, String user) throws IOException {
        DatabaseSchema schema = (DatabaseSchema)this.getByName(null, name, EntityUtil.Fields.EMPTY_FIELDS);
        TableRepository repository = (TableRepository)Entity.getEntityRepository("table");
        ListFilter filter = new ListFilter(Include.NON_DELETED).addQueryParam("databaseSchema", name);
        List tables = repository.listAll(repository.getFields("owner,tags,domain"), filter);
        tables.sort(Comparator.comparing(EntityInterface::getFullyQualifiedName));
        return new DatabaseSchemaCsv(schema, user).exportCsv(tables);
    }

    @Override
    public CsvImportResult importFromCsv(String name, String csv, boolean dryRun, String user) throws IOException {
        DatabaseSchema schema = (DatabaseSchema)this.getByName(null, name, EntityUtil.Fields.EMPTY_FIELDS);
        return new DatabaseSchemaCsv(schema, user).importCsv(csv, dryRun);
    }

    public DatabaseSchema addDatabaseSchemaProfilerConfig(UUID databaseSchemaId, DatabaseSchemaProfilerConfig databaseSchemaProfilerConfig) {
        DatabaseSchema databaseSchema = (DatabaseSchema)this.find(databaseSchemaId, Include.NON_DELETED);
        if (databaseSchemaProfilerConfig.getProfileSampleType() != null && databaseSchemaProfilerConfig.getProfileSample() != null) {
            EntityUtil.validateProfileSample(databaseSchemaProfilerConfig.getProfileSampleType().toString(), databaseSchemaProfilerConfig.getProfileSample());
        }
        this.daoCollection.entityExtensionDAO().insert(databaseSchemaId, DATABASE_SCHEMA_PROFILER_CONFIG_EXTENSION, DATABASE_SCHEMA_PROFILER_CONFIG, JsonUtils.pojoToJson(databaseSchemaProfilerConfig));
        this.clearFields(databaseSchema, EntityUtil.Fields.EMPTY_FIELDS);
        return databaseSchema.withDatabaseSchemaProfilerConfig(databaseSchemaProfilerConfig);
    }

    public DatabaseSchemaProfilerConfig getDatabaseSchemaProfilerConfig(DatabaseSchema databaseSchema) {
        return JsonUtils.readValue(this.daoCollection.entityExtensionDAO().getExtension(databaseSchema.getId(), DATABASE_SCHEMA_PROFILER_CONFIG_EXTENSION), DatabaseSchemaProfilerConfig.class);
    }

    public DatabaseSchema deleteDatabaseSchemaProfilerConfig(UUID databaseSchemaId) {
        DatabaseSchema database = (DatabaseSchema)this.find(databaseSchemaId, Include.NON_DELETED);
        this.daoCollection.entityExtensionDAO().delete(databaseSchemaId, DATABASE_SCHEMA_PROFILER_CONFIG_EXTENSION);
        this.setFieldsInternal(database, EntityUtil.Fields.EMPTY_FIELDS);
        return database;
    }

    public class DatabaseSchemaUpdater
    extends EntityRepository.EntityUpdater {
        public DatabaseSchemaUpdater(DatabaseSchema original, DatabaseSchema updated, EntityRepository.Operation operation) {
            super((EntityRepository)DatabaseSchemaRepository.this, (EntityInterface)original, (EntityInterface)updated, operation);
        }

        @Override
        @Transaction
        public void entitySpecificUpdate() {
            this.recordChange("retentionPeriod", ((DatabaseSchema)this.original).getRetentionPeriod(), ((DatabaseSchema)this.updated).getRetentionPeriod());
            this.recordChange("sourceUrl", ((DatabaseSchema)this.original).getSourceUrl(), ((DatabaseSchema)this.updated).getSourceUrl());
            this.recordChange("sourceHash", ((DatabaseSchema)this.original).getSourceHash(), ((DatabaseSchema)this.updated).getSourceHash());
        }
    }

    public static class DatabaseSchemaCsv
    extends EntityCsv<Table> {
        public static final CsvDocumentation DOCUMENTATION = DatabaseSchemaCsv.getCsvDocumentation("databaseSchema");
        public static final List<CsvHeader> HEADERS = DOCUMENTATION.getHeaders();
        private final DatabaseSchema schema;

        DatabaseSchemaCsv(DatabaseSchema schema, String user) {
            super("table", DOCUMENTATION.getHeaders(), user);
            this.schema = schema;
        }

        @Override
        protected void createEntity(CSVPrinter printer, List<CSVRecord> csvRecords) throws IOException {
            Table table;
            CSVRecord csvRecord = this.getNextRecord(printer, csvRecords);
            String tableFqn = FullyQualifiedName.add(this.schema.getFullyQualifiedName(), csvRecord.get(0));
            try {
                table = (Table)Entity.getEntityByName("table", tableFqn, "*", Include.NON_DELETED);
            }
            catch (Exception ex) {
                this.importFailure(printer, DatabaseSchemaCsv.entityNotFound(0, "table", tableFqn), csvRecord);
                this.processRecord = false;
                return;
            }
            table.withDisplayName(csvRecord.get(1)).withDescription(csvRecord.get(2)).withOwner(this.getOwner(printer, csvRecord, 3)).withTags(this.getTagLabels(printer, csvRecord, 4)).withRetentionPeriod(csvRecord.get(5)).withSourceUrl(csvRecord.get(6)).withDomain(this.getEntityReference(printer, csvRecord, 7, "domain"));
            if (this.processRecord) {
                this.createEntity(printer, csvRecord, table);
            }
        }

        @Override
        protected void addRecord(CsvFile csvFile, Table entity) {
            ArrayList<String> recordList = new ArrayList<String>();
            CsvUtil.addField(recordList, entity.getName());
            CsvUtil.addField(recordList, entity.getDisplayName());
            CsvUtil.addField(recordList, entity.getDescription());
            CsvUtil.addOwner(recordList, entity.getOwner());
            CsvUtil.addTagLabels(recordList, entity.getTags());
            CsvUtil.addField(recordList, entity.getRetentionPeriod());
            CsvUtil.addField(recordList, entity.getSourceUrl());
            String domain = entity.getDomain() == null || Boolean.TRUE.equals(entity.getDomain().getInherited()) ? "" : entity.getDomain().getFullyQualifiedName();
            CsvUtil.addField(recordList, domain);
            this.addRecord(csvFile, (List<String>)recordList);
        }
    }
}

