/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.jdbi3;

import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import org.openmetadata.schema.type.Include;
import org.openmetadata.schema.type.Relationship;
import org.openmetadata.schema.utils.EntityInterfaceUtil;
import org.openmetadata.service.resources.databases.DatasourceConfig;
import org.openmetadata.service.util.FullyQualifiedName;

public class ListFilter {
    private final Include include;
    protected final Map<String, String> queryParams = new HashMap<String, String>();

    public ListFilter() {
        this(Include.NON_DELETED);
    }

    public ListFilter(Include include) {
        this.include = include;
    }

    public ListFilter addQueryParam(String name, String value) {
        this.queryParams.put(name, value);
        return this;
    }

    public ListFilter addQueryParam(String name, Boolean value) {
        this.queryParams.put(name, String.valueOf(value));
        return this;
    }

    public void removeQueryParam(String name) {
        this.queryParams.remove(name);
    }

    public String getQueryParam(String name) {
        return name.equals("include") ? this.include.value() : this.queryParams.get(name);
    }

    public String getCondition() {
        return this.getCondition(null);
    }

    public String getCondition(String tableName) {
        String condition = this.getIncludeCondition(tableName);
        condition = this.addCondition(condition, this.getDatabaseCondition(tableName));
        condition = this.addCondition(condition, this.getDatabaseSchemaCondition(tableName));
        condition = this.addCondition(condition, this.getServiceCondition(tableName));
        condition = this.addCondition(condition, this.getPipelineTypeCondition(tableName));
        condition = this.addCondition(condition, this.getParentCondition(tableName));
        condition = this.addCondition(condition, this.getDisabledCondition());
        condition = this.addCondition(condition, this.getCategoryCondition(tableName));
        condition = this.addCondition(condition, this.getWebhookCondition(tableName));
        condition = this.addCondition(condition, this.getWebhookTypeCondition(tableName));
        condition = this.addCondition(condition, this.getTestCaseCondition());
        condition = this.addCondition(condition, this.getTestSuiteTypeCondition(tableName));
        condition = this.addCondition(condition, this.getTestSuiteFQNCondition());
        condition = this.addCondition(condition, this.getDomainCondition());
        condition = this.addCondition(condition, this.getEntityFQNHashCondition());
        condition = this.addCondition(condition, this.getTestCaseResolutionStatusType());
        condition = this.addCondition(condition, this.getAssignee());
        return (condition = this.addCondition(condition, this.getEventSubscriptionAlertType())).isEmpty() ? "WHERE TRUE" : "WHERE " + condition;
    }

    private String getAssignee() {
        String assignee = this.queryParams.get("assignee");
        return assignee == null ? "" : String.format("assignee = '%s'", assignee);
    }

    private String getEventSubscriptionAlertType() {
        String alertType = this.queryParams.get("alertType");
        if (alertType == null) {
            return "";
        }
        if (Boolean.TRUE.equals(DatasourceConfig.getInstance().isMySQL())) {
            return String.format("JSON_EXTRACT(json, '$.alertType') = '%s'", alertType);
        }
        return String.format("json->>'alertType' = '%s'", alertType);
    }

    private String getTestCaseResolutionStatusType() {
        String testFailureStatus = this.queryParams.get("testCaseResolutionStatusType");
        return testFailureStatus == null ? "" : String.format("testCaseResolutionStatusType = '%s'", testFailureStatus);
    }

    public String getIncludeCondition(String tableName) {
        Object columnName;
        Object object = columnName = tableName == null ? "deleted" : tableName + ".deleted";
        if (this.include == Include.NON_DELETED) {
            return (String)columnName + " = FALSE";
        }
        if (this.include == Include.DELETED) {
            return (String)columnName + " = TRUE";
        }
        return "";
    }

    public String getDatabaseCondition(String tableName) {
        String database = this.queryParams.get("database");
        return database == null ? "" : this.getFqnPrefixCondition(tableName, database);
    }

    public String getDatabaseSchemaCondition(String tableName) {
        String databaseSchema = this.queryParams.get("databaseSchema");
        return databaseSchema == null ? "" : this.getFqnPrefixCondition(tableName, databaseSchema);
    }

    public String getServiceCondition(String tableName) {
        String service = this.queryParams.get("service");
        return service == null ? "" : this.getFqnPrefixCondition(tableName, EntityInterfaceUtil.quoteName((String)service));
    }

    public String getTestSuiteFQNCondition() {
        String testSuiteName = this.queryParams.get("testSuite");
        return testSuiteName == null ? "" : String.format("fqnHash LIKE '%s%s%%'", FullyQualifiedName.buildHash(testSuiteName), ".");
    }

    private String getDomainCondition() {
        String domainId = this.getQueryParam("domainId");
        return domainId == null ? "" : String.format("(id in (SELECT toId FROM entity_relationship WHERE fromEntity='domain' AND fromId='%s' AND relation=10))", domainId);
    }

    private String getEntityFQNHashCondition() {
        String entityFQN = this.getQueryParam("entityFQNHash");
        return entityFQN == null ? "" : String.format("entityFQNHash = '%s'", FullyQualifiedName.buildHash(entityFQN));
    }

    public String getParentCondition(String tableName) {
        String parentFqn = this.queryParams.get("parent");
        return parentFqn == null ? "" : this.getFqnPrefixCondition(tableName, parentFqn);
    }

    public String getDisabledCondition() {
        String disabledStr = this.queryParams.get("disabled");
        if (disabledStr == null) {
            return "";
        }
        boolean disabled = Boolean.parseBoolean(disabledStr);
        String disabledCondition = Boolean.TRUE.equals(DatasourceConfig.getInstance().isMySQL()) ? (disabled ? "JSON_EXTRACT(json, '$.disabled') = TRUE" : "(JSON_EXTRACT(json, '$.disabled') IS NULL OR JSON_EXTRACT(json, '$.disabled') = FALSE)") : (disabled ? "((c.json#>'{disabled}')::boolean)  = TRUE)" : "(c.json#>'{disabled}' IS NULL OR ((c.json#>'{disabled}'):boolean) = FALSE");
        return disabledCondition;
    }

    public String getCategoryCondition(String tableName) {
        String category = this.queryParams.get("category");
        return category == null ? "" : this.getCategoryPrefixCondition(tableName, category);
    }

    public String getWebhookCondition(String tableName) {
        String webhookStatus = this.queryParams.get("status");
        return webhookStatus == null ? "" : this.getStatusPrefixCondition(tableName, webhookStatus);
    }

    public String getWebhookTypeCondition(String tableName) {
        String webhookType = this.queryParams.get("webhookType");
        return webhookType == null ? "" : this.getWebhookTypePrefixCondition(tableName, webhookType);
    }

    public String getPipelineTypeCondition(String tableName) {
        String pipelineType = this.queryParams.get("pipelineType");
        return pipelineType == null ? "" : this.getPipelineTypePrefixCondition(tableName, pipelineType);
    }

    private String getTestCaseCondition() {
        String condition1 = "";
        String entityFQN = this.getQueryParam("entityFQN");
        boolean includeAllTests = Boolean.parseBoolean(this.getQueryParam("includeAllTests"));
        if (entityFQN != null) {
            condition1 = includeAllTests ? String.format("entityFQN LIKE '%s%s%%' OR entityFQN = '%s'", ListFilter.escape(entityFQN), ".", ListFilter.escapeApostrophe(entityFQN)) : String.format("entityFQN = '%s'", ListFilter.escapeApostrophe(entityFQN));
        }
        String condition2 = "";
        String testSuiteId = this.getQueryParam("testSuiteId");
        if (testSuiteId != null) {
            condition2 = String.format("id IN (SELECT toId FROM entity_relationship WHERE fromId='%s' AND toEntity='%s' AND relation=%d AND fromEntity='%s')", testSuiteId, "testCase", Relationship.CONTAINS.ordinal(), "testSuite");
        }
        return this.addCondition(condition1, condition2);
    }

    private String getTestSuiteTypeCondition(String tableName) {
        String testSuiteType = this.getQueryParam("testSuiteType");
        if (testSuiteType == null) {
            return "";
        }
        return switch (testSuiteType) {
            case "executable" -> {
                if (Boolean.TRUE.equals(DatasourceConfig.getInstance().isMySQL())) {
                    yield String.format("(JSON_UNQUOTE(JSON_EXTRACT(%s.json, '$.executable')) = 'true')", tableName);
                }
                yield String.format("(%s.json->>'executable' = 'true')", tableName);
            }
            case "logical" -> {
                if (Boolean.TRUE.equals(DatasourceConfig.getInstance().isMySQL())) {
                    yield String.format("(JSON_UNQUOTE(JSON_EXTRACT(%s.json, '$.executable')) = 'false' OR JSON_UNQUOTE(JSON_EXTRACT(%s.json, '$.executable')) IS NULL)", tableName, tableName);
                }
                yield String.format("(%s.json->>'executable' = 'false' or %s.json -> 'executable' is null)", tableName, tableName);
            }
            default -> "";
        };
    }

    private String getFqnPrefixCondition(String tableName, String fqnPrefix) {
        return tableName == null ? String.format("fqnHash LIKE '%s%s%%'", FullyQualifiedName.buildHash(fqnPrefix), ".") : String.format("%s.fqnHash LIKE '%s%s%%'", tableName, FullyQualifiedName.buildHash(fqnPrefix), ".");
    }

    private String getWebhookTypePrefixCondition(String tableName, String typePrefix) {
        typePrefix = ListFilter.escape(typePrefix);
        return tableName == null ? String.format("webhookType LIKE '%s%%'", typePrefix) : String.format("%s.webhookType LIKE '%s%%'", tableName, typePrefix);
    }

    private String getPipelineTypePrefixCondition(String tableName, String pipelineType) {
        pipelineType = ListFilter.escape(pipelineType);
        String inCondition = this.getInConditionFromString(pipelineType);
        if (Boolean.TRUE.equals(DatasourceConfig.getInstance().isMySQL())) {
            return tableName == null ? String.format("JSON_UNQUOTE(JSON_EXTRACT(ingestion_pipeline_entity.json, '$.pipelineType')) IN (%s)", inCondition) : String.format("%s.JSON_UNQUOTE(JSON_EXTRACT(ingestion_pipeline_entity.json, '$.pipelineType')) IN (%s)", tableName, inCondition);
        }
        return tableName == null ? String.format("ingestion_pipeline_entity.json->>'pipelineType' IN (%s)", inCondition) : String.format("%s.json->>'pipelineType' IN (%s)", tableName, inCondition);
    }

    private String getInConditionFromString(String condition) {
        return Arrays.stream(condition.split(",")).map(s -> String.format("'%s'", s)).collect(Collectors.joining(","));
    }

    private String getCategoryPrefixCondition(String tableName, String category) {
        category = ListFilter.escape(category);
        return tableName == null ? String.format("category LIKE '%s%s%%'", category, "") : String.format("%s.category LIKE '%s%s%%'", tableName, category, "");
    }

    private String getStatusPrefixCondition(String tableName, String statusPrefix) {
        if (!statusPrefix.isEmpty()) {
            ArrayList<String> statusList = new ArrayList<String>(Arrays.asList(statusPrefix.split(",")));
            ArrayList<CallSite> condition = new ArrayList<CallSite>();
            for (String s : statusList) {
                String format = "\"" + s + "\"";
                condition.add((CallSite)((Object)format));
            }
            return "status in (" + String.join((CharSequence)",", condition) + ")";
        }
        return tableName == null ? String.format("status LIKE '%s%s%%'", statusPrefix, "") : String.format("%s.status LIKE '%s%s%%'", tableName, statusPrefix, "");
    }

    protected String addCondition(String condition1, String condition2) {
        if (condition1.isEmpty()) {
            return condition2;
        }
        if (condition2.isEmpty()) {
            return condition1;
        }
        return condition1 + " AND " + condition2;
    }

    public static String escapeApostrophe(String name) {
        return name.replace("'", "''");
    }

    public static String escape(String name) {
        name = ListFilter.escapeApostrophe(name);
        return name.replaceAll("_", "\\\\_");
    }

    public Include getInclude() {
        return this.include;
    }
}

