/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.jdbi3;

import java.util.ArrayList;
import java.util.List;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.apache.commons.lang3.tuple.Triple;
import org.jdbi.v3.sqlobject.transaction.Transaction;
import org.openmetadata.common.utils.CommonUtil;
import org.openmetadata.schema.EntityInterface;
import org.openmetadata.schema.api.feed.ResolveTask;
import org.openmetadata.schema.entity.data.Pipeline;
import org.openmetadata.schema.entity.data.PipelineStatus;
import org.openmetadata.schema.entity.services.PipelineService;
import org.openmetadata.schema.entity.teams.User;
import org.openmetadata.schema.type.ChangeDescription;
import org.openmetadata.schema.type.EntityReference;
import org.openmetadata.schema.type.EventType;
import org.openmetadata.schema.type.FieldChange;
import org.openmetadata.schema.type.Include;
import org.openmetadata.schema.type.Relationship;
import org.openmetadata.schema.type.Status;
import org.openmetadata.schema.type.TagLabel;
import org.openmetadata.schema.type.Task;
import org.openmetadata.schema.type.TaskType;
import org.openmetadata.service.Entity;
import org.openmetadata.service.exception.CatalogExceptionMessage;
import org.openmetadata.service.exception.EntityNotFoundException;
import org.openmetadata.service.jdbi3.EntityRepository;
import org.openmetadata.service.jdbi3.FeedRepository;
import org.openmetadata.service.resources.feeds.MessageParser;
import org.openmetadata.service.resources.tags.TagLabelUtil;
import org.openmetadata.service.util.EntityUtil;
import org.openmetadata.service.util.FullyQualifiedName;
import org.openmetadata.service.util.JsonUtils;
import org.openmetadata.service.util.RestUtil;
import org.openmetadata.service.util.ResultList;

public class PipelineRepository
extends EntityRepository<Pipeline> {
    private static final String TASKS_FIELD = "tasks";
    private static final String PIPELINE_UPDATE_FIELDS = "tasks";
    private static final String PIPELINE_PATCH_FIELDS = "tasks,sourceHash";
    public static final String PIPELINE_STATUS_EXTENSION = "pipeline.pipelineStatus";

    public PipelineRepository() {
        super("v1/pipelines/", "pipeline", Pipeline.class, Entity.getCollectionDAO().pipelineDAO(), PIPELINE_PATCH_FIELDS, "tasks");
        this.supportsSearch = true;
    }

    @Override
    public void setFullyQualifiedName(Pipeline pipeline) {
        pipeline.setFullyQualifiedName(FullyQualifiedName.add(pipeline.getService().getFullyQualifiedName(), pipeline.getName()));
        this.setTaskFQN(pipeline.getFullyQualifiedName(), pipeline.getTasks());
    }

    @Override
    public FeedRepository.TaskWorkflow getTaskWorkflow(FeedRepository.ThreadContext threadContext) {
        this.validateTaskThread(threadContext);
        MessageParser.EntityLink entityLink = threadContext.getAbout();
        if (entityLink.getFieldName().equals("tasks")) {
            TaskType taskType = threadContext.getThread().getTask().getType();
            if (EntityUtil.isDescriptionTask(taskType)) {
                return new TaskDescriptionWorkflow(threadContext);
            }
            if (EntityUtil.isTagTask(taskType)) {
                return new TaskTagWorkflow(threadContext);
            }
            throw new IllegalArgumentException(String.format("Invalid task type %s", taskType));
        }
        return super.getTaskWorkflow(threadContext);
    }

    @Override
    public void setFields(Pipeline pipeline, EntityUtil.Fields fields) {
        pipeline.setService(this.getContainer(pipeline.getId()));
        pipeline.setSourceHash(fields.contains("sourceHash") ? pipeline.getSourceHash() : null);
        this.getTaskTags(fields.contains("tags"), pipeline.getTasks());
        this.getTaskOwners(fields.contains("owner"), pipeline.getTasks());
        pipeline.withPipelineStatus(fields.contains("pipelineStatus") ? this.getPipelineStatus(pipeline) : pipeline.getPipelineStatus());
    }

    @Override
    public void clearFields(Pipeline pipeline, EntityUtil.Fields fields) {
        pipeline.withTasks(fields.contains("tasks") ? pipeline.getTasks() : null);
        pipeline.withPipelineStatus(fields.contains("pipelineStatus") ? pipeline.getPipelineStatus() : null);
    }

    @Override
    protected void postDelete(Pipeline entity) {
        for (Task task : CommonUtil.listOrEmpty((List)entity.getTasks())) {
            this.deleteTaskOwnerRelationship(task);
        }
    }

    private PipelineStatus getPipelineStatus(Pipeline pipeline) {
        return JsonUtils.readValue(this.getLatestExtensionFromTimeSeries(pipeline.getFullyQualifiedName(), PIPELINE_STATUS_EXTENSION), PipelineStatus.class);
    }

    public RestUtil.PutResponse<?> addPipelineStatus(UriInfo uriInfo, String fqn, PipelineStatus pipelineStatus) {
        Pipeline pipeline = (Pipeline)this.daoCollection.pipelineDAO().findEntityByName(fqn);
        pipeline.setService(this.getContainer(pipeline.getId()));
        for (Status taskStatus : pipelineStatus.getTaskStatus()) {
            this.validateTask(pipeline, taskStatus.getName());
        }
        String storedPipelineStatus = this.getExtensionAtTimestamp(fqn, PIPELINE_STATUS_EXTENSION, pipelineStatus.getTimestamp());
        if (storedPipelineStatus != null) {
            this.daoCollection.entityExtensionTimeSeriesDao().update(pipeline.getFullyQualifiedName(), PIPELINE_STATUS_EXTENSION, JsonUtils.pojoToJson(pipelineStatus), pipelineStatus.getTimestamp());
        } else {
            this.storeTimeSeries(pipeline.getFullyQualifiedName(), PIPELINE_STATUS_EXTENSION, "pipelineStatus", JsonUtils.pojoToJson(pipelineStatus));
        }
        ChangeDescription change = this.addPipelineStatusChangeDescription(pipeline.getVersion(), pipelineStatus, storedPipelineStatus);
        return new RestUtil.PutResponse<Pipeline>(Response.Status.OK, pipeline.withPipelineStatus(pipelineStatus).withUpdatedAt(Long.valueOf(System.currentTimeMillis())).withChangeDescription(change), EventType.ENTITY_UPDATED);
    }

    private ChangeDescription addPipelineStatusChangeDescription(Double version, Object newValue, Object oldValue) {
        FieldChange fieldChange = new FieldChange().withName("pipelineStatus").withNewValue(newValue).withOldValue(oldValue);
        ChangeDescription change = new ChangeDescription().withPreviousVersion(version);
        change.getFieldsUpdated().add(fieldChange);
        return change;
    }

    public Pipeline deletePipelineStatus(String fqn, Long timestamp) {
        Pipeline pipeline = (Pipeline)this.findByName(fqn, Include.NON_DELETED);
        pipeline.setService(this.getContainer(pipeline.getId()));
        PipelineStatus storedPipelineStatus = JsonUtils.readValue(this.getExtensionAtTimestamp(fqn, PIPELINE_STATUS_EXTENSION, timestamp), PipelineStatus.class);
        if (storedPipelineStatus != null) {
            this.deleteExtensionAtTimestamp(fqn, PIPELINE_STATUS_EXTENSION, timestamp);
            pipeline.setPipelineStatus(storedPipelineStatus);
            return pipeline;
        }
        throw new EntityNotFoundException(String.format("Failed to find pipeline status for %s at %s", pipeline.getName(), timestamp));
    }

    public ResultList<PipelineStatus> getPipelineStatuses(String fqn, Long starTs, Long endTs) {
        List<PipelineStatus> pipelineStatuses = JsonUtils.readObjects(this.getResultsFromAndToTimestamps(fqn, PIPELINE_STATUS_EXTENSION, starTs, endTs), PipelineStatus.class);
        return new ResultList<PipelineStatus>(pipelineStatuses, starTs.toString(), endTs.toString(), pipelineStatuses.size());
    }

    private void validateTask(Pipeline pipeline, String taskName) {
        boolean validTask = pipeline.getTasks().stream().anyMatch(task -> task.getName().equals(taskName));
        if (!validTask) {
            throw new IllegalArgumentException("Invalid task name " + taskName);
        }
    }

    @Override
    public void restorePatchAttributes(Pipeline original, Pipeline updated) {
        super.restorePatchAttributes(original, updated);
        updated.withService(original.getService());
    }

    @Override
    public void prepare(Pipeline pipeline, boolean update) {
        this.populateService(pipeline);
        for (Task task : CommonUtil.listOrEmpty((List)pipeline.getTasks())) {
            EntityReference owner = this.validateOwner(task.getOwner());
            task.setOwner(owner);
        }
    }

    @Override
    public void storeEntity(Pipeline pipeline, boolean update) {
        EntityReference service = pipeline.getService();
        pipeline.withService(null);
        List taskWithTagsAndOwners = pipeline.getTasks();
        pipeline.setTasks(this.cloneWithoutTagsAndOwners(taskWithTagsAndOwners));
        this.store(pipeline, update);
        pipeline.withService(service).withTasks(taskWithTagsAndOwners);
    }

    @Override
    public void storeRelationships(Pipeline pipeline) {
        this.addServiceRelationship(pipeline, pipeline.getService());
        for (Task task : CommonUtil.listOrEmpty((List)pipeline.getTasks())) {
            if (task.getOwner() == null) continue;
            this.daoCollection.fieldRelationshipDAO().insert(FullyQualifiedName.buildHash(task.getOwner().getFullyQualifiedName()), FullyQualifiedName.buildHash(task.getFullyQualifiedName()), task.getOwner().getFullyQualifiedName(), task.getFullyQualifiedName(), task.getOwner().getType(), "task", Relationship.OWNS.ordinal(), null);
        }
    }

    @Override
    public void applyTags(Pipeline pipeline) {
        super.applyTags(pipeline);
        this.applyTaskTags(pipeline.getTasks());
    }

    @Override
    public EntityInterface getParentEntity(Pipeline entity, String fields) {
        return (EntityInterface)Entity.getEntity(entity.getService(), fields, Include.ALL);
    }

    @Override
    public void validateTags(Pipeline entity) {
        super.validateTags(entity);
        for (Task task : CommonUtil.listOrEmpty((List)entity.getTasks())) {
            this.validateTags(task.getTags());
            task.setTags(TagLabelUtil.addDerivedTags(task.getTags()));
            TagLabelUtil.checkMutuallyExclusive(task.getTags());
        }
    }

    private void applyTaskTags(List<Task> tasks) {
        for (Task task : CommonUtil.listOrEmpty(tasks)) {
            this.applyTags(task.getTags(), task.getFullyQualifiedName());
        }
    }

    private void getTaskTags(boolean setTags, List<Task> tasks) {
        for (Task t : CommonUtil.listOrEmpty(tasks)) {
            if (t.getTags() != null) continue;
            t.setTags((List)(setTags ? this.getTags(t.getFullyQualifiedName()) : t.getTags()));
        }
    }

    private void getTaskOwners(boolean setOwner, List<Task> tasks) {
        for (Task t : CommonUtil.listOrEmpty(tasks)) {
            if (t.getOwner() != null) continue;
            t.setOwner(setOwner ? this.getTaskOwner(t.getFullyQualifiedName()) : t.getOwner());
        }
    }

    private EntityReference getTaskOwner(String taskFullyQualifiedName) {
        EntityReference ownerRef = null;
        List<Triple<String, String, String>> owners = this.daoCollection.fieldRelationshipDAO().findFrom(FullyQualifiedName.buildHash(taskFullyQualifiedName), "task", Relationship.OWNS.ordinal());
        for (Triple<String, String, String> owner : owners) {
            if (!((String)owner.getMiddle()).equals("user")) continue;
            User user = this.daoCollection.userDAO().findEntityByName((String)owner.getLeft(), Include.NON_DELETED);
            ownerRef = new EntityReference().withId(user.getId()).withName(user.getName()).withFullyQualifiedName(user.getFullyQualifiedName()).withDescription(user.getDescription()).withDisplayName(user.getDisplayName()).withHref(user.getHref()).withDeleted(user.getDeleted());
        }
        return ownerRef;
    }

    private void setTaskFQN(String parentFQN, List<Task> tasks) {
        if (tasks != null) {
            tasks.forEach(t -> {
                String taskFqn = FullyQualifiedName.add(parentFQN, t.getName());
                t.setFullyQualifiedName(taskFqn);
            });
        }
    }

    @Override
    public EntityRepository.EntityUpdater getUpdater(Pipeline original, Pipeline updated, EntityRepository.Operation operation) {
        return new PipelineUpdater(original, updated, operation);
    }

    @Override
    public List<TagLabel> getAllTags(EntityInterface entity) {
        ArrayList<TagLabel> allTags = new ArrayList<TagLabel>();
        Pipeline pipeline = (Pipeline)entity;
        EntityUtil.mergeTags(allTags, pipeline.getTags());
        for (Task task : CommonUtil.listOrEmpty((List)pipeline.getTasks())) {
            EntityUtil.mergeTags(allTags, task.getTags());
        }
        return allTags;
    }

    private void populateService(Pipeline pipeline) {
        PipelineService service = (PipelineService)Entity.getEntity(pipeline.getService(), "", Include.NON_DELETED);
        pipeline.setService(service.getEntityReference());
        pipeline.setServiceType(service.getServiceType());
    }

    private List<Task> cloneWithoutTagsAndOwners(List<Task> tasks) {
        if (CommonUtil.nullOrEmpty(tasks)) {
            return tasks;
        }
        ArrayList<Task> copy = new ArrayList<Task>();
        tasks.forEach(t -> copy.add(this.cloneWithoutTagsAndOwners((Task)t)));
        return copy;
    }

    private Task cloneWithoutTagsAndOwners(Task task) {
        return new Task().withDescription(task.getDescription()).withName(task.getName()).withDisplayName(task.getDisplayName()).withFullyQualifiedName(task.getFullyQualifiedName()).withSourceUrl(task.getSourceUrl()).withTaskType(task.getTaskType()).withDownstreamTasks(task.getDownstreamTasks()).withTaskSQL(task.getTaskSQL()).withStartDate(task.getStartDate()).withEndDate(task.getEndDate());
    }

    protected void deleteTaskOwnerRelationship(Task task) {
        if (task.getOwner() != null) {
            this.daoCollection.fieldRelationshipDAO().delete(FullyQualifiedName.buildHash(task.getOwner().getFullyQualifiedName()), FullyQualifiedName.buildHash(task.getFullyQualifiedName()), task.getOwner().getType(), "task", Relationship.OWNS.ordinal());
        }
    }

    public static Task findTask(List<Task> tasks, String taskName) {
        return tasks.stream().filter(c -> c.getName().equals(taskName)).findFirst().orElseThrow(() -> new IllegalArgumentException(CatalogExceptionMessage.invalidFieldName("task", taskName)));
    }

    static class TaskDescriptionWorkflow
    extends EntityRepository.DescriptionTaskWorkflow {
        private final Task task;

        TaskDescriptionWorkflow(FeedRepository.ThreadContext threadContext) {
            super(threadContext);
            Pipeline pipeline = (Pipeline)Entity.getEntity("container", threadContext.getAboutEntity().getId(), "tasks", Include.ALL);
            threadContext.setAboutEntity((EntityInterface)pipeline);
            this.task = PipelineRepository.findTask(pipeline.getTasks(), threadContext.getAbout().getArrayFieldName());
        }

        @Override
        public EntityInterface performTask(String user, ResolveTask resolveTask) {
            this.task.setDescription(resolveTask.getNewValue());
            return this.threadContext.getAboutEntity();
        }
    }

    static class TaskTagWorkflow
    extends EntityRepository.TagTaskWorkflow {
        private final Task task;

        TaskTagWorkflow(FeedRepository.ThreadContext threadContext) {
            super(threadContext);
            Pipeline pipeline = (Pipeline)Entity.getEntity("container", threadContext.getAboutEntity().getId(), "tasks,tags", Include.ALL);
            threadContext.setAboutEntity((EntityInterface)pipeline);
            this.task = PipelineRepository.findTask(pipeline.getTasks(), threadContext.getAbout().getArrayFieldName());
        }

        @Override
        public EntityInterface performTask(String user, ResolveTask resolveTask) {
            List<TagLabel> tags = JsonUtils.readObjects(resolveTask.getNewValue(), TagLabel.class);
            this.task.setTags(tags);
            return this.threadContext.getAboutEntity();
        }
    }

    public class PipelineUpdater
    extends EntityRepository.EntityUpdater {
        public PipelineUpdater(Pipeline original, Pipeline updated, EntityRepository.Operation operation) {
            super((EntityRepository)PipelineRepository.this, (EntityInterface)original, (EntityInterface)updated, operation);
        }

        @Override
        @Transaction
        public void entitySpecificUpdate() {
            this.updateTasks((Pipeline)this.original, (Pipeline)this.updated);
            this.recordChange("sourceUrl", ((Pipeline)this.original).getSourceUrl(), ((Pipeline)this.updated).getSourceUrl());
            this.recordChange("concurrency", ((Pipeline)this.original).getConcurrency(), ((Pipeline)this.updated).getConcurrency());
            this.recordChange("pipelineLocation", ((Pipeline)this.original).getPipelineLocation(), ((Pipeline)this.updated).getPipelineLocation());
            this.recordChange("sourceHash", ((Pipeline)this.original).getSourceHash(), ((Pipeline)this.updated).getSourceHash());
        }

        private void updateTasks(Pipeline original, Pipeline updated) {
            boolean removedTasks;
            List origTasks = CommonUtil.listOrEmpty((List)original.getTasks());
            List updatedTasks = CommonUtil.listOrEmpty((List)updated.getTasks());
            boolean newTasks = false;
            for (Task updatedTask : updatedTasks) {
                Task storedTask = origTasks.stream().filter(c -> EntityUtil.taskMatch.test((Task)c, updatedTask)).findAny().orElse(null);
                if (storedTask == null) {
                    newTasks = true;
                    continue;
                }
                this.updateTaskDescription(storedTask, updatedTask);
                this.updateTags(storedTask.getFullyQualifiedName(), EntityUtil.getFieldName("tasks", updatedTask.getName(), "tags"), storedTask.getTags(), updatedTask.getTags());
            }
            boolean bl = removedTasks = updatedTasks.size() < origTasks.size();
            if (newTasks || removedTasks) {
                ArrayList<Task> added = new ArrayList<Task>();
                ArrayList deleted = new ArrayList();
                this.recordListChange("tasks", origTasks, updatedTasks, added, deleted, EntityUtil.taskMatch);
                PipelineRepository.this.applyTaskTags(added);
                deleted.forEach(d -> {
                    PipelineRepository.this.daoCollection.tagUsageDAO().deleteTagsByTarget(d.getFullyQualifiedName());
                    PipelineRepository.this.deleteTaskOwnerRelationship((Task)d);
                });
            }
        }

        private void updateTaskDescription(Task origTask, Task updatedTask) {
            if (this.operation.isPut() && !CommonUtil.nullOrEmpty((String)origTask.getDescription()) && this.updatedByBot()) {
                updatedTask.setDescription(origTask.getDescription());
                return;
            }
            if (origTask != null && (origTask.getDescription() != null && !origTask.getDescription().equals(updatedTask.getDescription()) || updatedTask.getDescription() != null)) {
                this.recordChange("tasks." + origTask.getName() + ".description", origTask.getDescription(), updatedTask.getDescription());
            }
        }
    }
}

