/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.jdbi3;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.ws.rs.core.SecurityContext;
import org.jdbi.v3.sqlobject.transaction.Transaction;
import org.openmetadata.common.utils.CommonUtil;
import org.openmetadata.schema.EntityInterface;
import org.openmetadata.schema.entity.data.Table;
import org.openmetadata.schema.tests.ResultSummary;
import org.openmetadata.schema.tests.TestSuite;
import org.openmetadata.schema.tests.type.TestCaseStatus;
import org.openmetadata.schema.tests.type.TestSummary;
import org.openmetadata.schema.type.EntityReference;
import org.openmetadata.schema.type.EventType;
import org.openmetadata.schema.type.Include;
import org.openmetadata.schema.type.Relationship;
import org.openmetadata.service.Entity;
import org.openmetadata.service.jdbi3.EntityRepository;
import org.openmetadata.service.jdbi3.ListFilter;
import org.openmetadata.service.util.EntityUtil;
import org.openmetadata.service.util.FullyQualifiedName;
import org.openmetadata.service.util.JsonUtils;
import org.openmetadata.service.util.RestUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestSuiteRepository
extends EntityRepository<TestSuite> {
    private static final Logger LOG = LoggerFactory.getLogger(TestSuiteRepository.class);
    private static final String UPDATE_FIELDS = "tests";
    private static final String PATCH_FIELDS = "tests";

    public TestSuiteRepository() {
        super("/v1/dataQuality/testSuites", "testSuite", TestSuite.class, Entity.getCollectionDAO().testSuiteDAO(), "tests", "tests");
        this.quoteFqn = false;
        this.supportsSearch = true;
    }

    @Override
    public void setFields(TestSuite entity, EntityUtil.Fields fields) {
        entity.setPipelines(fields.contains("pipelines") ? this.getIngestionPipelines(entity) : entity.getPipelines());
        entity.setSummary(fields.contains("summary") ? this.getTestCasesExecutionSummary(entity) : entity.getSummary());
        entity.withTests(fields.contains("tests") ? this.getTestCases(entity) : entity.getTests());
    }

    @Override
    public void setInheritedFields(TestSuite testSuite, EntityUtil.Fields fields) {
        if (Boolean.TRUE.equals(testSuite.getExecutable())) {
            Table table = (Table)Entity.getEntity("table", testSuite.getExecutableEntityReference().getId(), "owner", Include.ALL);
            this.inheritOwner(testSuite, fields, (EntityInterface)table);
        }
    }

    @Override
    public void clearFields(TestSuite entity, EntityUtil.Fields fields) {
        entity.setPipelines(fields.contains("pipelines") ? entity.getPipelines() : null);
        entity.setSummary(fields.contains("summary") ? entity.getSummary() : null);
        entity.withTests(fields.contains("tests") ? entity.getTests() : null);
    }

    private TestSummary buildTestSummary(Map<String, Integer> testCaseSummary) {
        return new TestSummary().withAborted(testCaseSummary.getOrDefault(TestCaseStatus.Aborted.toString(), 0)).withFailed(testCaseSummary.getOrDefault(TestCaseStatus.Failed.toString(), 0)).withSuccess(testCaseSummary.getOrDefault(TestCaseStatus.Success.toString(), 0)).withQueued(testCaseSummary.getOrDefault(TestCaseStatus.Queued.toString(), 0)).withTotal(Integer.valueOf(testCaseSummary.values().stream().mapToInt(Integer::valueOf).sum()));
    }

    @Override
    public void setFullyQualifiedName(TestSuite testSuite) {
        if (testSuite.getExecutableEntityReference() != null) {
            testSuite.setFullyQualifiedName(FullyQualifiedName.add(testSuite.getExecutableEntityReference().getFullyQualifiedName(), "testSuite"));
        } else {
            testSuite.setFullyQualifiedName(FullyQualifiedName.quoteName(testSuite.getName()));
        }
    }

    private Map<String, Integer> getResultSummary(TestSuite testSuite) {
        HashMap<String, Integer> testCaseSummary = new HashMap<String, Integer>();
        List<EntityReference> testCases = this.getTestCases(testSuite);
        for (ResultSummary resultSummary : testSuite.getTestCaseResultSummary()) {
            String status = resultSummary.getStatus().toString();
            testCaseSummary.put(status, testCaseSummary.getOrDefault(status, 0) + 1);
        }
        List<EntityReference> testCasesWithNoResults = testCases.stream().filter(tc -> testSuite.getTestCaseResultSummary().stream().noneMatch(tcr -> tc.getFullyQualifiedName().equals(tcr.getTestCaseName()))).toList();
        testCaseSummary.put(TestCaseStatus.Queued.toString(), testCasesWithNoResults.size());
        return testCaseSummary;
    }

    private TestSummary getTestCasesExecutionSummary(TestSuite entity) {
        Map<String, Integer> testCaseSummary = this.getResultSummary(entity);
        return this.buildTestSummary(testCaseSummary);
    }

    private TestSummary getTestCasesExecutionSummary(List<TestSuite> entities) {
        if (entities.isEmpty()) {
            return new TestSummary();
        }
        HashMap<String, Integer> testsSummary = new HashMap<String, Integer>();
        for (TestSuite testSuite : entities) {
            Map<String, Integer> testSummary = this.getResultSummary(testSuite);
            for (Map.Entry<String, Integer> entry : testSummary.entrySet()) {
                testsSummary.put(entry.getKey(), testsSummary.getOrDefault(entry.getKey(), 0) + entry.getValue());
            }
            testSuite.getTestCaseResultSummary().size();
        }
        return this.buildTestSummary(testsSummary);
    }

    public TestSummary getTestSummary(UUID testSuiteId) {
        TestSummary testSummary;
        if (testSuiteId == null) {
            ListFilter filter = new ListFilter();
            filter.addQueryParam("testSuiteType", "executable");
            List<TestSuite> testSuites = this.listAll(EntityUtil.Fields.EMPTY_FIELDS, filter);
            testSummary = this.getTestCasesExecutionSummary(testSuites);
        } else {
            TestSuite testSuite = (TestSuite)Entity.getEntity("testSuite", testSuiteId, "", Include.ALL, false);
            testSummary = this.getTestCasesExecutionSummary(testSuite);
        }
        return testSummary;
    }

    @Override
    public void prepare(TestSuite entity, boolean update) {
    }

    private List<EntityReference> getTestCases(TestSuite entity) {
        return this.findTo(entity.getId(), "testSuite", Relationship.CONTAINS, "testCase");
    }

    @Override
    public EntityRepository.EntityUpdater getUpdater(TestSuite original, TestSuite updated, EntityRepository.Operation operation) {
        return new TestSuiteUpdater(original, updated, operation);
    }

    @Override
    public void storeEntity(TestSuite entity, boolean update) {
        this.store(entity, update);
    }

    @Override
    public void storeRelationships(TestSuite entity) {
        if (Boolean.TRUE.equals(entity.getExecutable())) {
            this.storeExecutableRelationship(entity);
        }
    }

    public void storeExecutableRelationship(TestSuite testSuite) {
        Table table = (Table)Entity.getEntityByName("table", testSuite.getExecutableEntityReference().getFullyQualifiedName(), null, null);
        this.addRelationship(table.getId(), testSuite.getId(), "table", "testSuite", Relationship.CONTAINS);
    }

    public RestUtil.DeleteResponse<TestSuite> deleteLogicalTestSuite(SecurityContext securityContext, TestSuite original, boolean hardDelete) {
        EventType changeType;
        String updatedBy = securityContext.getUserPrincipal().getName();
        this.preDelete(original, updatedBy);
        this.setFieldsInternal(original, this.putFields);
        TestSuite updated = JsonUtils.readValue(JsonUtils.pojoToJson(original), TestSuite.class);
        this.setFieldsInternal(updated, this.putFields);
        if (this.supportsSoftDelete && !hardDelete) {
            updated.setUpdatedBy(updatedBy);
            updated.setUpdatedAt(Long.valueOf(System.currentTimeMillis()));
            updated.setDeleted(Boolean.valueOf(true));
            EntityRepository.EntityUpdater updater = this.getUpdater(original, updated, EntityRepository.Operation.SOFT_DELETE);
            updater.update();
            changeType = EventType.ENTITY_SOFT_DELETED;
        } else {
            this.cleanup(updated);
            changeType = EventType.ENTITY_DELETED;
        }
        LOG.info("{} deleted {}", (Object)(hardDelete ? "Hard" : "Soft"), (Object)updated.getFullyQualifiedName());
        return new RestUtil.DeleteResponse<TestSuite>(updated, changeType);
    }

    public class TestSuiteUpdater
    extends EntityRepository.EntityUpdater {
        public TestSuiteUpdater(TestSuite original, TestSuite updated, EntityRepository.Operation operation) {
            super((EntityRepository)TestSuiteRepository.this, (EntityInterface)original, (EntityInterface)updated, operation);
        }

        @Override
        @Transaction
        public void entitySpecificUpdate() {
            List origTests = CommonUtil.listOrEmpty((List)((TestSuite)this.original).getTests());
            List updatedTests = CommonUtil.listOrEmpty((List)((TestSuite)this.updated).getTests());
            this.recordChange("tests", origTests, updatedTests);
        }
    }
}

