/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.resources.dqtests;

import io.swagger.v3.oas.annotations.ExternalDocumentation;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.ExampleObject;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.List;
import java.util.UUID;
import javax.json.JsonPatch;
import javax.validation.Valid;
import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.PATCH;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.SecurityContext;
import javax.ws.rs.core.UriInfo;
import org.openmetadata.schema.CreateEntity;
import org.openmetadata.schema.api.data.RestoreEntity;
import org.openmetadata.schema.api.tests.CreateTestSuite;
import org.openmetadata.schema.entity.data.Table;
import org.openmetadata.schema.tests.TestSuite;
import org.openmetadata.schema.tests.type.TestSummary;
import org.openmetadata.schema.type.EntityHistory;
import org.openmetadata.schema.type.EntityReference;
import org.openmetadata.schema.type.Include;
import org.openmetadata.schema.type.MetadataOperation;
import org.openmetadata.service.Entity;
import org.openmetadata.service.jdbi3.ListFilter;
import org.openmetadata.service.jdbi3.TestSuiteRepository;
import org.openmetadata.service.resources.Collection;
import org.openmetadata.service.resources.EntityResource;
import org.openmetadata.service.security.Authorizer;
import org.openmetadata.service.security.policyevaluator.OperationContext;
import org.openmetadata.service.security.policyevaluator.ResourceContext;
import org.openmetadata.service.util.EntityUtil;
import org.openmetadata.service.util.RestUtil;
import org.openmetadata.service.util.ResultList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/v1/dataQuality/testSuites")
@Tag(name="Test Suites", description="`TestSuite` is a set of test cases grouped together to capture data quality.")
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
@Collection(name="TestSuites")
public class TestSuiteResource
extends EntityResource<TestSuite, TestSuiteRepository> {
    private static final Logger LOG = LoggerFactory.getLogger(TestSuiteResource.class);
    public static final String COLLECTION_PATH = "/v1/dataQuality/testSuites";
    public static final String EXECUTABLE_TEST_SUITE_DELETION_ERROR = "Cannot delete logical test suite. To delete logical test suite, use DELETE /v1/dataQuality/testSuites/<...>";
    public static final String NON_EXECUTABLE_TEST_SUITE_DELETION_ERROR = "Cannot delete executable test suite. To delete executable test suite, use DELETE /v1/dataQuality/testSuites/executable/<...>";
    static final String FIELDS = "owner,tests,summary";

    public TestSuiteResource(Authorizer authorizer) {
        super("testSuite", authorizer);
    }

    @Override
    protected List<MetadataOperation> getEntitySpecificOperations() {
        this.addViewOperation("tests", MetadataOperation.VIEW_BASIC);
        return null;
    }

    @GET
    @Operation(operationId="listTestSuites", summary="List test suites", description="Get a list of test suites. Use `fields` parameter to get only necessary fields. Use cursor-based pagination to limit the number entries in the list using `limit` and `before` or `after` query params.", responses={@ApiResponse(responseCode="200", description="List of test definitions", content={@Content(mediaType="application/json", schema=@Schema(implementation=TestSuiteList.class))})})
    public ResultList<TestSuite> list(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Parameter(description="Fields requested in the returned resource", schema=@Schema(type="string", example="owner,tests,summary")) @QueryParam(value="fields") String fieldsParam, @Parameter(description="Limit the number test definitions returned. (1 to 1000000, default = 10)") @DefaultValue(value="10") @QueryParam(value="limit") @Min(value=0L) @Max(value=1000000L) @Min(value=0L) @Max(value=1000000L) int limitParam, @Parameter(description="Returns executable or logical test suites. If omitted, returns all test suites.", schema=@Schema(type="string", example="executable")) @QueryParam(value="testSuiteType") String testSuiteType, @Parameter(description="Include empty test suite in the response.", schema=@Schema(type="boolean", example="true")) @QueryParam(value="includeEmptyTestSuites") @DefaultValue(value="true") Boolean includeEmptyTestSuites, @Parameter(description="Returns list of test definitions before this cursor", schema=@Schema(type="string")) @QueryParam(value="before") String before, @Parameter(description="Returns list of test definitions after this cursor", schema=@Schema(type="string")) @QueryParam(value="after") String after, @Parameter(description="Include all, deleted, or non-deleted entities.", schema=@Schema(implementation=Include.class)) @QueryParam(value="include") @DefaultValue(value="non-deleted") Include include) {
        ListFilter filter = new ListFilter(include);
        filter.addQueryParam("testSuiteType", testSuiteType);
        filter.addQueryParam("includeEmptyTestSuites", includeEmptyTestSuites);
        EntityUtil.Fields fields = this.getFields(fieldsParam);
        ResourceContext resourceContext = this.getResourceContext();
        OperationContext operationContext = new OperationContext("table", MetadataOperation.VIEW_TESTS);
        return super.listInternal(uriInfo, securityContext, fields, filter, limitParam, before, after, operationContext, resourceContext);
    }

    @GET
    @Path(value="/{id}/versions")
    @Operation(operationId="listAllTestSuiteVersion", summary="List test suite versions", description="Get a list of all the versions of a test suite identified by `id`", responses={@ApiResponse(responseCode="200", description="List of test suite versions", content={@Content(mediaType="application/json", schema=@Schema(implementation=EntityHistory.class))})})
    public EntityHistory listVersions(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Parameter(description="Id of the test suite", schema=@Schema(type="UUID")) @PathParam(value="id") UUID id) {
        return super.listVersionsInternal(securityContext, id);
    }

    @GET
    @Path(value="/{id}")
    @Operation(summary="Get a test suite by Id", description="Get a Test Suite by `Id`.", responses={@ApiResponse(responseCode="200", description="The Test suite", content={@Content(mediaType="application/json", schema=@Schema(implementation=TestSuite.class))}), @ApiResponse(responseCode="404", description="Test Suite for instance {id} is not found")})
    public TestSuite get(@Context UriInfo uriInfo, @Parameter(description="Id of the test suite", schema=@Schema(type="UUID")) @PathParam(value="id") UUID id, @Context SecurityContext securityContext, @Parameter(description="Fields requested in the returned resource", schema=@Schema(type="string", example="owner,tests,summary")) @QueryParam(value="fields") String fieldsParam, @Parameter(description="Include all, deleted, or non-deleted entities.", schema=@Schema(implementation=Include.class)) @QueryParam(value="include") @DefaultValue(value="non-deleted") Include include) {
        return (TestSuite)this.getInternal(uriInfo, securityContext, id, fieldsParam, include);
    }

    @GET
    @Path(value="/name/{name}")
    @Operation(operationId="getTestSuiteByName", summary="Get a test suite by name", description="Get a test suite by  name.", responses={@ApiResponse(responseCode="200", description="The test suite", content={@Content(mediaType="application/json", schema=@Schema(implementation=TestSuite.class))}), @ApiResponse(responseCode="404", description="Test Suite for instance {name} is not found")})
    public TestSuite getByName(@Context UriInfo uriInfo, @Parameter(description="Name of the test suite", schema=@Schema(type="string")) @PathParam(value="name") String name, @Context SecurityContext securityContext, @Parameter(description="Fields requested in the returned resource", schema=@Schema(type="string", example="owner,tests,summary")) @QueryParam(value="fields") String fieldsParam, @Parameter(description="Include all, deleted, or non-deleted entities.", schema=@Schema(implementation=Include.class)) @QueryParam(value="include") @DefaultValue(value="non-deleted") Include include) {
        return (TestSuite)this.getByNameInternal(uriInfo, securityContext, name, fieldsParam, include);
    }

    @GET
    @Path(value="/{id}/versions/{version}")
    @Operation(operationId="getSpecificTestSuiteVersion", summary="Get a version of the test suite", description="Get a version of the test suite by given `id`", responses={@ApiResponse(responseCode="200", description="TestSuite", content={@Content(mediaType="application/json", schema=@Schema(implementation=TestSuite.class))}), @ApiResponse(responseCode="404", description="Test Suite for instance {id} and version {version} is not found")})
    public TestSuite getVersion(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Parameter(description="Id of the test suite", schema=@Schema(type="UUID")) @PathParam(value="id") UUID id, @Parameter(description="Test Suite version number in the form `major`.`minor`", schema=@Schema(type="string", example="0.1 or 1.1")) @PathParam(value="version") String version) {
        return (TestSuite)super.getVersionInternal(securityContext, id, version);
    }

    @GET
    @Path(value="/executionSummary")
    @Operation(operationId="getExecutionSummaryOfTestSuites", summary="Get the execution summary of test suites", description="Get the execution summary of test suites.", responses={@ApiResponse(responseCode="200", description="Tests Execution Summary", content={@Content(mediaType="application/json", schema=@Schema(implementation=TestSummary.class))})})
    public TestSummary getTestsExecutionSummary(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Parameter(description="get summary for a specific test suite", schema=@Schema(type="String", format="uuid")) @QueryParam(value="testSuiteId") UUID testSuiteId) {
        ResourceContext resourceContext = this.getResourceContext();
        OperationContext operationContext = new OperationContext("table", MetadataOperation.VIEW_TESTS);
        this.authorizer.authorize(securityContext, operationContext, resourceContext);
        return ((TestSuiteRepository)this.repository).getTestSummary(testSuiteId);
    }

    @Override
    @POST
    @Operation(operationId="createLogicalTestSuite", summary="Create a logical test suite", description="Create a logical test suite.", responses={@ApiResponse(responseCode="200", description="The test suite", content={@Content(mediaType="application/json", schema=@Schema(implementation=TestSuite.class))}), @ApiResponse(responseCode="400", description="Bad request")})
    public Response create(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Valid CreateTestSuite create) {
        create = create.withExecutableEntityReference(null);
        TestSuite testSuite = this.getTestSuite(create, securityContext.getUserPrincipal().getName());
        testSuite.setExecutable(Boolean.valueOf(false));
        return this.create(uriInfo, securityContext, testSuite);
    }

    @POST
    @Path(value="/executable")
    @Operation(operationId="createExecutableTestSuite", summary="Create an executable test suite", description="Create an executable test suite.", responses={@ApiResponse(responseCode="200", description="Executable test suite", content={@Content(mediaType="application/json", schema=@Schema(implementation=TestSuite.class))}), @ApiResponse(responseCode="400", description="Bad request")})
    public Response createExecutable(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Valid CreateTestSuite create) {
        TestSuite testSuite = this.getTestSuite(create, securityContext.getUserPrincipal().getName());
        testSuite.setExecutable(Boolean.valueOf(true));
        return this.create(uriInfo, securityContext, testSuite);
    }

    @PATCH
    @Path(value="/{id}")
    @Operation(operationId="patchTestSuite", summary="Update a test suite", description="Update an existing testSuite using JsonPatch.", externalDocs=@ExternalDocumentation(description="JsonPatch RFC", url="https://tools.ietf.org/html/rfc6902"))
    @Consumes(value={"application/json-patch+json"})
    public Response updateDescription(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Parameter(description="Id of the test suite", schema=@Schema(type="UUID")) @PathParam(value="id") UUID id, @RequestBody(description="JsonPatch with array of operations", content={@Content(mediaType="application/json-patch+json", examples={@ExampleObject(value="[{op:remove, path:/a},{op:add, path: /b, value: val}]")})}) JsonPatch patch) {
        return this.patchInternal(uriInfo, securityContext, id, patch);
    }

    @Override
    @PUT
    @Operation(operationId="createOrUpdateLogicalTestSuite", summary="Update logical test suite", description="Create a logical TestSuite, if it does not exist or update an existing test suite.", responses={@ApiResponse(responseCode="200", description="The updated test definition ", content={@Content(mediaType="application/json", schema=@Schema(implementation=TestSuite.class))})})
    public Response createOrUpdate(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Valid CreateTestSuite create) {
        create = create.withExecutableEntityReference(null);
        TestSuite testSuite = this.getTestSuite(create, securityContext.getUserPrincipal().getName());
        testSuite.setExecutable(Boolean.valueOf(false));
        return this.createOrUpdate(uriInfo, securityContext, testSuite);
    }

    @PUT
    @Path(value="/executable")
    @Operation(operationId="createOrUpdateExecutableTestSuite", summary="Create or Update Executable test suite", description="Create an Executable TestSuite if it does not exist or update an existing one.", responses={@ApiResponse(responseCode="200", description="The updated test definition ", content={@Content(mediaType="application/json", schema=@Schema(implementation=TestSuite.class))})})
    public Response createOrUpdateExecutable(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Valid CreateTestSuite create) {
        TestSuite testSuite = this.getTestSuite(create, securityContext.getUserPrincipal().getName());
        testSuite.setExecutable(Boolean.valueOf(true));
        return this.createOrUpdate(uriInfo, securityContext, testSuite);
    }

    @DELETE
    @Path(value="/{id}")
    @Operation(operationId="deleteLogicalTestSuite", summary="Delete a logical test suite", description="Delete a logical test suite by `id`.", responses={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="404", description="Logical test suite for instance {id} is not found")})
    public Response delete(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Parameter(description="Hard delete the logical entity. (Default = `false`)") @QueryParam(value="hardDelete") @DefaultValue(value="false") boolean hardDelete, @Parameter(description="Id of the logical test suite", schema=@Schema(type="UUID")) @PathParam(value="id") UUID id) {
        OperationContext operationContext = new OperationContext(this.entityType, MetadataOperation.DELETE);
        this.authorizer.authorize(securityContext, operationContext, this.getResourceContextById(id));
        TestSuite testSuite = (TestSuite)Entity.getEntity("testSuite", id, "*", Include.ALL);
        if (Boolean.TRUE.equals(testSuite.getExecutable())) {
            throw new IllegalArgumentException(NON_EXECUTABLE_TEST_SUITE_DELETION_ERROR);
        }
        RestUtil.DeleteResponse<TestSuite> response = ((TestSuiteRepository)this.repository).deleteLogicalTestSuite(securityContext, testSuite, hardDelete);
        ((TestSuiteRepository)this.repository).deleteFromSearch(response.entity(), response.changeType());
        this.addHref(uriInfo, response.entity());
        return response.toResponse();
    }

    @DELETE
    @Path(value="/name/{name}")
    @Operation(operationId="deleteLogicalTestSuite", summary="Delete a logical test suite", description="Delete a logical test suite by `name`.", responses={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="404", description="Logical Test suite for instance {name} is not found")})
    public Response delete(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Parameter(description="Hard delete the logical entity. (Default = `false`)") @QueryParam(value="hardDelete") @DefaultValue(value="false") boolean hardDelete, @Parameter(description="FQN of the logical test suite", schema=@Schema(type="String")) @PathParam(value="name") String name) {
        OperationContext operationContext = new OperationContext(this.entityType, MetadataOperation.DELETE);
        this.authorizer.authorize(securityContext, operationContext, this.getResourceContextByName(name));
        TestSuite testSuite = (TestSuite)Entity.getEntityByName("testSuite", name, "*", Include.ALL);
        if (Boolean.TRUE.equals(testSuite.getExecutable())) {
            throw new IllegalArgumentException(NON_EXECUTABLE_TEST_SUITE_DELETION_ERROR);
        }
        RestUtil.DeleteResponse<TestSuite> response = ((TestSuiteRepository)this.repository).deleteLogicalTestSuite(securityContext, testSuite, hardDelete);
        this.addHref(uriInfo, response.entity());
        return response.toResponse();
    }

    @DELETE
    @Path(value="/executable/name/{name}")
    @Operation(operationId="deleteTestSuiteByName", summary="Delete a test suite", description="Delete a test suite by `name`.", responses={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="404", description="Test suite for instance {name} is not found")})
    public Response deleteExecutable(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Parameter(description="Recursively delete this entity and it's children. (Default `false`)") @DefaultValue(value="false") @QueryParam(value="recursive") boolean recursive, @Parameter(description="Hard delete the entity. (Default = `false`)") @QueryParam(value="hardDelete") @DefaultValue(value="false") boolean hardDelete, @Parameter(description="Name of the test suite", schema=@Schema(type="string")) @PathParam(value="name") String name) {
        OperationContext operationContext = new OperationContext(this.entityType, MetadataOperation.DELETE);
        this.authorizer.authorize(securityContext, operationContext, this.getResourceContextByName(name));
        TestSuite testSuite = (TestSuite)Entity.getEntityByName("testSuite", name, "*", Include.ALL);
        if (Boolean.FALSE.equals(testSuite.getExecutable())) {
            throw new IllegalArgumentException(EXECUTABLE_TEST_SUITE_DELETION_ERROR);
        }
        RestUtil.DeleteResponse response = ((TestSuiteRepository)this.repository).deleteByName(securityContext.getUserPrincipal().getName(), name, recursive, hardDelete);
        this.addHref(uriInfo, (TestSuite)response.entity());
        return response.toResponse();
    }

    @DELETE
    @Path(value="/executable/{id}")
    @Operation(operationId="deleteTestSuite", summary="Delete a test suite", description="Delete a test suite by `Id`.", responses={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="404", description="Test suite for instance {id} is not found")})
    public Response deleteExecutable(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Parameter(description="Recursively delete this entity and it's children. (Default `false`)") @DefaultValue(value="false") @QueryParam(value="recursive") boolean recursive, @Parameter(description="Hard delete the entity. (Default = `false`)") @QueryParam(value="hardDelete") @DefaultValue(value="false") boolean hardDelete, @Parameter(description="Id of the test suite", schema=@Schema(type="UUID")) @PathParam(value="id") UUID id) {
        OperationContext operationContext = new OperationContext(this.entityType, MetadataOperation.DELETE);
        this.authorizer.authorize(securityContext, operationContext, this.getResourceContextById(id));
        TestSuite testSuite = (TestSuite)Entity.getEntity("testSuite", id, "*", Include.ALL);
        if (Boolean.FALSE.equals(testSuite.getExecutable())) {
            throw new IllegalArgumentException(EXECUTABLE_TEST_SUITE_DELETION_ERROR);
        }
        RestUtil.DeleteResponse<UUID> response = ((TestSuiteRepository)this.repository).delete(securityContext.getUserPrincipal().getName(), id, recursive, hardDelete);
        this.addHref(uriInfo, (TestSuite)response.entity());
        return response.toResponse();
    }

    @PUT
    @Path(value="/restore")
    @Operation(operationId="restore", summary="Restore a soft deleted test suite", description="Restore a soft deleted test suite.", responses={@ApiResponse(responseCode="200", description="Successfully restored the TestSuite.", content={@Content(mediaType="application/json", schema=@Schema(implementation=TestSuite.class))})})
    public Response restoreTestSuite(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Valid RestoreEntity restore) {
        return this.restoreEntity(uriInfo, securityContext, restore.getId());
    }

    private TestSuite getTestSuite(CreateTestSuite create, String user) {
        TestSuite testSuite = ((TestSuiteRepository)this.repository).copy(new TestSuite(), (CreateEntity)create, user).withDescription(create.getDescription()).withDisplayName(create.getDisplayName()).withName(create.getName());
        if (create.getExecutableEntityReference() != null) {
            Table table = (Table)Entity.getEntityByName("table", create.getExecutableEntityReference(), null, null);
            EntityReference entityReference = new EntityReference().withId(table.getId()).withFullyQualifiedName(table.getFullyQualifiedName()).withName(table.getName()).withType("table");
            testSuite.setExecutableEntityReference(entityReference);
        }
        return testSuite;
    }

    public static class TestSuiteList
    extends ResultList<TestSuite> {
    }
}

