/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.search.indexes;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.openmetadata.schema.tests.TestCase;
import org.openmetadata.schema.tests.TestSuite;
import org.openmetadata.schema.type.EntityReference;
import org.openmetadata.schema.type.Include;
import org.openmetadata.service.Entity;
import org.openmetadata.service.search.SearchIndexUtils;
import org.openmetadata.service.search.indexes.SearchIndex;
import org.openmetadata.service.search.models.SearchSuggest;
import org.openmetadata.service.util.JsonUtils;

public record TestCaseIndex(TestCase testCase) implements SearchIndex
{
    private static final List<String> excludeFields = List.of("changeDescription");

    @Override
    public Map<String, Object> buildESDoc() {
        ArrayList<TestSuite> testSuiteArray = new ArrayList<TestSuite>();
        if (this.testCase.getTestSuites() != null) {
            for (TestSuite suite : this.testCase.getTestSuites()) {
                suite.setChangeDescription(null);
                testSuiteArray.add(suite);
            }
        }
        this.testCase.setTestSuites(testSuiteArray);
        Map<String, Object> doc = JsonUtils.getMap(this.testCase);
        SearchIndexUtils.removeNonIndexableFields(doc, excludeFields);
        ArrayList<SearchSuggest> suggest = new ArrayList<SearchSuggest>();
        suggest.add(SearchSuggest.builder().input(this.testCase.getFullyQualifiedName()).weight(5).build());
        suggest.add(SearchSuggest.builder().input(this.testCase.getName()).weight(10).build());
        doc.put("fqnParts", this.getFQNParts(this.testCase.getFullyQualifiedName(), suggest.stream().map(SearchSuggest::getInput).toList()));
        doc.put("suggest", suggest);
        doc.put("entityType", "testCase");
        doc.put("owner", this.getEntityWithDisplayName(this.testCase.getOwner()));
        return doc;
    }

    public Map<String, Object> buildESDocForCreate() {
        EntityReference testSuiteEntityReference = this.testCase.getTestSuite();
        TestSuite testSuite = this.getTestSuite(testSuiteEntityReference.getId());
        ArrayList<TestSuite> testSuiteArray = new ArrayList<TestSuite>();
        testSuiteArray.add(testSuite);
        Map<String, Object> doc = JsonUtils.getMap(this.testCase);
        SearchIndexUtils.removeNonIndexableFields(doc, excludeFields);
        doc.put("testSuites", testSuiteArray);
        return doc;
    }

    private TestSuite getTestSuite(UUID testSuiteId) {
        TestSuite testSuite = (TestSuite)Entity.getEntity("testSuite", testSuiteId, "", Include.ALL);
        return new TestSuite().withId(testSuite.getId()).withName(testSuite.getName()).withDisplayName(testSuite.getDisplayName()).withDescription(testSuite.getDescription()).withFullyQualifiedName(testSuite.getFullyQualifiedName()).withDeleted(testSuite.getDeleted()).withHref(testSuite.getHref()).withExecutable(testSuite.getExecutable()).withChangeDescription(null);
    }

    public static Map<String, Float> getFields() {
        Map<String, Float> fields = SearchIndex.getDefaultFields();
        fields.put("testSuite.fullyQualifiedName", Float.valueOf(10.0f));
        fields.put("testSuite.name", Float.valueOf(10.0f));
        fields.put("testSuite.description", Float.valueOf(1.0f));
        fields.put("entityLink", Float.valueOf(3.0f));
        fields.put("entityFQN", Float.valueOf(10.0f));
        return fields;
    }
}

