/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.search.opensearch;

import java.util.Map;
import org.glassfish.jersey.internal.util.ExceptionUtils;
import org.openmetadata.schema.system.IndexingError;
import org.openmetadata.schema.system.StepStats;
import org.openmetadata.service.exception.SearchIndexException;
import org.openmetadata.service.search.SearchRepository;
import org.openmetadata.service.util.JsonUtils;
import org.openmetadata.service.workflows.interfaces.Sink;
import org.openmetadata.service.workflows.searchIndex.ReindexingUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import os.org.opensearch.action.bulk.BulkRequest;
import os.org.opensearch.action.bulk.BulkResponse;
import os.org.opensearch.client.RequestOptions;

public class OpenSearchIndexSink
implements Sink<BulkRequest, BulkResponse> {
    private static final Logger LOG = LoggerFactory.getLogger(OpenSearchIndexSink.class);
    private final StepStats stats = new StepStats();
    private final SearchRepository searchRepository;

    public OpenSearchIndexSink(SearchRepository repository, int total) {
        this.searchRepository = repository;
        this.stats.withTotalRecords(Integer.valueOf(total)).withSuccessRecords(Integer.valueOf(0)).withFailedRecords(Integer.valueOf(0));
    }

    @Override
    public BulkResponse write(BulkRequest data, Map<String, Object> contextData) throws SearchIndexException {
        LOG.debug("[EsSearchIndexSink] Processing a Batch of Size: {}", (Object)data.numberOfActions());
        try {
            BulkResponse response = this.searchRepository.getSearchClient().bulk(data, RequestOptions.DEFAULT);
            int currentSuccess = ReindexingUtil.getSuccessFromBulkResponse(response);
            int currentFailed = response.getItems().length - currentSuccess;
            if (currentFailed != 0) {
                throw new SearchIndexException(new IndexingError().withErrorSource(IndexingError.ErrorSource.SINK).withSubmittedCount(Integer.valueOf(data.numberOfActions())).withSuccessCount(Integer.valueOf(currentSuccess)).withFailedCount(Integer.valueOf(currentFailed)).withMessage("Issues in Sink To Elastic Search.").withFailedEntities(ReindexingUtil.getErrorsFromBulkResponse(response)));
            }
            LOG.debug("[EsSearchIndexSink] Batch Stats :- Submitted : {} Success: {} Failed: {}", new Object[]{data.numberOfActions(), currentSuccess, currentFailed});
            this.updateStats(currentSuccess, currentFailed);
            return response;
        }
        catch (SearchIndexException ex) {
            this.updateStats(ex.getIndexingError().getSuccessCount(), ex.getIndexingError().getFailedCount());
            throw ex;
        }
        catch (Exception e) {
            IndexingError indexingError = new IndexingError().withErrorSource(IndexingError.ErrorSource.SINK).withSubmittedCount(Integer.valueOf(data.numberOfActions())).withSuccessCount(Integer.valueOf(0)).withFailedCount(Integer.valueOf(data.numberOfActions())).withMessage("Issue in Sink to Elastic Search.").withStackTrace(ExceptionUtils.exceptionStackTraceAsString((Throwable)e));
            LOG.debug("[OsSearchIndexSink] Failed, Details : {}", (Object)JsonUtils.pojoToJson(indexingError));
            this.updateStats(0, data.numberOfActions());
            throw new SearchIndexException(indexingError);
        }
    }

    @Override
    public void updateStats(int currentSuccess, int currentFailed) {
        ReindexingUtil.getUpdatedStats(this.stats, currentSuccess, currentFailed);
    }

    @Override
    public StepStats getStats() {
        return this.stats;
    }
}

