/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.secrets;

import com.google.common.annotations.VisibleForTesting;
import org.openmetadata.schema.security.secrets.SecretsManagerConfiguration;
import org.openmetadata.schema.security.secrets.SecretsManagerProvider;
import org.openmetadata.service.secrets.AWSSSMSecretsManager;
import org.openmetadata.service.secrets.AWSSecretsManager;
import org.openmetadata.service.secrets.DBSecretsManager;
import org.openmetadata.service.secrets.InMemorySecretsManager;
import org.openmetadata.service.secrets.SecretsManager;

public class SecretsManagerFactory {
    private static SecretsManager secretsManager;

    private SecretsManagerFactory() {
    }

    public static SecretsManager createSecretsManager(SecretsManagerConfiguration config, String clusterName) {
        if (secretsManager != null) {
            return secretsManager;
        }
        SecretsManager.SecretsConfig secretsConfig = new SecretsManager.SecretsConfig(clusterName, config.getPrefix(), config.getTags(), config.getParameters());
        SecretsManagerProvider secretsManagerProvider = config.getSecretsManager() != null ? config.getSecretsManager() : SecretsManagerProvider.DB;
        switch (secretsManagerProvider) {
            case DB: 
            case AWS_SSM: 
            case AWS: {
                secretsManager = DBSecretsManager.getInstance(secretsConfig);
                break;
            }
            case MANAGED_AWS: {
                secretsManager = AWSSecretsManager.getInstance(secretsConfig);
                break;
            }
            case MANAGED_AWS_SSM: {
                secretsManager = AWSSSMSecretsManager.getInstance(secretsConfig);
                break;
            }
            case IN_MEMORY: {
                secretsManager = InMemorySecretsManager.getInstance(secretsConfig);
            }
        }
        return secretsManager;
    }

    @VisibleForTesting
    public static void setSecretsManager(SecretsManager secretsManager) {
        SecretsManagerFactory.secretsManager = secretsManager;
    }

    public static SecretsManager getSecretsManager() {
        return secretsManager;
    }
}

