/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.util;

import freemarker.template.TemplateException;
import java.io.IOException;
import java.time.Instant;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.ws.rs.container.ContainerResponseContext;
import javax.ws.rs.core.Response;
import org.openmetadata.schema.entity.feed.Thread;
import org.openmetadata.schema.entity.teams.Team;
import org.openmetadata.schema.entity.teams.User;
import org.openmetadata.schema.type.AnnouncementDetails;
import org.openmetadata.schema.type.Post;
import org.openmetadata.schema.type.Relationship;
import org.openmetadata.service.Entity;
import org.openmetadata.service.jdbi3.CollectionDAO;
import org.openmetadata.service.jdbi3.UserRepository;
import org.openmetadata.service.resources.feeds.MessageParser;
import org.openmetadata.service.socket.WebSocketManager;
import org.openmetadata.service.util.EmailUtil;
import org.openmetadata.service.util.JsonUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NotificationHandler {
    private static final Logger LOG = LoggerFactory.getLogger(NotificationHandler.class);
    private final ExecutorService threadScheduler = Executors.newFixedThreadPool(1);

    private void handleNotifications(ContainerResponseContext responseContext) {
        int responseCode = responseContext.getStatus();
        if (responseCode == Response.Status.CREATED.getStatusCode() && responseContext.getEntity() != null && responseContext.getEntity().getClass().equals(Thread.class)) {
            Thread thread = (Thread)responseContext.getEntity();
        }
    }

    public static void handleTaskNotification(Thread thread) {
        String jsonThread = JsonUtils.pojoToJson(thread);
        if (thread.getPostsCount() == 0) {
            Set<UUID> receiversList = NotificationHandler.getTaskAssignees(thread);
            WebSocketManager.getInstance().sendToManyWithUUID(receiversList, "taskChannel", jsonThread);
            NotificationHandler.handleEmailNotifications(receiversList, thread);
        }
    }

    public static Set<UUID> getTaskAssignees(Thread thread) {
        List assignees = thread.getTask().getAssignees();
        HashSet<UUID> receiversList = new HashSet<UUID>();
        assignees.forEach(e -> {
            if ("user".equals(e.getType())) {
                receiversList.add(e.getId());
            } else if ("team".equals(e.getType())) {
                List<CollectionDAO.EntityRelationshipRecord> records = Entity.getCollectionDAO().relationshipDAO().findTo(e.getId(), "team", Relationship.HAS.ordinal(), "user");
                records.forEach(eRecord -> receiversList.add(eRecord.getId()));
            }
        });
        return receiversList;
    }

    private void handleAnnouncementNotification(Thread thread) {
        String jsonThread = JsonUtils.pojoToJson(thread);
        AnnouncementDetails announcementDetails = thread.getAnnouncement();
        Long currentTimestamp = Instant.now().getEpochSecond();
        if (announcementDetails.getStartTime() <= currentTimestamp && currentTimestamp <= announcementDetails.getEndTime()) {
            WebSocketManager.getInstance().broadCastMessageToAll("announcementChannel", jsonThread);
        }
    }

    public static void handleConversationNotification(Thread thread) {
        List<MessageParser.EntityLink> mentions;
        String jsonThread = JsonUtils.pojoToJson(thread);
        WebSocketManager.getInstance().broadCastMessageToAll("activityFeed", jsonThread);
        if (thread.getPostsCount() == 0) {
            mentions = MessageParser.getEntityLinks(thread.getMessage());
        } else {
            Post latestPost = (Post)thread.getPosts().get(thread.getPostsCount() - 1);
            mentions = MessageParser.getEntityLinks(latestPost.getMessage());
        }
        mentions.forEach(entityLink -> {
            String fqn = entityLink.getEntityFQN();
            if ("user".equals(entityLink.getEntityType())) {
                User user = (User)Entity.getCollectionDAO().userDAO().findEntityByName(fqn);
                WebSocketManager.getInstance().sendToOne(user.getId(), "mentionChannel", jsonThread);
            } else if ("team".equals(entityLink.getEntityType())) {
                Team team = (Team)Entity.getCollectionDAO().teamDAO().findEntityByName(fqn);
                List<CollectionDAO.EntityRelationshipRecord> records = Entity.getCollectionDAO().relationshipDAO().findTo(team.getId(), "team", Relationship.HAS.ordinal(), "user");
                WebSocketManager.getInstance().sendToManyWithString(records, "mentionChannel", jsonThread);
            }
        });
    }

    public static void handleEmailNotifications(Set<UUID> userList, Thread thread) {
        UserRepository repository = (UserRepository)Entity.getEntityRepository("user");
        userList.forEach(id -> {
            try {
                User user = (User)repository.get(null, (UUID)id, repository.getFields("name,email,href"));
                EmailUtil.sendTaskAssignmentNotificationToUser(user.getName(), user.getEmail(), String.format("%s/users/%s/tasks", EmailUtil.getSmtpSettings().getOpenMetadataUrl(), user.getName()), thread, EmailUtil.getTaskAssignmentSubject(), "taskAssignment.ftl");
            }
            catch (IOException ex) {
                LOG.error("Task Email Notification Failed :", (Throwable)ex);
            }
            catch (TemplateException ex) {
                LOG.error("Task Email Notification Template Parsing Exception :", (Throwable)ex);
            }
        });
    }
}

