/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.apps.bundles.changeEvent;

import java.util.UUID;
import org.openmetadata.schema.type.ChangeEvent;
import org.openmetadata.service.apps.bundles.changeEvent.AbstractEventConsumer;
import org.openmetadata.service.apps.bundles.changeEvent.Destination;
import org.openmetadata.service.events.errors.EventPublisherException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AlertPublisher
extends AbstractEventConsumer {
    private static final Logger LOG = LoggerFactory.getLogger(AlertPublisher.class);

    @Override
    public void sendAlert(UUID receiverId, ChangeEvent event) throws EventPublisherException {
        if (this.destinationMap.containsKey(receiverId)) {
            Destination destination = (Destination)this.destinationMap.get(receiverId);
            if (Boolean.TRUE.equals(destination.getEnabled())) {
                destination.sendMessage(event);
            } else {
                LOG.debug("Event Subscription:{} Skipping sending message since, disabled subscription with Id: {}", (Object)this.eventSubscription.getName(), (Object)receiverId);
            }
        } else {
            LOG.debug("Event Subscription:{} Cannot find Destination Subscription With Id: {}", (Object)this.eventSubscription.getName(), (Object)receiverId);
        }
    }

    @Override
    public boolean getEnabled() {
        return this.getEventSubscription().getEnabled();
    }
}

