/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.config;

import io.dropwizard.Configuration;
import io.dropwizard.ConfiguredBundle;
import io.dropwizard.setup.Bootstrap;
import io.dropwizard.setup.Environment;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.DispatcherType;
import javax.servlet.FilterRegistration;
import org.eclipse.jetty.servlets.HeaderFilter;
import org.openmetadata.service.config.OMWebConfiguration;

public abstract class OMWebBundle<T extends Configuration>
implements ConfiguredBundle<T> {
    protected OMWebBundle() {
    }

    public void initialize(Bootstrap<?> bootstrap) {
    }

    public void run(T configuration, Environment environment) {
        OMWebConfiguration webConfig = this.getWebConfiguration(configuration);
        String urlPattern = this.deriveUrlPattern(webConfig.getUriPath());
        HashMap<String, String> headers = new HashMap<String, String>();
        if (webConfig.getHstsHeaderFactory() != null) {
            headers.putAll(webConfig.getHstsHeaderFactory().build());
        }
        headers.putAll(webConfig.getFrameOptionsHeaderFactory().build());
        headers.putAll(webConfig.getContentTypeOptionsHeaderFactory().build());
        headers.putAll(webConfig.getXssProtectionHeaderFactory().build());
        if (webConfig.getCspHeaderFactory() != null) {
            headers.putAll(webConfig.getCspHeaderFactory().build());
        }
        if (webConfig.getReferrerPolicyHeaderFactory() != null) {
            headers.putAll(webConfig.getReferrerPolicyHeaderFactory().build());
        }
        if (webConfig.getPermissionPolicyHeaderFactory() != null) {
            headers.putAll(webConfig.getPermissionPolicyHeaderFactory().build());
        }
        headers.putAll(webConfig.getHeaders());
        this.configureHeaderFilter(environment, webConfig.getUriPath(), urlPattern, headers);
        if (webConfig.getCorsFilterFactory() != null) {
            webConfig.getCorsFilterFactory().build(environment, urlPattern);
        }
    }

    protected void configureHeaderFilter(Environment environment, String uriPath, String urlPattern, Map<String, String> headers) {
        String headerConfig = headers.entrySet().stream().map(entry -> "set " + (String)entry.getKey() + ": " + (String)entry.getValue()).collect(Collectors.joining(","));
        Map<String, String> filterConfig = Collections.singletonMap("headerConfig", headerConfig);
        FilterRegistration.Dynamic filter = environment.servlets().addFilter("header-filter-" + uriPath, HeaderFilter.class);
        filter.addMappingForUrlPatterns(EnumSet.of(DispatcherType.REQUEST), true, new String[]{urlPattern});
        filter.setInitParameters(filterConfig);
    }

    private String deriveUrlPattern(String uri) {
        return uri.endsWith("/") ? uri + "*" : uri + "/*";
    }

    public abstract OMWebConfiguration getWebConfiguration(T var1);
}

