/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.dataInsight;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;
import org.openmetadata.schema.dataInsight.type.TotalEntitiesByType;
import org.openmetadata.service.dataInsight.DataInsightAggregatorInterface;

public abstract class TotalEntitiesAggregator<A, B, M, S>
implements DataInsightAggregatorInterface {
    private final A aggregations;

    protected TotalEntitiesAggregator(A aggregations) {
        this.aggregations = aggregations;
    }

    @Override
    public List<Object> aggregate() throws ParseException {
        M timestampBuckets = this.getTimestampBuckets(this.aggregations);
        ArrayList<Object> data = new ArrayList<Object>();
        ArrayList<Double> entityCount = new ArrayList<Double>();
        for (B timestampBucket : this.getBuckets(timestampBuckets)) {
            String dateTimeString = this.getKeyAsString(timestampBucket);
            Long l = this.convertDatTimeStringToTimestamp(dateTimeString);
            M entityTypeBuckets = this.getEntityBuckets(timestampBucket);
            for (B entityTypeBucket : this.getBuckets(entityTypeBuckets)) {
                String entityType = this.getKeyAsString(entityTypeBucket);
                S sumEntityCount = this.getSumAggregations(entityTypeBucket, "entityCount");
                data.add(new TotalEntitiesByType().withTimestamp(l).withEntityType(entityType).withEntityCount(this.getValue(sumEntityCount)));
                entityCount.add(this.getValue(sumEntityCount));
            }
        }
        double totalEntities = entityCount.stream().mapToDouble(v -> v).sum();
        for (Object e : data) {
            TotalEntitiesByType totalEntitiesByType = (TotalEntitiesByType)e;
            totalEntitiesByType.withEntityCountFraction(Double.valueOf(totalEntitiesByType.getEntityCount() / totalEntities));
        }
        return data;
    }

    protected abstract Double getValue(S var1);

    protected abstract S getSumAggregations(B var1, String var2);

    protected abstract M getEntityBuckets(B var1);

    protected abstract String getKeyAsString(B var1);

    protected abstract List<? extends B> getBuckets(M var1);

    protected abstract M getTimestampBuckets(A var1);
}

