/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.events;

import java.util.UUID;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerResponseContext;
import org.openmetadata.schema.EntityInterface;
import org.openmetadata.schema.EntityTimeSeriesInterface;
import org.openmetadata.schema.entity.feed.Thread;
import org.openmetadata.schema.type.AuditLog;
import org.openmetadata.schema.type.ChangeEvent;
import org.openmetadata.service.OpenMetadataApplicationConfig;
import org.openmetadata.service.events.EventHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.Marker;
import org.slf4j.MarkerFactory;

public class AuditEventHandler
implements EventHandler {
    private static final Logger LOG = LoggerFactory.getLogger(AuditEventHandler.class);
    private final Marker auditMarker = MarkerFactory.getMarker((String)"AUDIT");

    @Override
    public void init(OpenMetadataApplicationConfig config) {
    }

    @Override
    public Void process(ContainerRequestContext requestContext, ContainerResponseContext responseContext) {
        int responseCode = responseContext.getStatus();
        String method = requestContext.getMethod();
        if (responseContext.getEntity() != null) {
            String path = requestContext.getUriInfo().getPath();
            String username = "anonymous";
            if (requestContext.getSecurityContext().getUserPrincipal() != null) {
                username = requestContext.getSecurityContext().getUserPrincipal().getName();
            }
            try {
                UUID entityId = null;
                String entityType = "";
                Object object = responseContext.getEntity();
                if (object instanceof EntityTimeSeriesInterface) {
                    EntityTimeSeriesInterface entityTimeSeriesInterface = (EntityTimeSeriesInterface)object;
                    entityId = entityTimeSeriesInterface.getEntityReference().getId();
                    entityType = entityTimeSeriesInterface.getEntityReference().getType();
                } else {
                    object = responseContext.getEntity();
                    if (object instanceof EntityInterface) {
                        EntityInterface entityInterface = (EntityInterface)object;
                        entityId = entityInterface.getEntityReference().getId();
                        entityType = entityInterface.getEntityReference().getType();
                    } else {
                        object = responseContext.getEntity();
                        if (object instanceof ChangeEvent) {
                            ChangeEvent changeEvent = (ChangeEvent)object;
                            entityId = changeEvent.getId();
                            entityType = "CHANGE_EVENT";
                        } else {
                            object = responseContext.getEntity();
                            if (object instanceof Thread) {
                                Thread thread = (Thread)object;
                                entityId = thread.getId();
                                entityType = "THREAD";
                            } else {
                                return null;
                            }
                        }
                    }
                }
                AuditLog auditLog = new AuditLog().withPath(path).withTimestamp(Long.valueOf(System.currentTimeMillis())).withEntityId(entityId).withEntityType(entityType).withMethod(AuditLog.Method.fromValue((String)method)).withUserName(username).withResponseCode(Integer.valueOf(responseCode));
                LOG.info(this.auditMarker, String.format("Added audit log entry: %s", auditLog));
            }
            catch (Exception e) {
                LOG.error(this.auditMarker, String.format("Failed to capture audit log for %s and method %s due to %s", path, method, e.getMessage()));
            }
        }
        return null;
    }

    @Override
    public void close() {
    }
}

