/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.events.subscription;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.util.concurrent.UncheckedExecutionException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import javax.annotation.CheckForNull;
import lombok.NonNull;
import org.openmetadata.schema.entity.events.EventSubscription;
import org.openmetadata.schema.type.Include;
import org.openmetadata.service.Entity;
import org.openmetadata.service.exception.EntityNotFoundException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ActivityFeedAlertCache {
    private static final Logger LOG = LoggerFactory.getLogger(ActivityFeedAlertCache.class);
    protected static final LoadingCache<String, EventSubscription> EVENT_SUB_CACHE = CacheBuilder.newBuilder().maximumSize(1000L).expireAfterWrite(3L, TimeUnit.MINUTES).build((CacheLoader)new ActivityFeedAlertLoader());
    private static final String ACTIVITY_FEED_ALERT = "ActivityFeedAlert";

    private ActivityFeedAlertCache() {
    }

    public static EventSubscription getActivityFeedAlert() {
        try {
            return (EventSubscription)EVENT_SUB_CACHE.get((Object)ACTIVITY_FEED_ALERT);
        }
        catch (UncheckedExecutionException | ExecutionException ex) {
            throw new EntityNotFoundException(ex.getMessage());
        }
    }

    static class ActivityFeedAlertLoader
    extends CacheLoader<String, EventSubscription> {
        ActivityFeedAlertLoader() {
        }

        @NonNull
        public EventSubscription load(@CheckForNull String alertName) {
            EventSubscription alert = (EventSubscription)Entity.getEntityByName("eventsubscription", alertName, "*", Include.NON_DELETED);
            LOG.debug("Loaded Alert {}", (Object)alert);
            return alert;
        }
    }
}

