/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.formatter.factory;

import org.openmetadata.service.formatter.decorators.MessageDecorator;
import org.openmetadata.service.formatter.entity.DefaultEntityFormatter;
import org.openmetadata.service.formatter.entity.EntityFormatter;
import org.openmetadata.service.formatter.entity.IngestionPipelineFormatter;
import org.openmetadata.service.formatter.entity.KpiFormatter;
import org.openmetadata.service.formatter.entity.PipelineFormatter;
import org.openmetadata.service.formatter.entity.QueryFormatter;
import org.openmetadata.service.formatter.entity.TestCaseFormatter;
import org.openmetadata.service.formatter.field.DefaultFieldFormatter;
import org.openmetadata.service.formatter.field.FollowersFormatter;
import org.openmetadata.service.formatter.field.OwnerFormatter;
import org.openmetadata.service.formatter.field.TagFormatter;
import org.openmetadata.service.resources.feeds.MessageParser;

public final class ParserFactory {
    private ParserFactory() {
    }

    public static EntityFormatter getEntityParser(String entityType) {
        return switch (entityType) {
            case "query" -> new QueryFormatter();
            case "testCase" -> new TestCaseFormatter();
            case "kpi" -> new KpiFormatter();
            case "ingestionPipeline" -> new IngestionPipelineFormatter();
            case "pipeline" -> new PipelineFormatter();
            default -> new DefaultEntityFormatter();
        };
    }

    public static DefaultFieldFormatter getFieldParserObject(MessageDecorator<?> decorator, String fieldOldValue, String fieldNewValue, String fieldChangeName, MessageParser.EntityLink entityLink) {
        return switch (fieldChangeName) {
            case "tags" -> new TagFormatter(decorator, fieldOldValue, fieldNewValue, fieldChangeName, entityLink);
            case "followers" -> new FollowersFormatter(decorator, fieldOldValue, fieldNewValue, fieldChangeName, entityLink);
            case "owner" -> new OwnerFormatter(decorator, fieldOldValue, fieldNewValue, fieldChangeName, entityLink);
            default -> new DefaultFieldFormatter(decorator, fieldOldValue, fieldNewValue, fieldChangeName, entityLink);
        };
    }
}

