/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.formatter.field;

import org.openmetadata.service.formatter.decorators.MessageDecorator;
import org.openmetadata.service.formatter.field.DefaultFieldFormatter;
import org.openmetadata.service.resources.feeds.MessageParser;

public class TagFormatter
extends DefaultFieldFormatter {
    public TagFormatter(MessageDecorator<?> messageDecorator, String fieldOldValue, String fieldNewValue, String fieldChangeName, MessageParser.EntityLink entityLink) {
        super(messageDecorator, fieldOldValue, fieldNewValue, fieldChangeName, entityLink);
    }

    @Override
    public String formatAddedField() {
        Object message = this.getMessageDecorator().httpAddMarker() + this.getFieldNewValue() + this.getMessageDecorator().httpAddMarker();
        message = this.getEntityLink().getArrayFieldName() != null && this.getEntityLink().getArrayFieldValue() != null ? String.format("Added " + this.getMessageDecorator().getBold() + " to " + this.getTransformedName(this.getEntityLink().getFieldName()) + " " + this.getMessageDecorator().getBold() + ": %s", this.getEntityLink().getArrayFieldValue(), this.getEntityLink().getArrayFieldName(), message) : String.format("Added " + this.getMessageDecorator().getBold() + ": %s", this.getFieldChangeName(), message);
        String spanAdd = this.getMessageDecorator().getAddMarker();
        String spanAddClose = this.getMessageDecorator().getAddMarkerClose();
        if (message != null) {
            message = this.getMessageDecorator().replaceMarkers((String)message, this.getMessageDecorator().httpAddMarker(), spanAdd, spanAddClose);
        }
        return message;
    }

    @Override
    public String formatUpdatedField() {
        Object diff = this.getMessageDecorator().httpRemoveMarker() + this.getFieldOldValue() + this.getMessageDecorator().httpRemoveMarker() + " changed to " + this.getMessageDecorator().httpAddMarker() + this.getFieldNewValue() + this.getMessageDecorator().httpAddMarker();
        String spanAdd = this.getMessageDecorator().getAddMarker();
        String spanAddClose = this.getMessageDecorator().getAddMarkerClose();
        String spanRemove = this.getMessageDecorator().getRemoveMarker();
        String spanRemoveClose = this.getMessageDecorator().getRemoveMarkerClose();
        diff = this.getMessageDecorator().replaceMarkers((String)diff, this.getMessageDecorator().httpAddMarker(), spanAdd, spanAddClose);
        diff = this.getMessageDecorator().replaceMarkers((String)diff, this.getMessageDecorator().httpRemoveMarker(), spanRemove, spanRemoveClose);
        String message = this.getEntityLink().getArrayFieldName() != null && this.getEntityLink().getArrayFieldValue() != null ? String.format("Updated " + this.getMessageDecorator().getBold() + " of " + this.getTransformedName(this.getEntityLink().getFieldName()) + " " + this.getMessageDecorator().getBold() + ": %s", this.getEntityLink().getArrayFieldValue(), this.getEntityLink().getArrayFieldName(), diff) : String.format("Updated " + this.getMessageDecorator().getBold() + ": %s", this.getFieldChangeName(), diff);
        return String.format(message, this.getFieldChangeName());
    }

    @Override
    public String formatDeletedField() {
        Object message = this.getMessageDecorator().httpRemoveMarker() + this.getFieldOldValue() + this.getMessageDecorator().httpRemoveMarker();
        message = this.getEntityLink().getArrayFieldName() != null && this.getEntityLink().getArrayFieldValue() != null ? String.format("Deleted " + this.getMessageDecorator().getBold() + " from " + this.getTransformedName(this.getEntityLink().getFieldName()) + " " + this.getMessageDecorator().getBold() + ": %s", this.getEntityLink().getArrayFieldValue(), this.getEntityLink().getArrayFieldName(), message) : String.format("Deleted " + this.getMessageDecorator().getBold() + ": %s", this.getFieldChangeName(), message);
        String spanAdd = this.getMessageDecorator().getRemoveMarker();
        String spanAddClose = this.getMessageDecorator().getRemoveMarkerClose();
        if (message != null) {
            message = this.getMessageDecorator().replaceMarkers((String)message, this.getMessageDecorator().httpRemoveMarker(), spanAdd, spanAddClose);
        }
        return message;
    }

    private String getTransformedName(String fieldName) {
        if ("columns".equals(fieldName)) {
            return "column";
        }
        return fieldName;
    }
}

