/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.jdbi3;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.openmetadata.common.utils.CommonUtil;
import org.openmetadata.schema.type.Column;
import org.openmetadata.schema.type.Field;
import org.openmetadata.schema.type.TagLabel;
import org.openmetadata.service.exception.CatalogExceptionMessage;
import org.openmetadata.service.util.FullyQualifiedName;

public final class ColumnUtil {
    private ColumnUtil() {
    }

    public static List<Column> cloneWithoutTags(List<Column> columns) {
        if (CommonUtil.nullOrEmpty(columns)) {
            return columns;
        }
        ArrayList<Column> copy = new ArrayList<Column>();
        columns.forEach(c -> copy.add(ColumnUtil.cloneWithoutTags(c)));
        return copy;
    }

    private static Column cloneWithoutTags(Column column) {
        List<Column> children = ColumnUtil.cloneWithoutTags(column.getChildren());
        return new Column().withDescription(column.getDescription()).withName(column.getName()).withDisplayName(column.getDisplayName()).withFullyQualifiedName(column.getFullyQualifiedName()).withArrayDataType(column.getArrayDataType()).withConstraint(column.getConstraint()).withDataTypeDisplay(column.getDataTypeDisplay()).withDataType(column.getDataType()).withDataLength(column.getDataLength()).withPrecision(column.getPrecision()).withScale(column.getScale()).withOrdinalPosition(column.getOrdinalPosition()).withChildren(children);
    }

    public static void setColumnFQN(String parentFQN, List<Column> columns) {
        columns.forEach(c -> {
            String columnFqn = FullyQualifiedName.add(parentFQN, c.getName());
            c.setFullyQualifiedName(columnFqn);
            if (c.getChildren() != null) {
                ColumnUtil.setColumnFQN(columnFqn, c.getChildren());
            }
        });
    }

    public static void validateColumnFQN(List<Column> columns, String columnFQN) {
        boolean exists = CommonUtil.findChildren(columns, (String)"getChildren", (String)columnFQN);
        if (!exists) {
            throw new IllegalArgumentException(CatalogExceptionMessage.invalidColumnFQN(columnFQN));
        }
    }

    public static void validateFieldFQN(List<Field> fields, String fieldFQN) {
        boolean exists = CommonUtil.findChildren(fields, (String)"getChildren", (String)fieldFQN);
        if (!exists) {
            throw new IllegalArgumentException(CatalogExceptionMessage.invalidFieldName("field", fieldFQN));
        }
    }

    public static Set<String> getAllTags(Column column) {
        HashSet<String> tags = new HashSet<String>();
        if (!CommonUtil.listOrEmpty((List)column.getTags()).isEmpty()) {
            tags.addAll(column.getTags().stream().map(TagLabel::getTagFQN).collect(Collectors.toSet()));
        }
        for (Column c : CommonUtil.listOrEmpty((List)column.getChildren())) {
            tags.addAll(ColumnUtil.getAllTags(c));
        }
        return tags;
    }
}

