/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.jdbi3;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.UUID;
import org.apache.commons.csv.CSVPrinter;
import org.apache.commons.csv.CSVRecord;
import org.jdbi.v3.sqlobject.transaction.Transaction;
import org.openmetadata.csv.CsvUtil;
import org.openmetadata.csv.EntityCsv;
import org.openmetadata.schema.EntityInterface;
import org.openmetadata.schema.entity.data.Database;
import org.openmetadata.schema.entity.data.DatabaseSchema;
import org.openmetadata.schema.entity.services.DatabaseService;
import org.openmetadata.schema.type.DatabaseProfilerConfig;
import org.openmetadata.schema.type.EntityReference;
import org.openmetadata.schema.type.Include;
import org.openmetadata.schema.type.Relationship;
import org.openmetadata.schema.type.csv.CsvDocumentation;
import org.openmetadata.schema.type.csv.CsvFile;
import org.openmetadata.schema.type.csv.CsvHeader;
import org.openmetadata.schema.type.csv.CsvImportResult;
import org.openmetadata.service.Entity;
import org.openmetadata.service.jdbi3.DatabaseSchemaRepository;
import org.openmetadata.service.jdbi3.EntityRepository;
import org.openmetadata.service.jdbi3.ListFilter;
import org.openmetadata.service.util.EntityUtil;
import org.openmetadata.service.util.FullyQualifiedName;
import org.openmetadata.service.util.JsonUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DatabaseRepository
extends EntityRepository<Database> {
    private static final Logger LOG = LoggerFactory.getLogger(DatabaseRepository.class);
    public static final String DATABASE_PROFILER_CONFIG_EXTENSION = "database.databaseProfilerConfig";
    public static final String DATABASE_PROFILER_CONFIG = "databaseProfilerConfig";

    public DatabaseRepository() {
        super("v1/databases/", "database", Database.class, Entity.getCollectionDAO().databaseDAO(), "", "");
        this.supportsSearch = true;
    }

    @Override
    public void setFullyQualifiedName(Database database) {
        database.setFullyQualifiedName(FullyQualifiedName.build(database.getService().getName(), database.getName()));
    }

    @Override
    public void prepare(Database database, boolean update) {
        this.populateService(database);
    }

    @Override
    public void storeEntity(Database database, boolean update) {
        EntityReference service = database.getService();
        database.withService(null);
        this.store(database, update);
        database.withService(service);
    }

    @Override
    public void storeRelationships(Database database) {
        this.addServiceRelationship(database, database.getService());
    }

    private List<EntityReference> getSchemas(Database database) {
        return database == null ? null : this.findTo(database.getId(), "database", Relationship.CONTAINS, "databaseSchema");
    }

    @Override
    public EntityInterface getParentEntity(Database entity, String fields) {
        return (EntityInterface)Entity.getEntity(entity.getService(), fields, Include.ALL);
    }

    @Override
    public String exportToCsv(String name, String user) throws IOException {
        Database database = (Database)this.getByName(null, name, EntityUtil.Fields.EMPTY_FIELDS);
        DatabaseSchemaRepository repository = (DatabaseSchemaRepository)Entity.getEntityRepository("databaseSchema");
        ListFilter filter = new ListFilter(Include.NON_DELETED).addQueryParam("database", name);
        List schemas = repository.listAll(repository.getFields("owner,tags,domain"), filter);
        schemas.sort(Comparator.comparing(EntityInterface::getFullyQualifiedName));
        return new DatabaseCsv(database, user).exportCsv(schemas);
    }

    @Override
    public CsvImportResult importFromCsv(String name, String csv, boolean dryRun, String user) throws IOException {
        Database database = (Database)this.getByName(null, name, EntityUtil.Fields.EMPTY_FIELDS);
        DatabaseCsv databaseCsv = new DatabaseCsv(database, user);
        return databaseCsv.importCsv(csv, dryRun);
    }

    @Override
    public void setFields(Database database, EntityUtil.Fields fields) {
        database.setService(this.getContainer(database.getId()));
        database.setDatabaseSchemas(fields.contains("databaseSchemas") ? this.getSchemas(database) : database.getDatabaseSchemas());
        database.setDatabaseProfilerConfig(fields.contains(DATABASE_PROFILER_CONFIG) ? this.getDatabaseProfilerConfig(database) : database.getDatabaseProfilerConfig());
        if (database.getUsageSummary() == null) {
            database.setUsageSummary(fields.contains("usageSummary") ? EntityUtil.getLatestUsage(this.daoCollection.usageDAO(), database.getId()) : null);
        }
    }

    @Override
    public void clearFields(Database database, EntityUtil.Fields fields) {
        database.setDatabaseSchemas(fields.contains("databaseSchemas") ? database.getDatabaseSchemas() : null);
        database.setDatabaseProfilerConfig(fields.contains(DATABASE_PROFILER_CONFIG) ? database.getDatabaseProfilerConfig() : null);
        database.withUsageSummary(fields.contains("usageSummary") ? database.getUsageSummary() : null);
    }

    @Override
    public void restorePatchAttributes(Database original, Database updated) {
        super.restorePatchAttributes(original, updated);
        updated.withService(original.getService());
    }

    @Override
    public EntityRepository.EntityUpdater getUpdater(Database original, Database updated, EntityRepository.Operation operation) {
        return new DatabaseUpdater(original, updated, operation);
    }

    private void populateService(Database database) {
        DatabaseService service = (DatabaseService)Entity.getEntity(database.getService(), "", Include.NON_DELETED);
        database.setService(service.getEntityReference());
        database.setServiceType(service.getServiceType());
    }

    public Database addDatabaseProfilerConfig(UUID databaseId, DatabaseProfilerConfig databaseProfilerConfig) {
        Database database = (Database)this.find(databaseId, Include.NON_DELETED);
        if (databaseProfilerConfig.getProfileSampleType() != null && databaseProfilerConfig.getProfileSample() != null) {
            EntityUtil.validateProfileSample(databaseProfilerConfig.getProfileSampleType().toString(), databaseProfilerConfig.getProfileSample());
        }
        this.daoCollection.entityExtensionDAO().insert(databaseId, DATABASE_PROFILER_CONFIG_EXTENSION, DATABASE_PROFILER_CONFIG, JsonUtils.pojoToJson(databaseProfilerConfig));
        this.clearFields(database, EntityUtil.Fields.EMPTY_FIELDS);
        return database.withDatabaseProfilerConfig(databaseProfilerConfig);
    }

    public DatabaseProfilerConfig getDatabaseProfilerConfig(Database database) {
        return JsonUtils.readValue(this.daoCollection.entityExtensionDAO().getExtension(database.getId(), DATABASE_PROFILER_CONFIG_EXTENSION), DatabaseProfilerConfig.class);
    }

    public Database deleteDatabaseProfilerConfig(UUID databaseId) {
        Database database = (Database)this.find(databaseId, Include.NON_DELETED);
        this.daoCollection.entityExtensionDAO().delete(databaseId, DATABASE_PROFILER_CONFIG_EXTENSION);
        this.clearFieldsInternal(database, EntityUtil.Fields.EMPTY_FIELDS);
        return database;
    }

    public static class DatabaseCsv
    extends EntityCsv<DatabaseSchema> {
        public static final CsvDocumentation DOCUMENTATION = DatabaseCsv.getCsvDocumentation("database");
        public static final List<CsvHeader> HEADERS = DOCUMENTATION.getHeaders();
        private final Database database;

        DatabaseCsv(Database database, String user) {
            super("databaseSchema", DOCUMENTATION.getHeaders(), user);
            this.database = database;
        }

        @Override
        protected void createEntity(CSVPrinter printer, List<CSVRecord> csvRecords) throws IOException {
            DatabaseSchema schema;
            CSVRecord csvRecord = this.getNextRecord(printer, csvRecords);
            String schemaFqn = FullyQualifiedName.add(this.database.getFullyQualifiedName(), csvRecord.get(0));
            try {
                schema = (DatabaseSchema)Entity.getEntityByName("databaseSchema", schemaFqn, "*", Include.NON_DELETED);
            }
            catch (Exception ex) {
                this.importFailure(printer, DatabaseCsv.entityNotFound(0, "databaseSchema", schemaFqn), csvRecord);
                this.processRecord = false;
                return;
            }
            schema.withName(csvRecord.get(0)).withDisplayName(csvRecord.get(1)).withDescription(csvRecord.get(2)).withOwner(this.getOwner(printer, csvRecord, 3)).withTags(this.getTagLabels(printer, csvRecord, 4)).withRetentionPeriod(csvRecord.get(5)).withSourceUrl(csvRecord.get(6)).withDomain(this.getEntityReference(printer, csvRecord, 7, "domain"));
            if (this.processRecord) {
                this.createEntity(printer, csvRecord, schema);
            }
        }

        @Override
        protected void addRecord(CsvFile csvFile, DatabaseSchema entity) {
            ArrayList<String> recordList = new ArrayList<String>();
            CsvUtil.addField(recordList, entity.getName());
            CsvUtil.addField(recordList, entity.getDisplayName());
            CsvUtil.addField(recordList, entity.getDescription());
            CsvUtil.addOwner(recordList, entity.getOwner());
            CsvUtil.addTagLabels(recordList, entity.getTags());
            CsvUtil.addField(recordList, entity.getRetentionPeriod());
            CsvUtil.addField(recordList, entity.getSourceUrl());
            String domain = entity.getDomain() == null || Boolean.TRUE.equals(entity.getDomain().getInherited()) ? "" : entity.getDomain().getFullyQualifiedName();
            CsvUtil.addField(recordList, domain);
            this.addRecord(csvFile, (List<String>)recordList);
        }
    }

    public class DatabaseUpdater
    extends EntityRepository.EntityUpdater {
        public DatabaseUpdater(Database original, Database updated, EntityRepository.Operation operation) {
            super((EntityRepository)DatabaseRepository.this, (EntityInterface)original, (EntityInterface)updated, operation);
        }

        @Override
        @Transaction
        public void entitySpecificUpdate() {
            this.recordChange("retentionPeriod", ((Database)this.original).getRetentionPeriod(), ((Database)this.updated).getRetentionPeriod());
            this.recordChange("sourceUrl", ((Database)this.original).getSourceUrl(), ((Database)this.updated).getSourceUrl());
            this.recordChange("sourceHash", ((Database)this.original).getSourceHash(), ((Database)this.updated).getSourceHash());
        }
    }
}

