/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.jdbi3;

import java.util.List;
import org.jdbi.v3.sqlobject.transaction.Transaction;
import org.openmetadata.common.utils.CommonUtil;
import org.openmetadata.schema.EntityInterface;
import org.openmetadata.schema.entity.teams.Persona;
import org.openmetadata.schema.type.EntityReference;
import org.openmetadata.schema.type.Relationship;
import org.openmetadata.service.Entity;
import org.openmetadata.service.jdbi3.EntityRepository;
import org.openmetadata.service.util.EntityUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PersonaRepository
extends EntityRepository<Persona> {
    private static final Logger LOG = LoggerFactory.getLogger(PersonaRepository.class);
    static final String PERSONA_UPDATE_FIELDS = "users";
    static final String PERSONA_PATCH_FIELDS = "users";
    static final String FIELD_USERS = "users";

    public PersonaRepository() {
        super("/v1/personas", "persona", Persona.class, Entity.getCollectionDAO().personaDAO(), "users", "users");
        this.quoteFqn = true;
        this.supportsSearch = false;
    }

    @Override
    public void setFields(Persona persona, EntityUtil.Fields fields) {
        persona.setUsers(fields.contains("users") ? this.getUsers(persona) : persona.getUsers());
    }

    @Override
    public void clearFields(Persona persona, EntityUtil.Fields fields) {
        persona.setUsers(fields.contains("users") ? persona.getUsers() : null);
    }

    @Override
    public void prepare(Persona persona, boolean update) {
        this.validateUsers(persona.getUsers());
    }

    @Override
    public void storeEntity(Persona persona, boolean update) {
        List users = persona.getUsers();
        persona.withUsers(null);
        this.store(persona, update);
        persona.withUsers(users);
    }

    @Override
    public void storeRelationships(Persona persona) {
        for (EntityReference user : CommonUtil.listOrEmpty((List)persona.getUsers())) {
            this.addRelationship(persona.getId(), user.getId(), "persona", "user", Relationship.APPLIED_TO);
        }
    }

    public PersonaUpdater getUpdater(Persona original, Persona updated, EntityRepository.Operation operation) {
        return new PersonaUpdater(original, updated, operation);
    }

    private List<EntityReference> getUsers(Persona persona) {
        return this.findTo(persona.getId(), "persona", Relationship.APPLIED_TO, "user");
    }

    public class PersonaUpdater
    extends EntityRepository.EntityUpdater {
        public PersonaUpdater(Persona original, Persona updated, EntityRepository.Operation operation) {
            super((EntityRepository)PersonaRepository.this, (EntityInterface)original, (EntityInterface)updated, operation);
        }

        @Override
        public void entitySpecificUpdate() {
            this.updateUsers((Persona)this.original, (Persona)this.updated);
        }

        @Transaction
        private void updateUsers(Persona origPersona, Persona updatedPersona) {
            List origUsers = CommonUtil.listOrEmpty((List)origPersona.getUsers());
            List updatedUsers = CommonUtil.listOrEmpty((List)updatedPersona.getUsers());
            this.updateToRelationships("users", "persona", origPersona.getId(), Relationship.APPLIED_TO, "user", origUsers, updatedUsers, false);
        }
    }
}

