/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.jdbi3;

import org.openmetadata.schema.entity.data.Report;
import org.openmetadata.schema.type.EntityReference;
import org.openmetadata.service.Entity;
import org.openmetadata.service.jdbi3.EntityRepository;
import org.openmetadata.service.util.EntityUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReportRepository
extends EntityRepository<Report> {
    private static final Logger LOG = LoggerFactory.getLogger(ReportRepository.class);

    public ReportRepository() {
        super("/v1/reports/", "report", Report.class, Entity.getCollectionDAO().reportDAO(), "", "");
    }

    @Override
    public void setFields(Report report, EntityUtil.Fields fields) {
        report.setService(this.getService(report));
        if (report.getUsageSummary() == null) {
            report.withUsageSummary(fields.contains("usageSummary") ? EntityUtil.getLatestUsage(this.daoCollection.usageDAO(), report.getId()) : report.getUsageSummary());
        }
    }

    @Override
    public void clearFields(Report report, EntityUtil.Fields fields) {
        report.withUsageSummary(fields.contains("usageSummary") ? report.getUsageSummary() : null);
    }

    @Override
    public void prepare(Report report, boolean update) {
    }

    @Override
    public void storeEntity(Report report, boolean update) {
        this.store(report, update);
    }

    @Override
    public void storeRelationships(Report report) {
        this.addServiceRelationship(report, report.getService());
    }

    private EntityReference getService(Report report) {
        return null;
    }
}

