/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.migration.utils.v130;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.jdbi.v3.core.Handle;
import org.jdbi.v3.core.statement.Update;
import org.openmetadata.schema.entity.services.DatabaseService;
import org.openmetadata.service.util.JsonUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MigrationUtil {
    private static final Logger LOG = LoggerFactory.getLogger(MigrationUtil.class);
    private static final String GET_MONGO_DB_SERVICES = "SELECT id, json from dbservice_entity de WHERE serviceType = 'MongoDB'";

    private MigrationUtil() {
    }

    private static Map extractConnectionURIDetails(String connectionString) {
        LinkedHashMap<String, Object> connectionDetailsMap = new LinkedHashMap<String, Object>();
        try {
            URI uri = new URI(connectionString);
            String username = uri.getUserInfo().split(":")[0];
            String password = uri.getUserInfo().split(":")[1];
            String host = uri.getHost();
            String scheme = uri.getScheme();
            int port = uri.getPort();
            String query = uri.getQuery();
            HashMap<String, String> queryMap = new HashMap<String, String>();
            if (query != null) {
                String[] queryParams = query.split("&");
                System.out.println("Query Parameters:");
                for (String param : queryParams) {
                    queryMap.put(param.split("=")[0], param.split("=")[1]);
                }
            }
            connectionDetailsMap.put("username", username);
            connectionDetailsMap.put("password", password);
            connectionDetailsMap.put("hostPort", host + ":" + port);
            connectionDetailsMap.put("scheme", scheme);
            connectionDetailsMap.put("connectionOptions", queryMap);
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
        }
        return connectionDetailsMap;
    }

    public static void migrateMongoDBConnStr(Handle handle, String updateSqlQuery) {
        handle.createQuery(GET_MONGO_DB_SERVICES).mapToMap().forEach(row -> {
            try {
                DatabaseService mongoService = JsonUtils.readValue(row.get("json").toString(), DatabaseService.class);
                String id = row.get("id").toString();
                LinkedHashMap mongoDBConnection = (LinkedHashMap)mongoService.getConnection().getConfig();
                LinkedHashMap connDetails = (LinkedHashMap)mongoDBConnection.get("connectionDetails");
                if (connDetails != null) {
                    Map finalConnectionDetails;
                    if (connDetails.get("connectionURI") != null) {
                        String connectionURI = connDetails.get("connectionURI").toString();
                        finalConnectionDetails = MigrationUtil.extractConnectionURIDetails(connectionURI);
                    } else {
                        finalConnectionDetails = connDetails;
                    }
                    mongoDBConnection.putAll(finalConnectionDetails);
                    mongoDBConnection.remove("connectionDetails");
                    String json = JsonUtils.pojoToJson(mongoService);
                    ((Update)((Update)handle.createUpdate(updateSqlQuery).bind("json", json)).bind("id", id)).execute();
                }
            }
            catch (Exception ex) {
                LOG.warn("Error during the MongoDB migration due to ", (Throwable)ex);
            }
        });
    }
}

