/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.search.indexes;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.openmetadata.common.utils.CommonUtil;
import org.openmetadata.schema.type.ColumnLineage;
import org.openmetadata.schema.type.EntityReference;
import org.openmetadata.schema.type.Include;
import org.openmetadata.schema.type.LineageDetails;
import org.openmetadata.schema.type.Relationship;
import org.openmetadata.service.Entity;
import org.openmetadata.service.jdbi3.CollectionDAO;
import org.openmetadata.service.search.indexes.ContainerIndex;
import org.openmetadata.service.search.indexes.DashboardDataModelIndex;
import org.openmetadata.service.search.indexes.DashboardIndex;
import org.openmetadata.service.search.indexes.DataProductIndex;
import org.openmetadata.service.search.indexes.GlossaryTermIndex;
import org.openmetadata.service.search.indexes.MlModelIndex;
import org.openmetadata.service.search.indexes.PipelineIndex;
import org.openmetadata.service.search.indexes.SearchEntityIndex;
import org.openmetadata.service.search.indexes.TableIndex;
import org.openmetadata.service.search.indexes.TagIndex;
import org.openmetadata.service.search.indexes.TopicIndex;
import org.openmetadata.service.util.FullyQualifiedName;
import org.openmetadata.service.util.JsonUtils;

public interface SearchIndex {
    public Map<String, Object> buildESDoc();

    default public Set<String> getFQNParts(String fqn, List<String> fqnSplits) {
        HashSet<String> fqnParts = new HashSet<String>();
        fqnParts.add(fqn);
        String parent = FullyQualifiedName.getParentFQN(fqn);
        while (parent != null) {
            fqnParts.add(parent);
            parent = FullyQualifiedName.getParentFQN(parent);
        }
        fqnParts.addAll(fqnSplits);
        return fqnParts;
    }

    default public EntityReference getEntityWithDisplayName(EntityReference entity) {
        EntityReference cloneEntity;
        if (entity == null) {
            return null;
        }
        cloneEntity.setDisplayName(CommonUtil.nullOrEmpty((String)(cloneEntity = JsonUtils.deepCopy(entity, EntityReference.class)).getDisplayName()) ? cloneEntity.getName() : cloneEntity.getDisplayName());
        return cloneEntity;
    }

    public static List<HashMap<String, Object>> getLineageData(EntityReference entity) {
        ArrayList<HashMap<String, Object>> data = new ArrayList<HashMap<String, Object>>();
        CollectionDAO dao = Entity.getCollectionDAO();
        List<CollectionDAO.EntityRelationshipRecord> toRelationshipsRecords = dao.relationshipDAO().findTo(entity.getId(), entity.getType(), Relationship.UPSTREAM.ordinal());
        for (CollectionDAO.EntityRelationshipRecord entityRelationshipRecord : toRelationshipsRecords) {
            EntityReference ref = Entity.getEntityReferenceById(entityRelationshipRecord.getType(), entityRelationshipRecord.getId(), Include.ALL);
            LineageDetails lineageDetails = JsonUtils.readValue(entityRelationshipRecord.getJson(), LineageDetails.class);
            SearchIndex.getLineageDataDirection(entity, ref, lineageDetails, data);
        }
        List<CollectionDAO.EntityRelationshipRecord> fromRelationshipsRecords = dao.relationshipDAO().findFrom(entity.getId(), entity.getType(), Relationship.UPSTREAM.ordinal());
        for (CollectionDAO.EntityRelationshipRecord entityRelationshipRecord : fromRelationshipsRecords) {
            EntityReference ref = Entity.getEntityReferenceById(entityRelationshipRecord.getType(), entityRelationshipRecord.getId(), Include.ALL);
            LineageDetails lineageDetails = JsonUtils.readValue(entityRelationshipRecord.getJson(), LineageDetails.class);
            SearchIndex.getLineageDataDirection(ref, entity, lineageDetails, data);
        }
        return data;
    }

    public static void getLineageDataDirection(EntityReference fromEntity, EntityReference toEntity, LineageDetails lineageDetails, List<HashMap<String, Object>> data) {
        HashMap<String, String> fromDetails = new HashMap<String, String>();
        HashMap<String, String> toDetails = new HashMap<String, String>();
        HashMap<String, Object> relationshipDetails = new HashMap<String, Object>();
        fromDetails.put("id", fromEntity.getId().toString());
        fromDetails.put("type", fromEntity.getType());
        fromDetails.put("fqn", fromEntity.getFullyQualifiedName());
        toDetails.put("id", toEntity.getId().toString());
        toDetails.put("type", toEntity.getType());
        toDetails.put("fqn", toEntity.getFullyQualifiedName());
        relationshipDetails.put("doc_id", fromEntity.getId().toString() + "-" + toEntity.getId().toString());
        relationshipDetails.put("fromEntity", fromDetails);
        relationshipDetails.put("toEntity", toDetails);
        if (lineageDetails != null) {
            relationshipDetails.put("pipeline", JsonUtils.getMap(CommonUtil.nullOrEmpty((Object)lineageDetails.getPipeline()) ? null : lineageDetails.getPipeline()));
            relationshipDetails.put("description", CommonUtil.nullOrEmpty((String)lineageDetails.getDescription()) ? null : lineageDetails.getDescription());
            if (!CommonUtil.nullOrEmpty((List)lineageDetails.getColumnsLineage())) {
                ArrayList<Map<String, Object>> colummnLineageList = new ArrayList<Map<String, Object>>();
                for (ColumnLineage columnLineage : lineageDetails.getColumnsLineage()) {
                    colummnLineageList.add(JsonUtils.getMap(columnLineage));
                }
                relationshipDetails.put("columns", colummnLineageList);
            }
            relationshipDetails.put("sqlQuery", CommonUtil.nullOrEmpty((String)lineageDetails.getSqlQuery()) ? null : lineageDetails.getSqlQuery());
            relationshipDetails.put("source", CommonUtil.nullOrEmpty((Object)lineageDetails.getSource()) ? null : lineageDetails.getSource());
        }
        data.add(relationshipDetails);
    }

    public static Map<String, Float> getDefaultFields() {
        HashMap<String, Float> fields = new HashMap<String, Float>();
        fields.put("displayName", Float.valueOf(10.0f));
        fields.put("displayName.ngram", Float.valueOf(1.0f));
        fields.put("name", Float.valueOf(10.0f));
        fields.put("name.ngram", Float.valueOf(1.0f));
        fields.put("displayName.keyword", Float.valueOf(8.0f));
        fields.put("name.keyword", Float.valueOf(8.0f));
        fields.put("description", Float.valueOf(2.0f));
        fields.put("fullyQualifiedName", Float.valueOf(5.0f));
        fields.put("fqnParts", Float.valueOf(5.0f));
        return fields;
    }

    public static Map<String, Float> getAllFields() {
        Map<String, Float> fields = SearchIndex.getDefaultFields();
        fields.putAll(TableIndex.getFields());
        fields.putAll(DashboardIndex.getFields());
        fields.putAll(DashboardDataModelIndex.getFields());
        fields.putAll(PipelineIndex.getFields());
        fields.putAll(TopicIndex.getFields());
        fields.putAll(MlModelIndex.getFields());
        fields.putAll(ContainerIndex.getFields());
        fields.putAll(SearchEntityIndex.getFields());
        fields.putAll(GlossaryTermIndex.getFields());
        fields.putAll(TagIndex.getFields());
        fields.putAll(DataProductIndex.getFields());
        return fields;
    }
}

