/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.util;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import javax.net.ssl.SSLContext;
import org.apache.http.ssl.SSLContextBuilder;
import org.apache.http.ssl.SSLContexts;
import org.openmetadata.service.exception.UnhandledServerException;

public class SSLUtil {
    private SSLUtil() {
    }

    public static SSLContext createSSLContext(String truststorePath, String trustStorePassword, String client) throws KeyStoreException {
        if (truststorePath != null && !truststorePath.isEmpty() && trustStorePassword != null && !trustStorePassword.isEmpty()) {
            SSLContext sSLContext;
            block9: {
                Path trustStorePath = Paths.get(truststorePath, new String[0]);
                KeyStore truststore = KeyStore.getInstance("jks");
                InputStream is = Files.newInputStream(trustStorePath, new OpenOption[0]);
                try {
                    truststore.load(is, trustStorePassword.toCharArray());
                    SSLContextBuilder sslBuilder = SSLContexts.custom().loadTrustMaterial(truststore, null);
                    sSLContext = sslBuilder.build();
                    if (is == null) break block9;
                }
                catch (Throwable throwable) {
                    try {
                        if (is != null) {
                            try {
                                is.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException | KeyManagementException | KeyStoreException | NoSuchAlgorithmException | CertificateException e) {
                        throw new UnhandledServerException(String.format("Failed to create SSLContext for [%s]", client), e);
                    }
                }
                is.close();
            }
            return sSLContext;
        }
        return null;
    }
}

