/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.events;

import java.util.ArrayList;
import java.util.List;
import org.openmetadata.schema.type.ChangeEvent;
import org.openmetadata.service.events.EventPubSub;
import org.openmetadata.service.events.EventPublisher;
import org.openmetadata.service.events.errors.RetriableException;
import org.openmetadata.service.resources.events.EventResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractEventPublisher
implements EventPublisher {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractEventPublisher.class);
    protected static final int BACKOFF_NORMAL = 0;
    protected static final int BACKOFF_3_SECONDS = 3000;
    protected static final int BACKOFF_30_SECONDS = 30000;
    protected static final int BACKOFF_5_MINUTES = 300000;
    protected static final int BACKOFF_1_HOUR = 3600000;
    protected static final int BACKOFF_24_HOUR = 86400000;
    protected int currentBackoffTime = 0;
    protected final List<ChangeEvent> batch = new ArrayList<ChangeEvent>();
    private final int batchSize;

    protected AbstractEventPublisher(int batchSize) {
        this.batchSize = batchSize;
    }

    public void onEvent(EventPubSub.ChangeEventHolder changeEventHolder, long sequence, boolean endOfBatch) throws Exception {
        ChangeEvent changeEvent = changeEventHolder.getEvent();
        this.batch.add(changeEventHolder.getEvent());
        if (!endOfBatch && this.batch.size() < this.batchSize) {
            return;
        }
        EventResource.EventList list = new EventResource.EventList(this.batch, null, null, this.batch.size());
        try {
            this.publish(list);
            this.batch.clear();
        }
        catch (RetriableException ex) {
            this.setNextBackOff();
            LOG.error("Failed to publish event {} due to {}, will try again in {} ms", new Object[]{changeEvent, ex, this.currentBackoffTime});
            Thread.sleep(this.currentBackoffTime);
        }
        catch (Exception e) {
            LOG.error("Failed to publish event type {} for entity {}", (Object)changeEvent.getEventType(), (Object)changeEvent.getEntityType());
            LOG.error(e.getMessage(), (Throwable)e);
        }
    }

    protected void setNextBackOff() {
        if (this.currentBackoffTime == 0) {
            this.currentBackoffTime = 3000;
        } else if (this.currentBackoffTime == 3000) {
            this.currentBackoffTime = 30000;
        } else if (this.currentBackoffTime == 30000) {
            this.currentBackoffTime = 300000;
        } else if (this.currentBackoffTime == 300000) {
            this.currentBackoffTime = 3600000;
        } else if (this.currentBackoffTime == 3600000) {
            this.currentBackoffTime = 86400000;
        }
    }
}

