/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.formatter.entity;

import java.text.SimpleDateFormat;
import java.util.Date;
import org.openmetadata.schema.EntityInterface;
import org.openmetadata.schema.entity.services.ingestionPipelines.PipelineStatus;
import org.openmetadata.schema.type.FieldChange;
import org.openmetadata.service.formatter.decorators.MessageDecorator;
import org.openmetadata.service.formatter.entity.EntityFormatter;
import org.openmetadata.service.formatter.util.FormatterUtil;
import org.openmetadata.service.util.JsonUtils;

public class IngestionPipelineFormatter
implements EntityFormatter {
    private static final String PIPELINE_STATUS_FIELD = "pipelineStatus";

    @Override
    public String format(MessageDecorator<?> messageFormatter, FieldChange fieldChange, EntityInterface entity, FormatterUtil.CHANGE_TYPE changeType) {
        if (PIPELINE_STATUS_FIELD.equals(fieldChange.getName())) {
            return this.transformIngestionPipelineStatus(messageFormatter, fieldChange, entity);
        }
        return FormatterUtil.transformMessage(messageFormatter, fieldChange, entity, changeType);
    }

    private String transformIngestionPipelineStatus(MessageDecorator<?> messageFormatter, FieldChange fieldChange, EntityInterface entity) {
        String ingestionPipelineName = entity.getName();
        PipelineStatus status = JsonUtils.readOrConvertValue(fieldChange.getNewValue(), PipelineStatus.class);
        if (status != null) {
            String date = new SimpleDateFormat("dd/MM/yyyy HH:mm:ss").format(new Date(status.getTimestamp()));
            String format = String.format("Ingestion Pipeline %s %s at %s", messageFormatter.getBold(), messageFormatter.getBold(), date);
            return String.format(format, ingestionPipelineName, status.getPipelineState());
        }
        String format = String.format("Ingestion Pipeline %s is updated", messageFormatter.getBold());
        return String.format(format, ingestionPipelineName);
    }
}

