/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.jdbi3;

import org.openmetadata.schema.type.TaskStatus;
import org.openmetadata.schema.type.ThreadType;
import org.openmetadata.service.jdbi3.FeedRepository;
import org.openmetadata.service.util.RestUtil;

public class FeedFilter {
    private ThreadType threadType;
    private Boolean activeAnnouncement;
    private TaskStatus taskStatus;
    private Boolean resolved;
    private FeedRepository.FilterType filterType;
    private FeedRepository.PaginationType paginationType;
    private String before;
    private String after;

    public String getCondition() {
        return this.getCondition(true);
    }

    public String getCondition(boolean includePagination) {
        String condition1 = "";
        if (this.threadType != null) {
            condition1 = String.format("type = '%s'", this.threadType.value());
            if (ThreadType.Announcement.equals((Object)this.threadType) && this.activeAnnouncement != null) {
                long now = System.currentTimeMillis() / 1000L;
                String condition2 = this.activeAnnouncement != false ? String.format("%s BETWEEN announcementStart AND announcementEnd", now) : String.format("%s NOT BETWEEN announcementStart AND announcementEnd", now);
                condition1 = this.addCondition(condition1, condition2);
            } else if (ThreadType.Task.equals((Object)this.threadType) && this.taskStatus != null) {
                String condition2 = String.format("taskStatus = '%s'", this.taskStatus);
                condition1 = this.addCondition(condition1, condition2);
            }
        }
        condition1 = this.addCondition(condition1, this.resolved == null ? "" : String.format("resolved = %s", this.resolved));
        if (this.paginationType != null && includePagination) {
            String paginationCondition = this.paginationType == FeedRepository.PaginationType.BEFORE ? String.format("updatedAt > %s", Long.parseLong(RestUtil.decodeCursor(this.before))) : String.format("updatedAt < %s", this.after != null ? Long.parseLong(RestUtil.decodeCursor(this.after)) : Long.MAX_VALUE);
            condition1 = this.addCondition(condition1, paginationCondition);
        }
        return condition1.isEmpty() ? "WHERE TRUE" : "WHERE " + condition1;
    }

    private String addCondition(String condition1, String condition2) {
        if (condition1.isEmpty()) {
            return condition2;
        }
        if (condition2.isEmpty()) {
            return condition1;
        }
        return condition1 + " AND " + condition2;
    }

    FeedFilter(ThreadType threadType, Boolean activeAnnouncement, TaskStatus taskStatus, Boolean resolved, FeedRepository.FilterType filterType, FeedRepository.PaginationType paginationType, String before, String after) {
        this.threadType = threadType;
        this.activeAnnouncement = activeAnnouncement;
        this.taskStatus = taskStatus;
        this.resolved = resolved;
        this.filterType = filterType;
        this.paginationType = paginationType;
        this.before = before;
        this.after = after;
    }

    public static FeedFilterBuilder builder() {
        return new FeedFilterBuilder();
    }

    public ThreadType getThreadType() {
        return this.threadType;
    }

    public Boolean getActiveAnnouncement() {
        return this.activeAnnouncement;
    }

    public TaskStatus getTaskStatus() {
        return this.taskStatus;
    }

    public Boolean getResolved() {
        return this.resolved;
    }

    public FeedRepository.FilterType getFilterType() {
        return this.filterType;
    }

    public FeedRepository.PaginationType getPaginationType() {
        return this.paginationType;
    }

    public String getBefore() {
        return this.before;
    }

    public String getAfter() {
        return this.after;
    }

    public static class FeedFilterBuilder {
        private ThreadType threadType;
        private Boolean activeAnnouncement;
        private TaskStatus taskStatus;
        private Boolean resolved;
        private FeedRepository.FilterType filterType;
        private FeedRepository.PaginationType paginationType;
        private String before;
        private String after;

        FeedFilterBuilder() {
        }

        public FeedFilterBuilder threadType(ThreadType threadType) {
            this.threadType = threadType;
            return this;
        }

        public FeedFilterBuilder activeAnnouncement(Boolean activeAnnouncement) {
            this.activeAnnouncement = activeAnnouncement;
            return this;
        }

        public FeedFilterBuilder taskStatus(TaskStatus taskStatus) {
            this.taskStatus = taskStatus;
            return this;
        }

        public FeedFilterBuilder resolved(Boolean resolved) {
            this.resolved = resolved;
            return this;
        }

        public FeedFilterBuilder filterType(FeedRepository.FilterType filterType) {
            this.filterType = filterType;
            return this;
        }

        public FeedFilterBuilder paginationType(FeedRepository.PaginationType paginationType) {
            this.paginationType = paginationType;
            return this;
        }

        public FeedFilterBuilder before(String before) {
            this.before = before;
            return this;
        }

        public FeedFilterBuilder after(String after) {
            this.after = after;
            return this;
        }

        public FeedFilter build() {
            return new FeedFilter(this.threadType, this.activeAnnouncement, this.taskStatus, this.resolved, this.filterType, this.paginationType, this.before, this.after);
        }

        public String toString() {
            return "FeedFilter.FeedFilterBuilder(threadType=" + this.threadType + ", activeAnnouncement=" + this.activeAnnouncement + ", taskStatus=" + this.taskStatus + ", resolved=" + this.resolved + ", filterType=" + this.filterType + ", paginationType=" + this.paginationType + ", before=" + this.before + ", after=" + this.after + ")";
        }
    }
}

