/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.jdbi3;

import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.jdbi.v3.sqlobject.transaction.Transaction;
import org.openmetadata.schema.EntityInterface;
import org.openmetadata.schema.dataInsight.ChartParameterValues;
import org.openmetadata.schema.dataInsight.DataInsightChart;
import org.openmetadata.schema.dataInsight.kpi.Kpi;
import org.openmetadata.schema.dataInsight.type.KpiResult;
import org.openmetadata.schema.dataInsight.type.KpiTarget;
import org.openmetadata.schema.type.ChangeDescription;
import org.openmetadata.schema.type.ChangeEvent;
import org.openmetadata.schema.type.DataInsightChartDataType;
import org.openmetadata.schema.type.EntityReference;
import org.openmetadata.schema.type.EventType;
import org.openmetadata.schema.type.FieldChange;
import org.openmetadata.schema.type.Include;
import org.openmetadata.schema.type.Relationship;
import org.openmetadata.service.Entity;
import org.openmetadata.service.exception.EntityNotFoundException;
import org.openmetadata.service.jdbi3.EntityRepository;
import org.openmetadata.service.jdbi3.EntityTimeSeriesDAO;
import org.openmetadata.service.util.EntityUtil;
import org.openmetadata.service.util.JsonUtils;
import org.openmetadata.service.util.RestUtil;
import org.openmetadata.service.util.ResultList;

public class KpiRepository
extends EntityRepository<Kpi> {
    private static final String KPI_RESULT_FIELD = "kpiResult";
    public static final String COLLECTION_PATH = "/v1/kpi";
    private static final String UPDATE_FIELDS = "targetDefinition,dataInsightChart,startDate,endDate,metricType";
    private static final String PATCH_FIELDS = "targetDefinition,dataInsightChart,description,startDate,endDate,metricType";
    public static final String KPI_RESULT_EXTENSION = "kpi.kpiResult";

    public KpiRepository() {
        super(COLLECTION_PATH, "kpi", Kpi.class, Entity.getCollectionDAO().kpiDAO(), PATCH_FIELDS, UPDATE_FIELDS);
    }

    @Override
    public void setFields(Kpi kpi, EntityUtil.Fields fields) {
        kpi.setDataInsightChart(fields.contains("dataInsightChart") ? this.getDataInsightChart(kpi) : kpi.getDataInsightChart());
        kpi.withKpiResult(fields.contains(KPI_RESULT_FIELD) ? this.getKpiResult(kpi.getFullyQualifiedName()) : kpi.getKpiResult());
    }

    @Override
    public void clearFields(Kpi kpi, EntityUtil.Fields fields) {
        kpi.setDataInsightChart(fields.contains("dataInsightChart") ? kpi.getDataInsightChart() : null);
        kpi.withKpiResult(fields.contains(KPI_RESULT_FIELD) ? kpi.getKpiResult() : null);
    }

    @Override
    public void prepare(Kpi kpi, boolean update) {
        DataInsightChart chart = (DataInsightChart)Entity.getEntity(kpi.getDataInsightChart(), "metrics", Include.NON_DELETED);
        kpi.setDataInsightChart(chart.getEntityReference());
        this.validateKpiTargetDefinition(kpi.getTargetDefinition(), chart.getMetrics());
    }

    private void validateKpiTargetDefinition(List<KpiTarget> kpiTargetDef, List<ChartParameterValues> dataInsightChartMetric) {
        if (kpiTargetDef.isEmpty() && !dataInsightChartMetric.isEmpty()) {
            throw new IllegalArgumentException("Parameter Values doesn't match Kpi Definition Parameters");
        }
        HashMap<String, DataInsightChartDataType> values = new HashMap<String, DataInsightChartDataType>();
        for (ChartParameterValues parameterValue : dataInsightChartMetric) {
            values.put(parameterValue.getName(), parameterValue.getChartDataType());
        }
        for (KpiTarget kpiTarget : kpiTargetDef) {
            if (values.containsKey(kpiTarget.getName())) continue;
            throw new IllegalArgumentException("Kpi Target Definition " + kpiTarget.getName() + " is not valid, metric not defined in corresponding chart");
        }
    }

    @Override
    public void storeEntity(Kpi kpi, boolean update) {
        EntityReference dataInsightChart = kpi.getDataInsightChart();
        KpiResult kpiResults = kpi.getKpiResult();
        kpi.withDataInsightChart(null).withKpiResult(null);
        this.store(kpi, update);
        kpi.withDataInsightChart(dataInsightChart).withKpiResult(kpiResults);
    }

    @Override
    public void storeRelationships(Kpi kpi) {
        this.addRelationship(kpi.getId(), kpi.getDataInsightChart().getId(), "kpi", "dataInsightChart", Relationship.USES);
    }

    @Transaction
    public RestUtil.PutResponse<?> addKpiResult(UriInfo uriInfo, String fqn, KpiResult kpiResult) {
        Kpi kpi = (Kpi)this.findByName(fqn, Include.NON_DELETED);
        this.storeTimeSeries(kpi.getFullyQualifiedName(), KPI_RESULT_EXTENSION, KPI_RESULT_FIELD, JsonUtils.pojoToJson(kpiResult));
        ChangeDescription change = this.addKpiResultChangeDescription(kpi.getVersion(), kpiResult);
        ChangeEvent changeEvent = this.getChangeEvent((EntityInterface)this.withHref(uriInfo, kpi), change, this.entityType, kpi.getVersion());
        return new RestUtil.PutResponse(Response.Status.CREATED, changeEvent, EventType.ENTITY_FIELDS_CHANGED);
    }

    @Transaction
    public RestUtil.PutResponse<?> deleteKpiResult(String fqn, Long timestamp) {
        Kpi kpi = (Kpi)this.findByName(fqn, Include.NON_DELETED);
        KpiResult storedKpiResult = JsonUtils.readValue(this.getExtensionAtTimestamp(fqn, KPI_RESULT_EXTENSION, timestamp), KpiResult.class);
        if (storedKpiResult != null) {
            this.deleteExtensionAtTimestamp(fqn, KPI_RESULT_EXTENSION, timestamp);
            kpi.setKpiResult(storedKpiResult);
            ChangeDescription change = this.deleteKpiChangeDescription(kpi.getVersion(), storedKpiResult);
            ChangeEvent changeEvent = this.getChangeEvent((EntityInterface)kpi, change, this.entityType, kpi.getVersion());
            return new RestUtil.PutResponse(Response.Status.OK, changeEvent, EventType.ENTITY_FIELDS_CHANGED);
        }
        throw new EntityNotFoundException(String.format("Failed to find kpi result for %s at %s", kpi.getName(), timestamp));
    }

    private ChangeDescription addKpiResultChangeDescription(Double version, Object newValue) {
        FieldChange fieldChange = new FieldChange().withName(KPI_RESULT_FIELD).withNewValue(newValue);
        ChangeDescription change = new ChangeDescription().withPreviousVersion(version);
        change.getFieldsAdded().add(fieldChange);
        return change;
    }

    private ChangeDescription deleteKpiChangeDescription(Double version, Object oldValue) {
        FieldChange fieldChange = new FieldChange().withName(KPI_RESULT_FIELD).withOldValue(oldValue);
        ChangeDescription change = new ChangeDescription().withPreviousVersion(version);
        change.getFieldsDeleted().add(fieldChange);
        return change;
    }

    private EntityReference getDataInsightChart(Kpi kpi) {
        return this.getToEntityRef(kpi.getId(), Relationship.USES, "dataInsightChart", true);
    }

    public KpiResult getKpiResult(String fqn) {
        return JsonUtils.readValue(this.getLatestExtensionFromTimeSeries(fqn, KPI_RESULT_EXTENSION), KpiResult.class);
    }

    public ResultList<KpiResult> getKpiResults(String fqn, Long startTs, Long endTs, EntityTimeSeriesDAO.OrderBy orderBy) {
        List<KpiResult> kpiResults = JsonUtils.readObjects(this.getResultsFromAndToTimestamps(fqn, KPI_RESULT_EXTENSION, startTs, endTs, orderBy), KpiResult.class);
        return new ResultList<KpiResult>(kpiResults, String.valueOf(startTs), String.valueOf(endTs), kpiResults.size());
    }

    private ChangeEvent getChangeEvent(EntityInterface updated, ChangeDescription change, String entityType, Double prevVersion) {
        return new ChangeEvent().withId(UUID.randomUUID()).withEntity((Object)updated).withChangeDescription(change).withEventType(EventType.ENTITY_UPDATED).withEntityType(entityType).withEntityId(updated.getId()).withEntityFullyQualifiedName(updated.getFullyQualifiedName()).withUserName(updated.getUpdatedBy()).withTimestamp(Long.valueOf(System.currentTimeMillis())).withCurrentVersion(updated.getVersion()).withPreviousVersion(prevVersion);
    }

    @Override
    public EntityRepository.EntityUpdater getUpdater(Kpi original, Kpi updated, EntityRepository.Operation operation) {
        return new KpiUpdater(original, updated, operation);
    }

    public class KpiUpdater
    extends EntityRepository.EntityUpdater {
        public KpiUpdater(Kpi original, Kpi updated, EntityRepository.Operation operation) {
            super((EntityRepository)KpiRepository.this, (EntityInterface)original, (EntityInterface)updated, operation);
        }

        @Override
        @Transaction
        public void entitySpecificUpdate() {
            this.updateToRelationship("dataInsightChart", "kpi", ((Kpi)this.original).getId(), Relationship.USES, "dataInsightChart", ((Kpi)this.original).getDataInsightChart(), ((Kpi)this.updated).getDataInsightChart(), false);
            this.recordChange("targetDefinition", ((Kpi)this.original).getTargetDefinition(), ((Kpi)this.updated).getTargetDefinition(), true);
            this.recordChange("startDate", ((Kpi)this.original).getStartDate(), ((Kpi)this.updated).getStartDate());
            this.recordChange("endDate", ((Kpi)this.original).getEndDate(), ((Kpi)this.updated).getEndDate());
            this.recordChange("metricType", ((Kpi)this.original).getMetricType(), ((Kpi)this.updated).getMetricType());
        }
    }
}

