/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.jdbi3;

import org.openmetadata.schema.entity.data.Metrics;
import org.openmetadata.schema.type.EntityReference;
import org.openmetadata.schema.type.Include;
import org.openmetadata.schema.type.Relationship;
import org.openmetadata.service.Entity;
import org.openmetadata.service.exception.CatalogExceptionMessage;
import org.openmetadata.service.jdbi3.EntityRepository;
import org.openmetadata.service.util.EntityUtil;
import org.openmetadata.service.util.FullyQualifiedName;

public class MetricsRepository
extends EntityRepository<Metrics> {
    public MetricsRepository() {
        super("/v1/metrics/", "metrics", Metrics.class, Entity.getCollectionDAO().metricsDAO(), "", "");
    }

    @Override
    public void setFullyQualifiedName(Metrics metrics) {
        metrics.setFullyQualifiedName(FullyQualifiedName.add(metrics.getService().getName(), metrics.getName()));
    }

    @Override
    public void setFields(Metrics metrics, EntityUtil.Fields fields) {
        metrics.setService(this.getContainer(metrics.getId()));
        if (metrics.getUsageSummary() == null) {
            metrics.withUsageSummary(fields.contains("usageSummary") ? EntityUtil.getLatestUsage(this.daoCollection.usageDAO(), metrics.getId()) : metrics.getUsageSummary());
        }
    }

    @Override
    public void clearFields(Metrics metrics, EntityUtil.Fields fields) {
        metrics.withUsageSummary(fields.contains("usageSummary") ? metrics.getUsageSummary() : null);
    }

    @Override
    public void prepare(Metrics metrics, boolean update) {
        metrics.setService(this.getService(metrics.getService()));
    }

    @Override
    public void storeEntity(Metrics metrics, boolean update) {
        EntityReference service = metrics.getService();
        metrics.withService(null);
        this.store(metrics, update);
        metrics.withService(service);
    }

    @Override
    public void storeRelationships(Metrics metrics) {
        EntityReference service = metrics.getService();
        this.addRelationship(service.getId(), metrics.getId(), service.getType(), "metrics", Relationship.CONTAINS);
    }

    private EntityReference getService(EntityReference service) {
        if (service.getType().equalsIgnoreCase("dashboardService")) {
            return Entity.getEntityReferenceById("databaseService", service.getId(), Include.NON_DELETED);
        }
        throw new IllegalArgumentException(CatalogExceptionMessage.invalidServiceEntity(service.getType(), "metrics", "dashboardService"));
    }
}

