/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.jdbi3;

import java.util.HashMap;
import java.util.List;
import org.openmetadata.schema.analytics.ReportData;
import org.openmetadata.service.Entity;
import org.openmetadata.service.jdbi3.CollectionDAO;
import org.openmetadata.service.jdbi3.EntityTimeSeriesRepository;
import org.openmetadata.service.util.JsonUtils;
import org.openmetadata.service.util.ResultList;

public class ReportDataRepository
extends EntityTimeSeriesRepository<ReportData> {
    public static final String COLLECTION_PATH = "/v1/analytics/report";
    public static final String REPORT_DATA_EXTENSION = "reportData.reportDataResult";

    public ReportDataRepository() {
        super(COLLECTION_PATH, Entity.getCollectionDAO().reportDataTimeSeriesDao(), ReportData.class, "entityReportData");
    }

    public ResultList<ReportData> getReportData(ReportData.ReportDataType reportDataType, Long startTs, Long endTs) {
        List<ReportData> reportData = JsonUtils.readObjects(this.timeSeriesDao.listBetweenTimestamps(reportDataType.value(), REPORT_DATA_EXTENSION, startTs, endTs), ReportData.class);
        return new ResultList<ReportData>(reportData, String.valueOf(startTs), String.valueOf(endTs), reportData.size());
    }

    public void deleteReportDataAtDate(ReportData.ReportDataType reportDataType, String date) {
        ((CollectionDAO.ReportDataTimeSeriesDAO)this.timeSeriesDao).deleteReportDataTypeAtDate(reportDataType.value(), date);
        this.cleanUpIndex(reportDataType, date);
    }

    public void deleteReportData(ReportData.ReportDataType reportDataType) {
        ((CollectionDAO.ReportDataTimeSeriesDAO)this.timeSeriesDao).deletePreviousReportData(reportDataType.value());
        this.cleanUpPreviousIndex(reportDataType);
    }

    private void cleanUpIndex(ReportData.ReportDataType reportDataType, String date) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("date_", date);
        String scriptTxt = "doc['timestamp'].value.toLocalDate() == LocalDate.parse(params.date_);";
        this.searchRepository.deleteByScript(reportDataType.toString(), scriptTxt, params);
    }

    private void cleanUpPreviousIndex(ReportData.ReportDataType reportDataType) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("reportDataType_", reportDataType.value());
        String scriptTxt = "doc['reportDataType'].value ==  params.reportDataType_";
        this.searchRepository.deleteByScript(reportDataType.toString(), scriptTxt, params);
    }
}

